/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConditionTemplateType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ItemsRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.IItemsQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.ReturnType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.ConditionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.ProductMarkup;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.Promotion;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionRulesDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.MapUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class AdditionalBuyCondition
extends AbstractBaseTemplate {
    @Override
    public boolean support(ActivityType type) {
        return ActivityType.ADDITIONAL_PURCHASE_ACTIVITY.equals((Object)type);
    }

    @Override
    public long getConditionTemplateId() {
        return ConditionTemplateType.ADDITIONAL_BUY.getId();
    }

    @Override
    public long getRuleId() {
        return 1196945569812278403L;
    }

    @Override
    public Map<String, Object> processRule(PromotionDto dto) {
        PromotionInfoDto info = (PromotionInfoDto)dto;
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        ArrayList mapList = new ArrayList(4);
        for (PromotionRulesDto rule : info.getRuleDtos()) {
            HashMap<String, Object> temp = new HashMap<String, Object>(3);
            temp.put("buyNum", rule.getDiscountValue());
            temp.put("addPrice", rule.getAddPrice());
            temp.put("priceType", rule.getPriceType());
            temp.put("limitAmount", rule.getLimitAmount());
            temp.put("condition", rule.getCondition());
            temp.put("returnType", rule.getReturnType());
            temp.put("itemId", rule.getObjCode());
            mapList.add(temp);
        }
        param.put("AdditionalBuyCondition.condition", mapList);
        param.put("AdditionalBuyCondition.type", 4);
        return param;
    }

    @Override
    public List<ConditionDto> changeToRules(ConditionRespDto conditionRespDto, PromotionInfoRespDto resp) {
        ArrayList ruleList = Lists.newArrayList();
        JSONObject conditionObj = JSON.parseObject((String)conditionRespDto.getConditionParams());
        List conditionArr = JSON.parseArray((String)conditionObj.getString("AdditionalBuyCondition.condition"), JSONObject.class);
        if (!CollectionUtils.isEmpty((Collection)conditionArr)) {
            conditionArr.forEach(condition -> {
                PromotionRulesDto rulesDto = PromotionRulesDto.defaultInstance((Map)condition);
                rulesDto.setDiscountValue(MapUtils.getString((Map)condition, (Object)"buyNum"));
                rulesDto.setReturnType(ReturnType.valueOf((String)MapUtils.getString((Map)condition, (Object)"returnType")));
                rulesDto.setAddPrice(MapUtils.getString((Map)condition, (Object)"addPrice"));
                rulesDto.setObjCode(MapUtils.getString((Map)condition, (Object)"itemId"));
                if (!StringUtils.isEmpty((Object)rulesDto.getObjCode())) {
                    ItemsRespDto item = (ItemsRespDto)((IItemsQueryApi)SpringBeanUtil.getBean(IItemsQueryApi.class)).queryByCode(rulesDto.getObjCode()).getData();
                    rulesDto.setName(item.getName());
                }
                ruleList.add(rulesDto);
            });
        }
        return ruleList;
    }

    @Override
    public void changeToLPPZPromotion(ConditionDto c, String activityId, PromotionInfoRespDto localPromotion, Promotion promotion) {
        if (!(c instanceof PromotionRulesDto)) {
            return;
        }
        promotion.getSubPromotions().clear();
        promotion.setPromType("E");
        promotion.setMarkup(true);
        PromotionRulesDto rule = (PromotionRulesDto)c;
        Promotion newP = promotion.clone();
        promotion.addSubPromotions(newP);
        ProductMarkup productMarkup = new ProductMarkup();
        productMarkup.setPriceMarkup(rule.getAddPrice());
        productMarkup.setSku(rule.getObjCode());
        newP.setMinPrice(rule.getLimitAmount());
        newP.addProdMarkups(productMarkup);
    }
}

