/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.HttpUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.response.MemberPhoneRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberExtQueryApi;
import com.dtyunxi.yundt.cube.biz.member.api.common.dto.ShopInfoDto;
import com.dtyunxi.yundt.cube.biz.member.api.common.service.IShopInfoQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCheckPointEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponExportTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponIfRealNameEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponSendTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateDirectionalTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponBatchSendReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponInvalidReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponReleaseReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponSendReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponSendTemplateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponStatisticReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponStatusMqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponUseReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.PersonalizeCouponRefReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponDynamicDateDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponPushErrorDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponPushRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponPushSuccessDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponSendRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponStatisticDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.utils.ShopTypeUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponChannelEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityCoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponAnonymousService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponCacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponEventService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponFailRecordService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponGenBatchFlowService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateStockService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.utils.SerialCodeGenerateUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityJoinLogService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityPreviewService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ActivityEngineClient;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.Checkpoint;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponExtDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.PersonalizeCouponDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.PersonalizeCouponItemDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.mapper.CouponMapper;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.mapper.PersonalizeCouponItemMapper;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.mapper.PersonalizeCouponMapper;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponAnonymousEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.PersonalizeCouponEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.PersonalizeCouponItemEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponExtServiceImpl
implements ICouponExtService {
    private final Logger logger = LoggerFactory.getLogger(CouponExtServiceImpl.class);
    private final String TEMPLATE_KEY = "temp";
    @Autowired
    private CouponDas couponDas;
    @Autowired
    private CouponMapper couponMapper;
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    private ICouponGenBatchFlowService couponGenBatchFlowService;
    @Autowired
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private IActivityQueryApi activityQueryApiImpl;
    @Autowired
    private ICouponFailRecordService couponFailRecordService;
    @Resource
    private ActivityEngineClient activityEngineClient;
    @Resource
    private IMemberExtQueryApi memberExtQueryApi;
    @Resource
    private CouponExtDas couponExtDas;
    @Autowired
    private ICouponEventService couponEventService;
    @Autowired
    private ICouponExtQueryService couponExtQueryService;
    @Autowired
    @Lazy
    private ICouponAnonymousService couponAnonymousService;
    @Autowired
    private ICouponCacheService couponCacheService;
    @Autowired
    private ICouponTemplateStockService couponTemplateStockService;
    @Autowired
    private IActivityJoinLogService activityJoinLogService;
    @Autowired
    private IShopInfoQueryApi shopInfoQueryApi;
    @Autowired
    private PersonalizeCouponItemDas personalizeCouponItemDas;
    @Autowired
    private PersonalizeCouponDas personalizeCouponDiscountDas;
    @Resource
    private PersonalizeCouponItemMapper personalizeCouponItemMapper;
    @Resource
    private PersonalizeCouponMapper personalizeCouponDiscountMapper;
    @Resource(name="send_coupon")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Resource
    private IActivityPreviewService activityPreviewService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;

    @Override
    public void invalid(Long id) {
        CouponEo update = new CouponEo();
        update.setId(id);
        update.setCouponStatus(CouponStatusEnum.INVALID.getStatus());
        this.couponDas.updateSelective((BaseEo)update);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchInvalid(List<Long> ids) {
        List<CouponExtRespDto> couponExtRespDtos = this.couponExtQueryService.listByIds(ids);
        this.processBatchInvalid(couponExtRespDtos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void asyncBatchSave(List<CouponAnonymousEo> couponAnonymousEos) {
        this.logger.info("\u6279\u91cf\u751f\u6210\u5b9e\u540d\u4f18\u60e0\u5238, couponAnonymousEos={}", (Object)couponAnonymousEos.size());
        if (CollectionUtils.isNotEmpty(couponAnonymousEos)) {
            List<CouponEo> couponEos = BeanCopyUtil.copyCollections(couponAnonymousEos, CouponEo.class, new String[0]);
            try {
                this.couponDas.insertBatch(couponEos);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        CouponDynamicDateDto dynamicDate = (CouponDynamicDateDto)JSON.parseObject((String)"{\"afterDate\":1,\"day\":1}", CouponDynamicDateDto.class);
        Integer afterDate = dynamicDate.getAfterDate() - 1;
        Integer valiDay = dynamicDate.getDay() - 1;
        Date effectiveTime = DateUtil.getDayBegin((Date)new Date());
        if (afterDate > 0) {
            effectiveTime = com.dtyunxi.util.DateUtil.addDay((Date)effectiveTime, (int)afterDate);
        }
        Date invalidTime = DateUtil.getDayEnd((Date)effectiveTime);
        if (valiDay > 0) {
            invalidTime = com.dtyunxi.util.DateUtil.addDay((Date)invalidTime, (int)valiDay);
        }
        System.out.println(simpleDateFormat.format(effectiveTime));
        System.out.println(simpleDateFormat.format(invalidTime));
    }

    @Override
    public CouponSendRespDto saveCoupon(CouponSendReqDto couponSendReqDto) {
        Date invalidTime;
        Date effectiveTime;
        Integer valiDay;
        Long couponTemplateId = couponSendReqDto.getCouponTemplateId();
        Long memberId = couponSendReqDto.getMemberId();
        CouponTemplateExtRespDto tempate = couponSendReqDto.getTemp();
        if (tempate == null) {
            tempate = this.valiCouponTempate(couponTemplateId, null);
        }
        Integer successNum = 0;
        Integer failNum = 0;
        boolean forever = false;
        if (CouponValidityTypeEnum.DYNAMIC_DATE.getType().equals(tempate.getValidityType())) {
            CouponDynamicDateDto dynamicDate = (CouponDynamicDateDto)JSON.parseObject((String)tempate.getDynamicDate(), CouponDynamicDateDto.class);
            Integer afterDate = dynamicDate.getAfterDate() - 1;
            valiDay = dynamicDate.getDay() - 1;
            effectiveTime = DateUtil.getDayBegin();
            if (afterDate > 0) {
                effectiveTime = com.dtyunxi.util.DateUtil.addDay((Date)effectiveTime, (int)afterDate);
            }
            invalidTime = DateUtil.getDayEnd((Date)effectiveTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(invalidTime);
            calendar.set(14, 0);
            invalidTime = calendar.getTime();
            if (valiDay > 0) {
                invalidTime = com.dtyunxi.util.DateUtil.addDay((Date)invalidTime, (int)valiDay);
            }
            this.logger.info("effectiveTime:{}", (Object)effectiveTime);
            this.logger.info("invalidTime:{}", (Object)invalidTime);
            if (dynamicDate.getForever() != null && dynamicDate.getForever() == 1) {
                forever = true;
            }
        } else {
            effectiveTime = tempate.getEffectiveTime();
            invalidTime = tempate.getInvalidTime();
        }
        String couponCode = SerialCodeGenerateUtil.generateCouponCode();
        CouponEo couponEo = new CouponEo();
        couponEo.setCouponCode(couponCode);
        if (memberId == null) {
            couponEo.setUserId(SerialCodeGenerateUtil.gennarateUserIdByCouponCode(couponCode));
            couponEo.setIfRealName(CouponIfRealNameEnum.NOT.getType());
        } else {
            couponEo.setUserId(memberId);
            couponEo.setIfRealName(CouponIfRealNameEnum.YES.getType());
        }
        couponEo.setCouponTemplateId(couponTemplateId);
        couponEo.setCouponTemplateCode(tempate.getCouponCode());
        couponEo.setCouponType(tempate.getCouponType());
        couponEo.setCouponValue(tempate.getCouponValue());
        couponEo.setEffectiveTime(effectiveTime);
        couponEo.setInvalidTime(invalidTime);
        couponEo.setCouponStatus(CouponStatusEnum.CREATE.getStatus());
        couponEo.setActivityId(tempate.getActivityId());
        couponEo.setAmount(tempate.getAmount());
        couponEo.setCouponName(tempate.getCouponName());
        couponEo.setReceiveTime(new Date());
        couponEo.setHierarchy(tempate.getHierarchy());
        if (!forever) {
            couponEo.setValidityType(tempate.getValidityType());
        } else {
            couponEo.setValidityType(CouponValidityTypeEnum.FOREVER_DATE.getType());
        }
        couponEo.setShopType(tempate.getShopType());
        couponEo.setTenantId(couponSendReqDto.getTenantId());
        couponEo.setInstanceId(couponSendReqDto.getInstanceId());
        couponEo.setChannel(couponSendReqDto.getChannel());
        couponEo.setOuterOrderCode(couponSendReqDto.getOuterOrderCode());
        couponEo.setActivityCode(couponSendReqDto.getActivityCode());
        this.couponDas.insert((BaseEo)couponEo);
        this.logger.info("\u53d1\u5238\u6210\u529f\uff0c\u5238\u7f16\u53f7\uff1a{}\uff0cmemberId:{},couponTemplateId:{}", new Object[]{couponEo.getCouponCode(), couponTemplateId, memberId});
        if (null != memberId && !memberId.toString().startsWith("1000000")) {
            this.couponCacheService.deleteMemberCouponCache(memberId, CouponStatusEnum.CREATE.getStatus());
        }
        valiDay = successNum;
        Integer n = successNum = Integer.valueOf(successNum + 1);
        CouponSendRespDto couponSendRespDto = new CouponSendRespDto();
        couponSendRespDto.setSuccessNum(successNum);
        couponSendRespDto.setFailNum(failNum);
        couponSendRespDto.setCouponId(couponEo.getId());
        couponSendRespDto.setCouponCode(couponEo.getCouponCode());
        couponSendRespDto.setCouponName(couponEo.getCouponName());
        return couponSendRespDto;
    }

    @Override
    public CouponSendRespDto receiveCoupon(CouponSendReqDto couponSendReqDto) {
        this.logger.info("\u4f18\u60e0\u5238\u53d1\u653e\uff08\u624b\u5de5\u9886\u53d6\uff09\uff0c\u5165\u53c2\uff1acouponSendReqDto\uff1a{}", (Object)JSON.toJSONString((Object)couponSendReqDto));
        Long memberId = couponSendReqDto.getMemberId();
        Long couponTemplateId = couponSendReqDto.getCouponTemplateId();
        CouponTemplateExtRespDto tempate = this.couponTemplateExtQueryService.queryById(couponTemplateId);
        try {
            Checkpoint checkpoint = this.activityEngineClient.defineCheckpoint(CouponCheckPointEnum.RECEIVE_COUPON.getCode());
            EngineParams engineParams = new EngineParams();
            engineParams.setActivityId(tempate.getActivityId().longValue());
            engineParams.setCouponTemplateId(tempate.getId().longValue());
            engineParams.setUserId(couponSendReqDto.getMemberId());
            if (null != couponSendReqDto.getInstanceId()) {
                engineParams.setInstanceId(couponSendReqDto.getInstanceId());
            }
            if (null != couponSendReqDto.getTenantId()) {
                engineParams.setTenantId(couponSendReqDto.getTenantId());
            }
            engineParams.getExtendsAttribute().put("channel", couponSendReqDto.getChannel());
            engineParams.getExtendsAttribute().put("received", 1);
            engineParams.setInstanceId(tempate.getInstanceId());
            engineParams.setTenantId(tempate.getTenantId());
            checkpoint.execute(engineParams);
            CouponSendRespDto couponSendRespDto = (CouponSendRespDto)engineParams.getExtendsAttribute().get("couponSendRespDto");
            return couponSendRespDto;
        }
        catch (ProBizException mbe) {
            this.couponFailRecordService.sendFailRecordMq(tempate, mbe, memberId, CouponSendTypeEnum.RECEIVE.getType());
            throw mbe;
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u5238\u5931\u8d25\uff0c\u51fa\u73b0\u7cfb\u7edf\u9519\u8bef\uff1a", (Throwable)e);
            this.couponFailRecordService.sendFailRecordMq(tempate, new ProBizException("\u7cfb\u7edf\u9519\u8bef"), memberId, CouponSendTypeEnum.RECEIVE.getType());
            throw new ProBizException("\u7cfb\u7edf\u9519\u8bef");
        }
    }

    @Override
    public CouponSendRespDto spellCoupon(CouponSendReqDto couponSendReqDto) {
        this.logger.info("\u4f18\u60e0\u5238\u53d1\u653e\uff08\u62fc\u56e2\u5238\uff09\uff0c\u5165\u53c2\uff1acouponSendReqDto\uff1a{}", (Object)JSON.toJSONString((Object)couponSendReqDto));
        Long memberId = couponSendReqDto.getMemberId();
        CouponTemplateExtRespDto tempate = this.couponTemplateExtQueryService.queryById(couponSendReqDto.getCouponTemplateId());
        try {
            Checkpoint checkpoint = this.activityEngineClient.defineCheckpoint(CouponCheckPointEnum.RECEIVE_COUPON.getCode());
            EngineParams engineParams = new EngineParams();
            engineParams.setCouponTemplateId(tempate.getId().longValue());
            engineParams.setActivityId(tempate.getActivityId().longValue());
            engineParams.setUserId(couponSendReqDto.getMemberId());
            if (null != couponSendReqDto.getInstanceId()) {
                engineParams.setInstanceId(couponSendReqDto.getInstanceId());
            }
            if (null != couponSendReqDto.getTenantId()) {
                engineParams.setTenantId(couponSendReqDto.getTenantId());
            }
            engineParams.getExtendsAttribute().put("activityCode", couponSendReqDto.getActivityCode());
            engineParams.getExtendsAttribute().put("channel", couponSendReqDto.getChannel());
            engineParams.setInstanceId(tempate.getInstanceId());
            engineParams.setTenantId(tempate.getTenantId());
            checkpoint.execute(engineParams);
            CouponSendRespDto couponSendRespDto = (CouponSendRespDto)engineParams.getExtendsAttribute().get("couponSendRespDto");
            return couponSendRespDto;
        }
        catch (ProBizException mbe) {
            this.couponFailRecordService.sendFailRecordMq(tempate, mbe, memberId, CouponSendTypeEnum.RECEIVE.getType());
            throw mbe;
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u5238\u5931\u8d25\uff0c\u51fa\u73b0\u7cfb\u7edf\u9519\u8bef\uff1a", (Throwable)e);
            this.couponFailRecordService.sendFailRecordMq(tempate, new ProBizException("\u4e2d\u53f0\u9519\u8bef"), memberId, CouponSendTypeEnum.RECEIVE.getType());
            throw new ProBizException("\u4e2d\u53f0\u9519\u8bef");
        }
    }

    @Override
    public CouponPushRespDto pushCoupon(final CouponBatchSendReqDto couponBatchSendReqDto) {
        List customerList;
        this.logger.info("\u7cfb\u7edf\u63a8\u5238\uff0c\u5165\u53c2\uff1acouponBatchSendReqDto\uff1a{}", (Object)JSON.toJSONString((Object)couponBatchSendReqDto));
        List templates = couponBatchSendReqDto.getTemplates();
        this.validCouponParams(couponBatchSendReqDto, templates);
        List memberIds = couponBatchSendReqDto.getMemberIds();
        final String activityCode = couponBatchSendReqDto.getActivityCode();
        HashMap<Long, CouponTemplateExtRespDto> tempateMap = new HashMap<Long, CouponTemplateExtRespDto>();
        Long sellerOrgId = null;
        for (CouponSendTemplateReqDto templateReq : templates) {
            CouponTemplateExtRespDto template = this.valiCouponTempate(templateReq.getCouponTemplateId(), templateReq.getCouponTemplateCode());
            if (null == template.getId()) {
                this.logger.error("\u83b7\u53d6\u4e0d\u5230\u5238\u6a21\u677f\u7684id\uff0ctemplate\uff1a{}", (Object)JSON.toJSONString((Object)template));
                throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_EXIST.getMsg());
            }
            tempateMap.put(template.getId(), template);
            templateReq.setCouponTemplateId(template.getId());
            sellerOrgId = template.getOrganizationId();
        }
        Map<Object, Object> customerIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)memberIds) && Objects.nonNull(sellerOrgId) && CollectionUtils.isNotEmpty((Collection)(customerList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByOrgIdsAndMerchantId(memberIds, sellerOrgId))))) {
            customerIdMap = customerList.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, BaseRespDto::getId, (o1, o2) -> o2));
        }
        final HashMap finalCustomerIdMap = customerIdMap;
        long startTime = System.currentTimeMillis();
        CouponPushRespDto pushRespDto = new CouponPushRespDto(Integer.valueOf(0), Integer.valueOf(0), new ArrayList(), new ArrayList());
        for (final CouponSendTemplateReqDto template : templates) {
            final Long couponTemplateId = template.getCouponTemplateId();
            final CouponTemplateExtRespDto temp = (CouponTemplateExtRespDto)tempateMap.get(couponTemplateId);
            if (null == temp) {
                this.logger.error("map\u4e2d\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u6a21\u677fid:{}\u7684\u6570\u636e\uff0ctempateMap\uff1a{}", (Object)couponTemplateId, (Object)JSON.toJSONString(tempateMap));
                throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_EXIST.getMsg());
            }
            List memberIdSplit = Lists.partition(memberIds.stream().collect(Collectors.toList()), (int)100);
            ArrayList<Future> futureList = new ArrayList<Future>();
            String checkPointCode = Optional.ofNullable(couponBatchSendReqDto.getCheckPointCode()).orElse(CouponCheckPointEnum.IC_RECEIVE_COUPON.getCode());
            final Checkpoint checkpoint = this.activityEngineClient.defineCheckpoint(checkPointCode);
            final ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApiImpl.queryActivityFatDetail(temp.getActivityId().longValue()).getData();
            for (final List members : memberIdSplit) {
                futureList.add(this.threadPoolTaskExecutor.submit((Callable)new Callable<CouponPushRespDto>(){

                    @Override
                    public CouponPushRespDto call() throws Exception {
                        return CouponExtServiceImpl.this.sendCouponByAsyn(members, template.getSendNum(), activityCode, temp, couponBatchSendReqDto, couponTemplateId, checkpoint, activityRespDto, finalCustomerIdMap);
                    }
                }));
            }
            if (null == couponBatchSendReqDto.getReturnSucess() || couponBatchSendReqDto.getReturnSucess() != 1) continue;
            for (Future future : futureList) {
                try {
                    CouponPushRespDto futureDto = (CouponPushRespDto)future.get();
                    pushRespDto.setFailNum(Integer.valueOf(pushRespDto.getFailNum() + futureDto.getFailNum()));
                    pushRespDto.setSuccessNum(Integer.valueOf(pushRespDto.getSuccessNum() + futureDto.getSuccessNum()));
                    pushRespDto.getSuccessData().addAll(futureDto.getSuccessData());
                    pushRespDto.getFailData().addAll(futureDto.getFailData());
                }
                catch (Exception e) {
                    this.logger.error("\u83b7\u53d6\u5f02\u6b65\u7ebf\u7a0b\u63a8\u9001\u7ed3\u679c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0{}", (Object)e.getMessage());
                }
            }
        }
        this.logger.info("\u672c\u6b21\u63a8\u9001\u4f18\u60e0\u5238\u4f7f\u7528\u65f6\u95f4=={}\u79d2,\u4f1a\u5458\u603b\u6570=={}", (Object)((System.currentTimeMillis() - startTime) / 1000L), (Object)memberIds.size());
        return pushRespDto;
    }

    @Override
    public CouponPushRespDto pushCouponByExternal(final CouponBatchSendReqDto couponBatchSendReqDto) {
        this.logger.info("\u5916\u90e8\u6279\u91cf\u63a8\u5238\uff0c\u5165\u53c2\uff1acouponBatchSendReqDto\uff1a{}", (Object)JSON.toJSONString((Object)couponBatchSendReqDto));
        List templates = couponBatchSendReqDto.getTemplates();
        this.validCouponParams(couponBatchSendReqDto, templates);
        List memberIds = couponBatchSendReqDto.getMemberIds();
        final String activityCode = couponBatchSendReqDto.getActivityCode();
        HashMap<Long, CouponTemplateExtRespDto> tempateMap = new HashMap<Long, CouponTemplateExtRespDto>();
        for (CouponSendTemplateReqDto templateReq : templates) {
            CouponTemplateExtRespDto template = this.valiCouponTempate(templateReq.getCouponTemplateId(), templateReq.getCouponTemplateCode());
            if (null == template.getId()) {
                this.logger.error("\u83b7\u53d6\u4e0d\u5230\u5238\u6a21\u677f\u7684id\uff0ctemplate\uff1a{}", (Object)JSON.toJSONString((Object)template));
                throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_EXIST.getMsg());
            }
            tempateMap.put(template.getId(), template);
            templateReq.setCouponTemplateId(template.getId());
        }
        long startTime = System.currentTimeMillis();
        CouponPushRespDto pushRespDto = new CouponPushRespDto(Integer.valueOf(0), Integer.valueOf(0), new ArrayList(), new ArrayList());
        final HashMap customerIdMap = new HashMap();
        for (final CouponSendTemplateReqDto template : templates) {
            final Long couponTemplateId = template.getCouponTemplateId();
            final CouponTemplateExtRespDto temp = (CouponTemplateExtRespDto)tempateMap.get(couponTemplateId);
            if (null == temp) {
                this.logger.error("map\u4e2d\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u6a21\u677fid:{}\u7684\u6570\u636e\uff0ctempateMap\uff1a{}", (Object)couponTemplateId, (Object)JSON.toJSONString(tempateMap));
                throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_EXIST.getMsg());
            }
            List memberIdSplit = Lists.partition(memberIds.stream().collect(Collectors.toList()), (int)100);
            ArrayList<Future> futureList = new ArrayList<Future>();
            String checkPointCode = Optional.ofNullable(couponBatchSendReqDto.getCheckPointCode()).orElse(CouponCheckPointEnum.IC_RECEIVE_COUPON.getCode());
            final Checkpoint checkpoint = this.activityEngineClient.defineCheckpoint(checkPointCode);
            final ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApiImpl.queryActivityFatDetail(temp.getActivityId().longValue()).getData();
            for (final List members : memberIdSplit) {
                boolean success = this.couponTemplateStockService.deductionAvailableStock(template.getCouponTemplateId(), template.getSendNum() * members.size());
                if (!success) {
                    this.logger.info("\u4f18\u60e0\u5238[{}]\u5e93\u5b58\u4e0d\u6ee1\u8db3\u8d60\u9001\u6570\u91cf[{}]\uff0c\u505c\u6b62\u8be5\u4f18\u60e0\u5238\u7684\u53d1\u653e", (Object)template.getCouponTemplateId(), (Object)template.getSendNum());
                    break;
                }
                this.couponTemplateStockService.addAvailableStock(template.getCouponTemplateId(), template.getSendNum() * members.size());
                futureList.add(this.threadPoolTaskExecutor.submit((Callable)new Callable<CouponPushRespDto>(){

                    @Override
                    public CouponPushRespDto call() throws Exception {
                        return CouponExtServiceImpl.this.sendCouponByAsyn(members, template.getSendNum(), activityCode, temp, couponBatchSendReqDto, couponTemplateId, checkpoint, activityRespDto, customerIdMap);
                    }
                }));
            }
            if (null == couponBatchSendReqDto.getReturnSucess() || couponBatchSendReqDto.getReturnSucess() != 1) continue;
            for (Future future : futureList) {
                try {
                    CouponPushRespDto futureDto = (CouponPushRespDto)future.get();
                    pushRespDto.setFailNum(Integer.valueOf(pushRespDto.getFailNum() + futureDto.getFailNum()));
                    pushRespDto.setSuccessNum(Integer.valueOf(pushRespDto.getSuccessNum() + futureDto.getSuccessNum()));
                    pushRespDto.getSuccessData().addAll(futureDto.getSuccessData());
                    pushRespDto.getFailData().addAll(futureDto.getFailData());
                }
                catch (Exception e) {
                    this.logger.error("\u83b7\u53d6\u5f02\u6b65\u7ebf\u7a0b\u63a8\u9001\u7ed3\u679c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0{}", (Object)e.getMessage());
                }
            }
        }
        this.logger.info("\u672c\u6b21\u63a8\u9001\u4f18\u60e0\u5238\u4f7f\u7528\u65f6\u95f4=={}\u79d2,\u4f1a\u5458\u603b\u6570=={}", (Object)((System.currentTimeMillis() - startTime) / 1000L), (Object)memberIds.size());
        return pushRespDto;
    }

    private void validCouponParams(CouponBatchSendReqDto couponBatchSendReqDto, List<CouponSendTemplateReqDto> templates) {
        List<CouponExtRespDto> couponExtRespDtos;
        if (CollectionUtils.isEmpty(templates)) {
            throw new ProBizException(CouponTemplateErrorEnum.PARAMS_LACK.getMsg());
        }
        if (CollectionUtils.isEmpty((Collection)couponBatchSendReqDto.getMemberIds())) {
            throw new ProBizException(CouponTemplateErrorEnum.PARAMS_LACK.getMsg());
        }
        if (!CouponChannelEnum.PIN_TUAN.getChannel().equals(couponBatchSendReqDto.getChannel()) && StringUtils.isNotBlank((CharSequence)couponBatchSendReqDto.getOuterOrderCode()) && CollectionUtils.isNotEmpty(couponExtRespDtos = this.couponExtQueryService.listByOuterOrderCode(couponBatchSendReqDto.getMemberIds(), couponBatchSendReqDto.getOuterOrderCode()))) {
            throw new ProBizException(CouponErrorEnum.OUTER_ORDER_CODE_IS_EXIST.getMsg());
        }
    }

    @Override
    public CouponPushRespDto reviceCoupon2C(CouponBatchSendReqDto couponBatchSendReqDto) {
        List customerList;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\u5546\u57ce\u9886\u5238\uff0c\u5165\u53c2\uff1a\uff1acouponBatchSendReqDto{}", (Object)JSON.toJSONString((Object)couponBatchSendReqDto));
        }
        List templates = couponBatchSendReqDto.getTemplates();
        this.validCouponParams(couponBatchSendReqDto, templates);
        List memberIds = couponBatchSendReqDto.getMemberIds();
        String activityCode = couponBatchSendReqDto.getActivityCode();
        HashMap<Long, CouponTemplateExtRespDto> tempateMap = new HashMap<Long, CouponTemplateExtRespDto>();
        Long sellerOrgId = null;
        for (CouponSendTemplateReqDto templateReq : templates) {
            CouponTemplateExtRespDto template = this.valiCouponTempate(templateReq.getCouponTemplateId(), templateReq.getCouponTemplateCode());
            if (null == template.getId()) {
                this.logger.error("\u83b7\u53d6\u4e0d\u5230\u5238\u6a21\u677f\u7684id\uff0ctemplate\uff1a{}", (Object)JSON.toJSONString((Object)template));
                throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_EXIST.getMsg());
            }
            tempateMap.put(template.getId(), template);
            templateReq.setCouponTemplateId(template.getId());
            sellerOrgId = template.getOrganizationId();
        }
        HashMap<Long, Long> customerIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)memberIds) && Objects.nonNull(sellerOrgId) && CollectionUtils.isNotEmpty((Collection)(customerList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByOrgIdsAndMerchantId(memberIds, sellerOrgId))))) {
            customerIdMap = customerList.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, BaseRespDto::getId, (o1, o2) -> o2));
        }
        long startTime = System.currentTimeMillis();
        CouponPushRespDto pushRespDto = new CouponPushRespDto(Integer.valueOf(0), Integer.valueOf(0), new ArrayList(), new ArrayList());
        for (CouponSendTemplateReqDto template : templates) {
            Long couponTemplateId = template.getCouponTemplateId();
            CouponTemplateExtRespDto temp = (CouponTemplateExtRespDto)tempateMap.get(couponTemplateId);
            if (null == temp) {
                this.logger.error("map\u4e2d\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u6a21\u677fid:{}\u7684\u6570\u636e\uff0ctempateMap\uff1a{}", (Object)couponTemplateId, (Object)JSON.toJSONString(tempateMap));
                throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_EXIST.getMsg());
            }
            String checkPointCode = Optional.ofNullable(couponBatchSendReqDto.getCheckPointCode()).orElse(CouponCheckPointEnum.IC_RECEIVE_COUPON.getCode());
            Checkpoint checkpoint = this.activityEngineClient.defineCheckpoint(checkPointCode);
            CouponPushRespDto futureDto = this.sendCouponByAsyn(memberIds, template.getSendNum(), activityCode, temp, couponBatchSendReqDto, couponTemplateId, checkpoint, null, customerIdMap);
            pushRespDto.setFailNum(Integer.valueOf(pushRespDto.getFailNum() + futureDto.getFailNum()));
            pushRespDto.setSuccessNum(Integer.valueOf(pushRespDto.getSuccessNum() + futureDto.getSuccessNum()));
            pushRespDto.getSuccessData().addAll(futureDto.getSuccessData());
            pushRespDto.getFailData().addAll(futureDto.getFailData());
        }
        this.logger.info("\u672c\u6b21\u63a8\u9001\u4f18\u60e0\u5238\u4f7f\u7528\u65f6\u95f4=={}\u79d2,\u4f1a\u5458\u603b\u6570=={}", (Object)((System.currentTimeMillis() - startTime) / 1000L), (Object)memberIds.size());
        return pushRespDto;
    }

    public CouponPushRespDto sendCouponByAsyn(List<Long> memberIds, Integer sendNum, String activityCode, CouponTemplateExtRespDto temp, CouponBatchSendReqDto couponBatchSendReqDto, Long couponTemplateId, Checkpoint checkpoint, ActivityRespDto activityRespDto, Map<Long, Long> customerIdMap) {
        Integer successNum = 0;
        Integer failNum = 0;
        ArrayList<CouponPushSuccessDto> successList = new ArrayList<CouponPushSuccessDto>();
        ArrayList<CouponPushErrorDto> failList = new ArrayList<CouponPushErrorDto>();
        for (Long memberId : memberIds) {
            for (int i = 1; i <= sendNum; ++i) {
                Integer n;
                CouponPushErrorDto pushErrorDto;
                Integer n2;
                try {
                    Integer couponSendRespDto;
                    EngineParams engineParams = new EngineParams();
                    engineParams.setCouponTemplateId(temp.getId().longValue());
                    engineParams.setActivityId(temp.getActivityId().longValue());
                    engineParams.setUserId(memberId);
                    if (customerIdMap.containsKey(memberId)) {
                        engineParams.setUserId(customerIdMap.get(memberId));
                        engineParams.setOrgId(memberId);
                    }
                    engineParams.getExtendsAttribute().put("activityCode", activityCode);
                    engineParams.getExtendsAttribute().put("received", 1);
                    engineParams.getExtendsAttribute().put("channel", couponBatchSendReqDto.getChannel());
                    engineParams.getExtendsAttribute().put("outerOrderCode", couponBatchSendReqDto.getOuterOrderCode());
                    engineParams.getExtendsAttribute().put("temp", temp);
                    engineParams.setTenantId(temp.getTenantId());
                    engineParams.setInstanceId(temp.getInstanceId());
                    engineParams.setActivityRespDto(activityRespDto);
                    checkpoint.execute(engineParams);
                    if (null != couponBatchSendReqDto.getReturnSucess() && couponBatchSendReqDto.getReturnSucess() == 1) {
                        couponSendRespDto = (CouponSendRespDto)engineParams.getExtendsAttribute().get("couponSendRespDto");
                        CouponPushSuccessDto successDto = new CouponPushSuccessDto(couponTemplateId, memberId, couponSendRespDto.getCouponId(), couponSendRespDto.getCouponCode());
                        successList.add(successDto);
                    }
                    couponSendRespDto = successNum;
                    n2 = successNum = Integer.valueOf(successNum + 1);
                    continue;
                }
                catch (ProBizException mbe) {
                    this.logger.error("\u53d1\u5238\u5931\u8d25\uff08\u7cfb\u7edf\u63a8\u5238\uff09\uff1a", (Throwable)mbe);
                    pushErrorDto = new CouponPushErrorDto(couponTemplateId, memberId, mbe.getCode(), mbe.getMessage());
                    failList.add(pushErrorDto);
                    n2 = failNum;
                    n = failNum = Integer.valueOf(failNum + 1);
                    this.couponFailRecordService.sendFailRecordMq(temp, mbe, memberId, CouponSendTypeEnum.RECEIVE.getType());
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("\u53d1\u5238\u5931\u8d25\uff0c\u51fa\u73b0\u7cfb\u7edf\u9519\u8bef\uff1a", (Throwable)e);
                    pushErrorDto = new CouponPushErrorDto(couponTemplateId, memberId, "10004", "\u4e2d\u53f0\u9519\u8bef");
                    failList.add(pushErrorDto);
                    n2 = failNum;
                    n = failNum = Integer.valueOf(failNum + 1);
                    this.couponFailRecordService.sendFailRecordMq(temp, new ProBizException("\u4e2d\u53f0\u9519\u8bef"), memberId, CouponSendTypeEnum.RECEIVE.getType());
                }
            }
        }
        CouponPushRespDto pushRespDto = new CouponPushRespDto(successNum, failNum, successList, failList);
        return pushRespDto;
    }

    private Integer getHasSendNum(Long memberId, Long couponTemplateId) {
        String sendKey = "coupon_send_num_" + couponTemplateId + "_" + memberId;
        Integer hasSendNum = (Integer)this.cacheService.getCache(sendKey, Integer.class);
        if (null == hasSendNum) {
            CouponEo select = new CouponEo();
            select.setCouponTemplateId(couponTemplateId);
            select.setUserId(memberId);
            hasSendNum = this.couponDas.count((BaseEo)select);
            this.cacheService.setCache(sendKey, (Object)hasSendNum);
        }
        return hasSendNum;
    }

    private CouponTemplateExtRespDto valiCouponTempate(Long couponTemplateId, String couponTemplateCode) {
        CouponTemplateExtRespDto tempate = null;
        if (null != couponTemplateId) {
            tempate = this.couponTemplateExtQueryService.queryById(couponTemplateId);
        } else if (StringUtils.isNotBlank((CharSequence)couponTemplateCode)) {
            tempate = this.couponTemplateExtQueryService.queryByCode(couponTemplateCode);
        }
        if (null == tempate) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_EXIST.getMsg());
        }
        if (!CouponTemplateStatusEnum.ACTIVATE.getStatus().equals(tempate.getCouponTemplateStatus())) {
            this.logger.error("\u4f18\u60e0\u5238\u53d1\u9001\u5931\u8d25\uff0c\u5238\u6a21\u677f\u4e3a\u975e\u6fc0\u6d3b\u72b6\u6001 \uff0ctempate\uff1a{}", JSON.toJSON((Object)tempate));
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_NOT_ACTIVATE.getMsg());
        }
        Date endTime = tempate.getReceiveEndTime();
        if (null != endTime && endTime.compareTo(new Date()) < 0) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_AFTER_RECEIVE_END_TIME.getMsg());
        }
        Date startTime = tempate.getReceiveStartTime();
        if (null != startTime && startTime.compareTo(new Date()) > 0) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_BEFORE_RECEIVE_START_TIME.getMsg());
        }
        return tempate;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean releaseCoupon(CouponReleaseReqDto couponReleaseReqDto) {
        this.logger.info("\u4f18\u60e0\u5238\u51b2\u6b63\u5f00\u59cb\uff1acouponLockReqDto:{}", (Object)JSON.toJSONString((Object)couponReleaseReqDto));
        if (StringUtils.isBlank((CharSequence)couponReleaseReqDto.getCouponCode())) {
            throw new ProBizException(CouponErrorEnum.COUPON_PARAMES_ERROR.getMsg());
        }
        CouponExtRespDto couponExtRespDto = this.couponExtQueryService.queryEoByCode(couponReleaseReqDto.getMemberId(), couponReleaseReqDto.getCouponCode());
        if (null == couponExtRespDto) {
            this.logger.error("\u4f18\u60e0\u5238\u51b2\u6b63\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u4f18\u60e0\u5238\u4fe1\u606f\uff0ccouponLockReqDto\uff1a{}", (Object)JSON.toJSONString((Object)couponReleaseReqDto));
            throw new ProBizException(CouponErrorEnum.COUPON_NOT_EXIST.getMsg());
        }
        if (!couponExtRespDto.getCouponStatus().equals(CouponStatusEnum.STOP.getStatus())) {
            this.logger.error("\u4f18\u60e0\u5238\u51b2\u6b63\u5931\u8d25\uff0c\u4f18\u60e0\u5238\u7684\u72b6\u6001\u4e0d\u6b63\u786e\uff0ccouponStatus:{}", (Object)couponExtRespDto.getCouponStatus());
            throw new ProBizException(CouponErrorEnum.COUPON_STATUS_ERROR.getMsg());
        }
        if (!couponReleaseReqDto.getPaymentCode().equals(couponExtRespDto.getPaymentCode())) {
            this.logger.error("\u4f18\u60e0\u5238\u51b2\u6b63\u5931\u8d25\uff0c\u4f18\u60e0\u5238\u652f\u4ed8\u7f16\u53f7\u4e0d\u6b63\u786e\uff0c\u4f18\u60e0\u5238\u652f\u4ed8\u7f16\u53f7\uff1a{}\uff0c\u5f53\u524d\u652f\u4ed8\u7f16\u53f7\uff1a{}", (Object)couponExtRespDto.getPaymentCode(), (Object)couponReleaseReqDto.getPaymentCode());
            throw new ProBizException(CouponErrorEnum.COUPON_PAYMENT_CODE_ERROR.getMsg());
        }
        this.logger.info("\u4f18\u60e0\u5238\u51b2\u6b63\u524d\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)couponExtRespDto));
        String couponStatus = CouponStatusEnum.CREATE.getStatus();
        this.couponExtDas.releaseCoupon(couponExtRespDto.getUserId(), couponExtRespDto.getCouponCode(), couponStatus);
        this.logger.info("\u4f18\u60e0\u51b2\u6b63\u6210\u529f\uff0c\u4f18\u60e0\u5238\u7f16\u53f7\uff1a{}", (Object)couponExtRespDto.getCouponCode());
        if (null != couponExtRespDto.getUserId() && !couponExtRespDto.getUserId().toString().startsWith("1000000")) {
            this.couponCacheService.deleteMemberCouponCache(couponExtRespDto.getUserId(), CouponStatusEnum.CREATE.getStatus());
            this.couponCacheService.deleteMemberCouponCache(couponExtRespDto.getUserId(), couponExtRespDto.getCouponStatus());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean releaseCouponByPaymentCode(CouponReleaseReqDto couponReleaseReqDto) {
        String paymentCode = couponReleaseReqDto.getPaymentCode();
        this.logger.info("\u4f18\u60e0\u5238\u652f\u4ed8\u51b2\u6b63\uff0c\u652f\u4ed8\u7f16\u53f7\uff1a{}", (Object)paymentCode);
        if (StringUtils.isBlank((CharSequence)paymentCode)) {
            throw new ProBizException(CouponErrorEnum.COUPON_PAYMENT_CODE_ERROR.getMsg());
        }
        List<CouponExtRespDto> list = this.couponExtQueryService.listByPaymentCode(paymentCode);
        if (CollectionUtils.isEmpty(list)) {
            this.logger.warn("\u67e5\u8be2\u4e0d\u5230\u652f\u4ed8\u7f16\u53f7\u5bf9\u5e94\u7684\u4f18\u60e0\u5238\uff0c\u652f\u4ed8\u7f16\u53f7\uff1a{}", (Object)paymentCode);
            return true;
        }
        for (CouponExtRespDto couponExtRespDto : list) {
            String couponStatus = CouponStatusEnum.CREATE.getStatus();
            this.couponExtDas.releaseCoupon(couponExtRespDto.getUserId(), couponExtRespDto.getCouponCode(), couponStatus);
            this.logger.info("\u4f18\u60e0\u5238\u652f\u4ed8\u51b2\u6b63\u6210\u529f\uff0c\u652f\u4ed8\u7f16\u53f7\uff1a{}\uff0c\u4f18\u60e0\u5238\u7f16\u53f7\uff1a{}", (Object)paymentCode, (Object)couponExtRespDto.getCouponCode());
            if (null == couponExtRespDto.getUserId() || couponExtRespDto.getUserId().toString().startsWith("1000000")) continue;
            this.couponCacheService.deleteMemberCouponCache(couponExtRespDto.getUserId(), CouponStatusEnum.CREATE.getStatus());
            this.couponCacheService.deleteMemberCouponCache(couponExtRespDto.getUserId(), couponExtRespDto.getCouponStatus());
        }
        return true;
    }

    @Override
    public List<CouponExtRespDto> useCoupon(CouponUseReqDto couponUseReqDto) {
        this.logger.info("\u4f18\u60e0\u5238\u6838\u9500\u5f00\u59cb\uff0ccouponUseReqDto\uff1a{}", (Object)JSON.toJSONString((Object)couponUseReqDto));
        Optional.ofNullable(couponUseReqDto).orElseThrow(() -> new ProBizException(CouponErrorEnum.PARAMS_EXIST.getMsg()));
        if (StringUtils.isBlank((CharSequence)couponUseReqDto.getPaymentCode())) {
            throw new ProBizException(CouponErrorEnum.COUPON_PAYMENT_CODE_ERROR.getMsg());
        }
        List<CouponExtRespDto> useCoupons = this.getEffectCouponList(couponUseReqDto);
        couponUseReqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        couponUseReqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        CouponStatusMqDto couponStatusMqDto = new CouponStatusMqDto();
        couponStatusMqDto.setCouponUseReqDto(couponUseReqDto);
        couponStatusMqDto.setCouponExtRespDtos(useCoupons);
        this.commonsMqService.sendSingleMessageAsync("coupon_status", (Object)couponStatusMqDto);
        return useCoupons;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateCouponStatus(CouponUseReqDto couponUseReqDto, List<CouponExtRespDto> useCoupons) {
        String usePhone = this.getUserPhone(couponUseReqDto);
        String useChannel = this.getUserChannel(couponUseReqDto);
        String shopName = this.getShopName(couponUseReqDto);
        Long useMemberId = couponUseReqDto.getUseMemberId();
        for (CouponExtRespDto couponExtRespDto : useCoupons) {
            CouponEo record = new CouponEo();
            record.setId(couponExtRespDto.getId());
            record.setUseMemberId(couponUseReqDto.getUseMemberId());
            record.setUseMemberNo(couponUseReqDto.getUseMemberNo());
            record.setOrderCode(couponUseReqDto.getOrderCode());
            record.setPaymentCode(couponUseReqDto.getPaymentCode());
            record.setUsePhone(usePhone);
            record.setUseChannel(useChannel);
            record.setUseStoreCode(couponUseReqDto.getUseStoreCode());
            record.setUseStoreName(shopName);
            record.setUseAmount(couponUseReqDto.getUseAmount());
            record.setUseTime(new Date());
            record.setCouponStatus(CouponStatusEnum.STOP.getStatus());
            this.logger.info("\u6838\u9500\u4f18\u60e0\u5238\uff1a{},\u66f4\u65b0\u5b57\u6bb5\u4fe1\u606f\uff1a{}", (Object)couponExtRespDto.getCouponCode(), (Object)JSON.toJSONString((Object)couponExtRespDto));
            this.couponDas.updateSelective((BaseEo)record);
            this.logger.info("\u4f18\u60e0\u5238\u6838\u9500\u6210\u529f\uff0c\u4f18\u60e0\u5238\u7f16\u53f7\uff1a{}\uff0c\u6838\u9500\u4ebamemberId:{}", (Object)couponUseReqDto.getCouponCode(), (Object)couponUseReqDto.getUseMemberId());
            if (null != couponExtRespDto.getUserId() && !couponExtRespDto.getUserId().toString().startsWith("1000000")) {
                this.couponCacheService.deleteMemberCouponCache(couponExtRespDto.getUserId(), CouponStatusEnum.CREATE.getStatus());
                this.couponCacheService.deleteMemberCouponCache(couponExtRespDto.getUserId(), CouponStatusEnum.STOP.getStatus());
            }
            if (null != useMemberId) {
                this.couponEventService.asyncProcessUseEvent(useMemberId, couponExtRespDto.getCouponTemplateId(), couponExtRespDto);
                continue;
            }
            this.logger.info("\u4f18\u60e0\u5238\u6838\u9500\u4e3a\u533f\u540d\u6838\u9500\uff0c\u672a\u89e6\u53d1\u8425\u9500\u6838\u9500\u4e8b\u4ef6");
        }
    }

    private String getUserChannel(CouponUseReqDto couponUseReqDto) {
        String useChannel = couponUseReqDto.getUseChannel();
        if (StringUtils.isBlank((CharSequence)useChannel) && StringUtils.isNotBlank((CharSequence)couponUseReqDto.getUseStoreCode())) {
            Integer storeCode = ShopTypeUtil.judge((String)couponUseReqDto.getUseStoreCode());
            useChannel = null != storeCode ? String.valueOf(storeCode) : null;
        }
        return useChannel;
    }

    private String getUserPhone(CouponUseReqDto couponUseReqDto) {
        MemberPhoneRespDto memberPhoneRespDto;
        Long useMemberId = couponUseReqDto.getUseMemberId();
        String usePhone = couponUseReqDto.getUsePhone();
        if (StringUtils.isBlank((CharSequence)couponUseReqDto.getUsePhone()) && null != useMemberId && null != (memberPhoneRespDto = (MemberPhoneRespDto)this.memberExtQueryApi.queryMemberByPhone(useMemberId).getData())) {
            usePhone = memberPhoneRespDto.getPhone();
        }
        return usePhone;
    }

    private List<CouponExtRespDto> getEffectCouponList(CouponUseReqDto couponUseReqDto) {
        Long useMemberId = couponUseReqDto.getUseMemberId();
        Map<String, CouponExtRespDto> couponMap = this.couponExtQueryService.listByCodes2Map(useMemberId, Arrays.asList(couponUseReqDto.getCouponCode()));
        if (null == couponMap || couponMap.isEmpty()) {
            throw new ProBizException(CouponErrorEnum.COUPON_NOT_EXIST.getMsg());
        }
        String[] couponCodes = couponUseReqDto.getCouponCode().split(",");
        ArrayList<CouponExtRespDto> useCoupons = new ArrayList<CouponExtRespDto>();
        Date nowTime = new Date();
        for (String couponCode : couponCodes) {
            CouponExtRespDto couponExtRespDto = couponMap.get(couponCode);
            if (null == couponExtRespDto) {
                this.logger.error("\u4f18\u60e0\u5238\u6838\u9500\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u4f18\u60e0\u5238\u7f16\u53f7\uff1a{}\u4fe1\u606f", (Object)couponUseReqDto.getCouponCode());
                throw new ProBizException(CouponErrorEnum.COUPON_NOT_EXIST.getMsg());
            }
            CouponTemplateExtRespDto couponTemplateExtRespDto = couponExtRespDto.getCouponTemplate();
            if (couponTemplateExtRespDto.getCouponTemplateStatus().equals(CouponTemplateStatusEnum.INVALID.getStatus())) {
                throw new ProBizException(CouponErrorEnum.COUPON_INVALID.getMsg());
            }
            if (null != useMemberId && CouponTemplateDirectionalTypeEnum.IS_DIRECTIONAL.getType().equals(couponTemplateExtRespDto.getIsDirectional()) && !couponExtRespDto.getUserId().equals(useMemberId)) {
                this.logger.error("\u6838\u9500\u5238\u5931\u8d25\uff0c\u5f53\u524d\u5238\u4e3a\u5b9a\u5411\u5238\uff0c\u6240\u5c5e\u7528\u6237memberId\uff1a{}\uff0c\u5f53\u524d\u4f7f\u7528\u7528\u6237memberId:{}", (Object)couponExtRespDto.getUserId(), (Object)useMemberId);
                throw new ProBizException(CouponErrorEnum.COUPON_IS_DIRECT.getMsg());
            }
            Date effectiveTime = couponExtRespDto.getEffectiveTime();
            Date invalidTime = couponExtRespDto.getInvalidTime();
            if (CouponValidityTypeEnum.FIXED_DATE.getType().equals(couponTemplateExtRespDto.getValidityType())) {
                effectiveTime = couponTemplateExtRespDto.getEffectiveTime();
                invalidTime = couponTemplateExtRespDto.getInvalidTime();
            }
            if (null == effectiveTime || effectiveTime.after(nowTime)) {
                throw new ProBizException(CouponErrorEnum.COUPON_NOT_EFFECTIVE.getMsg());
            }
            if (null == invalidTime || invalidTime.before(nowTime)) {
                throw new ProBizException(CouponErrorEnum.COUPON_INVALID.getMsg());
            }
            if (!couponExtRespDto.getCouponStatus().equals(CouponStatusEnum.CREATE.getStatus())) {
                this.logger.error("\u4f18\u60e0\u5238\u6838\u9500\u5931\u8d25\uff0c\u4f18\u60e0\u5238\u7f16\u53f7\uff1a{}\u7684\u72b6\u6001\u4e0d\u6b63\u786e\uff1a{}", (Object)couponUseReqDto.getCouponCode(), (Object)couponExtRespDto.getCouponStatus());
                throw new ProBizException(CouponErrorEnum.COUPON_STATUS_ERROR.getMsg());
            }
            useCoupons.add(couponExtRespDto);
        }
        return useCoupons;
    }

    private String getShopName(CouponUseReqDto couponUseReqDto) {
        String shopName = null;
        if (StringUtils.isNotBlank((CharSequence)couponUseReqDto.getUseStoreCode())) {
            String cache = (String)this.cacheService.getCache(couponUseReqDto.getUseStoreCode(), String.class);
            if (StringUtils.isBlank((CharSequence)cache)) {
                ShopInfoDto shop = (ShopInfoDto)this.shopInfoQueryApi.get(couponUseReqDto.getUseStoreCode()).getData();
                if (shop != null) {
                    shopName = shop.getName();
                }
                this.cacheService.setCache(couponUseReqDto.getUseStoreCode(), (Object)shopName, 600);
            } else {
                shopName = cache;
            }
        }
        return shopName;
    }

    @Override
    public CouponStatisticDto statisticCoupon(CouponStatisticReqDto couponStatisticReqDto) {
        String couponTemplateCode = couponStatisticReqDto.getCouponTemplateCode();
        CouponTemplateExtRespDto couponTemplateExtRespDto = this.couponTemplateExtQueryService.queryByCode(couponTemplateCode);
        if (null == couponTemplateExtRespDto) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_EXIST.getMsg());
        }
        String url = "/coupon/queryList?couponTemplateCode=" + couponTemplateCode;
        try {
            String json = HttpUtil.sendGet((String)url);
            if (StringUtils.isEmpty((CharSequence)json)) {
                throw new ProBizException(CouponErrorEnum.COUPON_TIME_OUT_ERROR.getMsg());
            }
            this.logger.info("\u5238\u4f7f\u7528\u603b\u89c8\u7edf\u8ba1\u8bf7\u6c42BI\u7edf\u8ba1\uff0c\u8bf7\u6c42url\uff1a{}\uff0c\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)url, (Object)json);
            JSONObject jsonObject = JSON.parseObject((String)json);
            String data = jsonObject.getString("data");
            CouponStatisticDto couponStatisticDto = (CouponStatisticDto)JSON.parseObject((String)data, CouponStatisticDto.class);
            return couponStatisticDto;
        }
        catch (ProBizException e) {
            this.logger.error("\u5238\u4f7f\u7528\u603b\u89c8\u7edf\u8ba1\u8bf7\u6c42BI\u7edf\u8ba1\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.logger.error("\u5238\u4f7f\u7528\u603b\u89c8\u7edf\u8ba1\u8bf7\u6c42BI\u7edf\u8ba1\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            throw new ProBizException(CouponErrorEnum.COUPON_STATISTIC_REQUEST_BI_ERROR.getMsg());
        }
    }

    @Override
    public String exportStatisticCoupon(CouponStatisticReqDto couponStatisticReqDto) {
        String couponTemplateCode = couponStatisticReqDto.getCouponTemplateCode();
        CouponTemplateExtRespDto couponTemplateExtRespDto = this.couponTemplateExtQueryService.queryByCode(couponTemplateCode);
        if (null == couponTemplateExtRespDto) {
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_EXIST.getMsg());
        }
        String url = "/" + CouponExportTypeEnum.getUrl((String)couponStatisticReqDto.getExportType()) + "?couponTemplateCode=" + couponTemplateCode;
        return url;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean invalidCoupon(CouponReleaseReqDto couponReleaseReqDto) {
        List<CouponExtRespDto> list;
        String couponCode = couponReleaseReqDto.getCouponCode();
        String paymentCode = couponReleaseReqDto.getPaymentCode();
        if (StringUtils.isNotBlank((CharSequence)couponCode)) {
            CouponExtRespDto couponExtRespDto = this.couponExtQueryService.queryEoByCode(couponReleaseReqDto.getMemberId(), couponReleaseReqDto.getCouponCode());
            if (null == couponExtRespDto) {
                this.logger.error("\u4f5c\u5e9f\u4f18\u60e0\u5238\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4f18\u60e0\u5238\uff0ccouponReleaseReqDto\uff1a{}", (Object)JSON.toJSONString((Object)couponReleaseReqDto));
                throw new ProBizException(CouponErrorEnum.COUPON_NOT_EXIST.getMsg());
            }
            if (CouponStatusEnum.INVALID.getStatus().equals(couponExtRespDto.getCouponStatus())) {
                throw new ProBizException(CouponErrorEnum.COUPON_INVALID.getMsg());
            }
            CouponEo record = new CouponEo();
            record.setId(couponExtRespDto.getId());
            record.setCouponStatus(CouponStatusEnum.INVALID.getStatus());
            this.couponDas.updateSelective((BaseEo)record);
            this.logger.info("\u4f18\u60e0\u5238\u4f5c\u5e9f\u6210\u529f\uff0cid:{},couponCode:{}", (Object)couponExtRespDto.getId(), (Object)couponReleaseReqDto.getCouponCode());
            if (null != couponExtRespDto.getUserId() && !couponExtRespDto.getUserId().toString().startsWith("1000000")) {
                this.couponCacheService.deleteMemberCouponCache(couponExtRespDto.getUserId(), couponExtRespDto.getCouponStatus());
                this.couponCacheService.deleteMemberCouponCache(couponExtRespDto.getUserId(), CouponStatusEnum.INVALID.getStatus());
            }
        } else if (StringUtils.isNotBlank((CharSequence)paymentCode) && CollectionUtils.isNotEmpty(list = this.couponExtQueryService.listByPaymentCode(paymentCode))) {
            for (CouponExtRespDto couponExtRespDto : list) {
                String couponStatus = couponExtRespDto.getCouponStatus();
                CouponEo record = new CouponEo();
                record.setId(couponExtRespDto.getId());
                record.setCouponStatus(CouponStatusEnum.INVALID.getStatus());
                this.couponDas.updateSelective((BaseEo)record);
                if (null == couponExtRespDto.getUserId() || couponExtRespDto.getUserId().toString().startsWith("1000000")) continue;
                this.couponCacheService.deleteMemberCouponCache(couponExtRespDto.getUserId(), couponStatus);
                this.couponCacheService.deleteMemberCouponCache(couponExtRespDto.getUserId(), CouponStatusEnum.INVALID.getStatus());
            }
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<CouponExtRespDto> reverseByOuterOrderCode(CouponReleaseReqDto couponReleaseReqDto) {
        this.logger.info("\u4f5c\u6839\u636eouterOrderCode\u56de\u6eda\u4f18\u60e0\u5238\uff0ccouponReleaseReqDto={}", (Object)JSON.toJSONString((Object)couponReleaseReqDto));
        Optional.ofNullable(couponReleaseReqDto).orElseThrow(() -> new ProBizException("\u53c2\u6570\u4e0d\u6b63\u786e"));
        List<CouponExtRespDto> couponExtRespDtos = this.couponExtQueryService.listByOuterOrderCode(couponReleaseReqDto.getMemberId(), couponReleaseReqDto.getOuterOrderCode());
        couponExtRespDtos.forEach(couponExtRespDto -> {
            CouponEo record = new CouponEo();
            record.setId(couponExtRespDto.getId());
            record.setCouponStatus(CouponStatusEnum.INVALID.getStatus());
            this.couponDas.updateSelective((BaseEo)record);
        });
        return couponExtRespDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchInvalidByCodes(List<String> couponCodes) {
        List<CouponExtRespDto> couponExtRespDtos = this.couponExtQueryService.listByCodes(null, couponCodes);
        Map couponMap = couponExtRespDtos.stream().collect(Collectors.toMap(CouponExtRespDto::getCouponCode, Function.identity()));
        List errorCodes = couponCodes.stream().filter(couponCode -> !couponMap.containsKey(couponCode)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(errorCodes)) {
            throw new BizException("\u4f18\u60e0\u5238\u7801\u4e0d\u5b58\u5728\uff1a" + StringUtils.join(errorCodes, (String)","));
        }
        this.processBatchInvalid(couponExtRespDtos);
    }

    @Override
    public void invalid(CouponInvalidReqDto couponInvalidReqDto) {
        if (null != couponInvalidReqDto && couponInvalidReqDto.getCouponInvalidTypeEnum() != null) {
            switch (couponInvalidReqDto.getCouponInvalidTypeEnum()) {
                case IDS: {
                    if (!CollectionUtils.isNotEmpty((Collection)couponInvalidReqDto.getIds())) break;
                    this.batchInvalid(couponInvalidReqDto.getIds());
                    break;
                }
                case CODES: {
                    if (!CollectionUtils.isNotEmpty((Collection)couponInvalidReqDto.getCodes())) break;
                    this.batchInvalidByCodes(couponInvalidReqDto.getCodes());
                    break;
                }
                case ACCOUNT_FLOW_ID: {
                    List<CouponExtRespDto> list = this.couponExtQueryService.listByMemberId(couponInvalidReqDto.getUserId(), couponInvalidReqDto.getCouponTemplateCodes(), couponInvalidReqDto.getActivityCodes());
                    List<Long> ids = list.stream().map(CouponExtRespDto::getId).collect(Collectors.toList());
                    this.batchInvalid(ids);
                }
            }
        }
    }

    @Override
    public Boolean shift(Long userId1, Long userId2) {
        if (userId1 == null || userId2 == null) {
            throw new ProBizException("\u53c2\u6570\u4e0d\u5b58\u5728");
        }
        List<CouponExtRespDto> couponList = this.couponExtQueryService.listByUserId(userId2, CouponStatusEnum.CREATE.getStatus());
        if (CollectionUtils.isEmpty(couponList)) {
            return true;
        }
        for (CouponExtRespDto coupon : couponList) {
            CouponEo newCouponEo = BeanCopyUtil.copyProperties(CouponEo.class, coupon, new String[0]);
            newCouponEo.setUserId(userId1);
            this.couponDas.updateSelective((BaseEo)newCouponEo);
        }
        this.couponCacheService.deleteMemberCouponCache(userId2, CouponStatusEnum.CREATE.getStatus());
        return true;
    }

    private void processBatchInvalid(List<CouponExtRespDto> couponExtRespDtos) {
        List errCodes = couponExtRespDtos.stream().filter(couponExtRespDto -> !couponExtRespDto.getCouponStatus().equals(CouponStatusEnum.CREATE.getStatus())).map(CouponExtRespDto::getCouponCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(errCodes)) {
            throw new BizException(StringUtils.join(errCodes, (String)",") + "\u4e0d\u662f\u5df2\u521b\u5efa\u72b6\u6001");
        }
        couponExtRespDtos.forEach(couponExtRespDto -> {
            CouponEo update = new CouponEo();
            update.setId(couponExtRespDto.getId());
            update.setCouponStatus(CouponStatusEnum.INVALID.getStatus());
            this.couponDas.updateSelective((BaseEo)update);
            if (null != couponExtRespDto.getUserId() && !couponExtRespDto.getUserId().toString().startsWith("1000000")) {
                this.couponCacheService.deleteMemberCouponCache(couponExtRespDto.getUserId(), CouponStatusEnum.CREATE.getStatus());
                this.couponCacheService.deleteMemberCouponCache(couponExtRespDto.getUserId(), CouponStatusEnum.INVALID.getStatus());
            }
            this.couponAnonymousService.invalid(couponExtRespDto.getId());
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deductCoupon(EngineParams params) {
        Set couponIds = Optional.ofNullable(params.getItems().stream().map(ItemVo::getCouponId).collect(Collectors.toSet())).orElse(Sets.newHashSet());
        ActivityCoupon coupon = params.getCouponByActivityId(Long.valueOf(params.getActivityId()));
        if (coupon != null && CollectionUtils.isNotEmpty((Collection)coupon.getCouponIds())) {
            couponIds.addAll(coupon.getCouponIds());
        }
        couponIds.removeIf(id -> id <= 0L);
        List<CouponExtRespDto> couponExtRespDtos = this.couponExtQueryService.listByIds(Lists.newArrayList((Iterable)couponIds));
        if (couponIds.size() != couponExtRespDtos.size()) {
            Long aLong = couponIds.stream().filter(id -> couponExtRespDtos.parallelStream().noneMatch(s -> s.getId().equals(id))).findAny().orElse(0L);
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u4f18\u60e0\u5238\u3010{}\u3011\u4e0d\u5b58\u5728", aLong.toString()}));
        }
        couponExtRespDtos.forEach(n -> {
            if (!CouponStatusEnum.CREATE.getStatus().equals(n.getCouponStatus())) {
                if (CouponStatusEnum.STOP.getStatus().equals(n.getCouponStatus())) {
                    throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u5238\u5df2\u4f7f\u7528"}));
                }
                throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u4f18\u60e0\u5238\u3010{}\u3011\u72b6\u6001\u9519\u8bef\uff0c\u4e0d\u53ef\u8fdb\u884c\u6d88\u8d39", n.getId() + ""}));
            }
        });
        Long userId = params.getUserId();
        if (params.getActivityFlag().booleanValue()) {
            userId = this.activityPreviewService.getCurrentCustomerOrgId(userId);
        }
        this.activityJoinLogService.joinInActivity(params);
        int result = this.couponDas.updateCouponStatusByUserIdAndCouponIds(userId, (List)Lists.newLinkedList((Iterable)couponIds), CouponStatusEnum.FREEZE.getStatus());
        if (result != couponIds.size()) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u4f18\u60e0\u5238\u5f52\u5c5e\u5f02\u5e38"}));
        }
        this.couponCacheService.deleteMemberCouponCache(userId, CouponStatusEnum.CREATE.getStatus());
        this.couponCacheService.deleteMemberCouponCache(userId, CouponStatusEnum.FREEZE.getStatus());
        params.getActivityCouponList().remove(coupon);
        return result;
    }

    @Override
    public void deleteCouponById(Long id) {
        this.couponMapper.deleteCouponById(id);
    }

    @Override
    public void insertCoupon(CouponEo newCouponEo) {
        this.couponDas.insert((BaseEo)newCouponEo);
    }

    @Override
    public void addPrsnRefByCouponCode(List<PersonalizeCouponRefReqDto> personalizeCouponRefReqDtos) {
        if (CollectionUtils.isNotEmpty(personalizeCouponRefReqDtos)) {
            ArrayList personalizeCouponItemEoList = Lists.newArrayList();
            ArrayList personalizeCouponEos = Lists.newArrayList();
            personalizeCouponRefReqDtos.stream().forEach(dto -> {
                if (CollectionUtils.isNotEmpty((Collection)dto.getItemIds())) {
                    dto.getItemIds().stream().forEach(itemId -> {
                        PersonalizeCouponItemEo personalizeCouponItemEo = PersonalizeCouponItemEo.newInstance();
                        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)personalizeCouponItemEo);
                        personalizeCouponItemEo.setItemId(itemId);
                        personalizeCouponItemEoList.add(personalizeCouponItemEo);
                    });
                    this.logger.info("\u4fdd\u5b58\u4f18\u60e0\u5238\u4e0e\u4e2a\u6027\u5316\u8303\u56f4\u7684\u5546\u54c1\u5173\u7cfb------------------");
                }
                if (null != dto.getCouponAmt() || null != dto.getDiscountValue() || null != dto.getLeastPayAmt()) {
                    PersonalizeCouponEo personalizeCouponEo = PersonalizeCouponEo.newInstance();
                    DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)personalizeCouponEo);
                    personalizeCouponEos.add(personalizeCouponEo);
                } else {
                    this.logger.info("\u6ca1\u6709\u7b26\u5408\u7684\u6761\u4ef6-------\u4e0d\u4fdd\u5b58");
                }
                if (CollectionUtils.isNotEmpty((Collection)personalizeCouponItemEoList)) {
                    this.personalizeCouponItemDas.insertBatch(personalizeCouponItemEoList);
                }
                if (CollectionUtils.isNotEmpty((Collection)personalizeCouponEos)) {
                    this.personalizeCouponDiscountDas.insertBatch(personalizeCouponEos);
                }
            });
        }
    }

    @Override
    public List<Long> queryCouponItemsById(Long aLong) {
        List itemIds = this.personalizeCouponItemMapper.queryCouponItemsById(aLong);
        return itemIds;
    }

    @Override
    public BigDecimal queryCouponDiscount(Long aLong) {
        BigDecimal bigDecimal = this.personalizeCouponDiscountMapper.queryCouponDiscountById(aLong);
        return bigDecimal;
    }

    @Override
    public BigDecimal queryCouponLeasPayAmt(Long aLong) {
        BigDecimal bigDecimal = this.personalizeCouponDiscountMapper.queryCouponLeasPayAmt(aLong);
        return bigDecimal;
    }

    @Override
    public BigDecimal queryCouponAmt(Long aLong) {
        BigDecimal bigDecimal = this.personalizeCouponDiscountMapper.queryCouponAmt(aLong);
        return bigDecimal;
    }
}

