/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.action.bestore;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.request.PointsTradeInfoReqDto;
import com.dtyunxi.yundt.cube.center.member.api.point.IPointsTradeApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActionTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponSendReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponSendRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponChannelEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponEventService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateStockService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ActionTemplate;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CouponReceiveAction
extends ActionTemplate {
    private static final Logger logger = LoggerFactory.getLogger(CouponReceiveAction.class);
    private final String TEMPLATE_KEY = "temp";
    @Autowired
    private ICouponExtService couponExtService;
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private ICouponTemplateStockService couponTemplateStockService;
    @Autowired
    private ICouponEventService couponEventService;
    @Resource
    private IPointsTradeApi pointsTradeApi;

    @Override
    public <T extends EngineParams> boolean execute(ActionTemplateRespDto actionTemplateDto, ActionRespDto actionDto, T params, Map<String, ?> activityParams) {
        Object tempValue;
        Long couponTemplateId = params.getCouponTemplateId();
        Integer received = (Integer)params.getExtendsAttribute().get("received");
        Integer dayReceived = (Integer)params.getExtendsAttribute().get("dayReceived");
        Long memberId = params.getUserId();
        if (Objects.nonNull(params.getOrgId())) {
            memberId = params.getOrgId();
        }
        String activityCode = (String)params.getExtendsAttribute().get("activityCode");
        String channel = (String)params.getExtendsAttribute().get("channel");
        String outerOrderCode = (String)params.getExtendsAttribute().get("outerOrderCode");
        Integer points = (Integer)MapUtils.getObject((Map)params.getExtendsAttribute(), (Object)"exchangePoint", (Object)0);
        if (points > 0) {
            this.operationPoints(memberId, 0, points, "\u9886\u5238\u6263\u51cf\u79ef\u5206");
        }
        CouponSendReqDto couponSend = new CouponSendReqDto();
        couponSend.setCouponTemplateId(couponTemplateId);
        couponSend.setMemberId(memberId);
        couponSend.setActivityCode(activityCode);
        couponSend.setChannel(channel);
        couponSend.setOuterOrderCode(outerOrderCode);
        couponSend.setTenantId(params.getTenantId());
        couponSend.setInstanceId(params.getInstanceId());
        if (params.getExtendsAttribute().containsKey("temp") && (tempValue = params.getExtendsAttribute().get("temp")) instanceof CouponTemplateExtRespDto) {
            CouponTemplateExtRespDto temp = (CouponTemplateExtRespDto)tempValue;
            couponSend.setTemp(temp);
        }
        CouponSendRespDto couponSendRespDto = null;
        try {
            couponSendRespDto = this.couponExtService.saveCoupon(couponSend);
            params.getExtendsAttribute().put("couponSendRespDto", couponSendRespDto);
            String sendKey = "coupon_send_num_" + couponTemplateId + "_" + memberId;
            String daySendKey = "coupon_send_num_day_" + couponTemplateId + "_" + memberId;
            this.cacheService.setCache(sendKey, (Object)(received + 1));
            this.cacheService.setCache(daySendKey, (Object)(dayReceived + 1));
        }
        catch (ProBizException e) {
            this.couponTemplateStockService.addAvailableStock(couponTemplateId, 1);
            this.operationPoints(memberId, 1, points, "\u9886\u5238\u5931\u8d25\u56de\u9000\u79ef\u5206");
            logger.error("\u53d1\u5238\u5931\u8d25\uff0ccouponTemplateId\uff1a{}\uff0cmemberId\uff1a{}\uff0ccode\uff1a{}\uff0cmessage\uff1a{}", new Object[]{couponTemplateId, memberId, e.getCode(), e.getMessage()});
            throw e;
        }
        if (!CouponChannelEnum.EVENT.getChannel().equals(channel) && !CouponChannelEnum.DAVIN_EVENT.getChannel().equals(channel)) {
            logger.info("\u975e\u4e8b\u4ef6\u8425\u9500\u7c7b\u53d1\u5238\uff0c\u89e6\u53d1\u9886\u5238\u4e8b\u4ef6\u8425\u9500");
            this.couponEventService.asyncProcessReceiveEvent(memberId, couponTemplateId, couponSendRespDto);
        }
        return true;
    }

    private void operationPoints(Long memberId, int type, int points, String remark) {
        PointsTradeInfoReqDto pointsTradeInfoReqDto = new PointsTradeInfoReqDto();
        pointsTradeInfoReqDto.setMemberId(memberId);
        pointsTradeInfoReqDto.setPoints(points);
        pointsTradeInfoReqDto.setTradeSource("\u5c0f\u7a0b\u5e8f");
        pointsTradeInfoReqDto.setRemark(remark);
        RestResponse response = null;
        response = type == 1 ? this.pointsTradeApi.increase(pointsTradeInfoReqDto) : this.pointsTradeApi.decrease(pointsTradeInfoReqDto);
        if (!"0".equals(response.getResultCode())) {
            throw new ProBizException(response.getResultCode(), response.getResultMsg());
        }
    }
}

