/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConditionTemplateType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IConditionQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.ObjectType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.PresentReferEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.ReturnType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.ConditionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionDepositInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionRulesDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.DepositConfigRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.service.IPresentApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.MapUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.converter.promotion.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.util.StringUtils;

public class DepositCondition
extends AbstractBaseTemplate {
    @Override
    public boolean support(ActivityType type) {
        return ActivityType.DEPOSIT_PRESENT_ACTIVITY.equals((Object)type);
    }

    @Override
    public long getConditionTemplateId() {
        return ConditionTemplateType.RECHARGE_GIFT.getId();
    }

    @Override
    public long getRuleId() {
        return 1196945569812278405L;
    }

    @Override
    public Map<String, Object> processRule(PromotionDto dto) {
        PromotionDepositInfoDto info = (PromotionDepositInfoDto)dto;
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        HashMap<String, Integer> config = new HashMap<String, Integer>();
        config.put("recycle", info.getOverdue());
        config.put("eachFullLimit", info.getUpperLimit());
        config.put("monthlyInstallment", info.getInstalment());
        config.put("postpone", info.getDelayed());
        param.put("RechargeGiftCondition.config", config);
        param.put("RechargeGiftCondition.type", info.getReturnType().name());
        ArrayList mapList = new ArrayList(4);
        for (PromotionRulesDto rule : info.getRulesDtos()) {
            HashMap<String, Object> temp = new HashMap<String, Object>(3);
            temp.put("limitAmount", rule.getLimitAmount());
            temp.put("condition", rule.getCondition());
            temp.put("returnType", rule.getReturnType());
            temp.put("num", rule.getDiscountValue());
            temp.put("discountValue", rule.getDiscountValue());
            temp.put("objId", rule.getObjectId());
            temp.put("objGroupId", rule.getObjectGroupId());
            temp.put("priceType", rule.getPriceType());
            temp.put("objectType", rule.getObjectType());
            mapList.add(temp);
        }
        param.put("RechargeGiftCondition.condition", mapList);
        return param;
    }

    @Override
    public void prepare(PromotionDto dto) {
        PromotionDepositInfoDto info = (PromotionDepositInfoDto)dto;
        IPresentApi presentApi = (IPresentApi)SpringBeanUtil.getBean(IPresentApi.class);
        if (dto.getActivityId() > 0L) {
            IConditionQueryApi conditionQueryApi = (IConditionQueryApi)SpringBeanUtil.getBean(IConditionQueryApi.class);
            List conditionRespDtos = conditionQueryApi.queryConditions((List)Lists.newArrayList((Object[])new Long[]{info.getActivityId()}), this.getConditionTemplateId());
            if (CollectionUtils.isNotEmpty((Collection)conditionRespDtos)) {
                conditionRespDtos.forEach(allCondition -> {
                    JSONObject jsonObject = JSON.parseObject((String)allCondition.getConditionParams());
                    JSONArray condition = jsonObject.getJSONArray("RechargeGiftCondition.condition");
                    if (CollectionUtils.isNotEmpty((Collection)condition)) {
                        ArrayList forDeleteItemGroupIds = Lists.newArrayList();
                        condition.forEach(detail -> {
                            JSONObject obj = (JSONObject)detail;
                            String objTypeStr = obj.getString("objectType");
                            if (!StringUtils.isEmpty((Object)objTypeStr)) {
                                ObjectType objType = ObjectType.valueOf((String)obj.getString("objectType"));
                                if (objType.equals((Object)ObjectType.SINGLE)) {
                                    forDeleteItemGroupIds.add(obj.getLong("objGroupId"));
                                } else if (objType.equals((Object)ObjectType.GROUP)) {
                                    presentApi.refer(obj.getLong("objGroupId"), PresentReferEnum.REFER);
                                }
                            }
                        });
                        if (!CollectionUtils.isEmpty((Collection)forDeleteItemGroupIds)) {
                            forDeleteItemGroupIds.forEach(id -> presentApi.deletePresentGroup(id, false));
                        }
                    }
                });
            }
        }
        this.addSinglePresentGroup(dto, info.getRulesDtos());
    }

    @Override
    public List<ConditionDto> changeToRules(ConditionRespDto conditionRespDto, PromotionInfoRespDto resp) {
        ArrayList ruleList = Lists.newArrayList();
        JSONObject conditionObj = JSON.parseObject((String)conditionRespDto.getConditionParams());
        List conditionArr = JSON.parseArray((String)conditionObj.getString("RechargeGiftCondition.condition"), JSONObject.class);
        if (CollectionUtils.isNotEmpty((Collection)conditionArr)) {
            conditionArr.forEach(condition -> {
                PromotionRulesDto rulesDto = PromotionRulesDto.defaultInstance((Map)condition);
                rulesDto.setReturnType(ReturnType.valueOf((String)MapUtils.getString((Map)condition, (Object)"returnType")));
                rulesDto.setDiscountValue(MapUtils.getString((Map)condition, (Object)"num"));
                long groupId = MapUtils.getLongValue((Map)condition, (Object)"objGroupId");
                if (groupId > 0L) {
                    if (rulesDto.getObjectType().equals((Object)ObjectType.SINGLE)) {
                        this.fillGirtGroupInfo(rulesDto, groupId, false);
                    } else {
                        this.fillGirtGroupInfo(rulesDto, groupId, true);
                    }
                }
                ruleList.add(rulesDto);
            });
            JSONObject config = conditionObj.getJSONObject("RechargeGiftCondition.config");
            DepositConfigRespDto configDto = new DepositConfigRespDto();
            configDto.setReturnType(ReturnType.valueOf((String)conditionObj.getString("RechargeGiftCondition.type")));
            if (MapUtils.isNotEmpty((Map)config)) {
                configDto.setOverdue(config.getIntValue("recycle"));
                configDto.setUpperLimit(Integer.valueOf(config.getIntValue("eachFullLimit")));
                configDto.setInstalment(config.getIntValue("monthlyInstallment"));
                configDto.setDelayed(config.getIntValue("postpone"));
            }
            resp.setDepositConfigRespDto(configDto);
        }
        return ruleList;
    }
}

