/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.constants.enums.PresentTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PresentInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PresentQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PresentDetailExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PresentDetailRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PresentListRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.query.IPresentQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.promotion.das.PresentDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.promotion.das.PresentsInfoDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.promotion.PresentsInfoEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="presentQueryService")
public class PresentQueryServiceImpl
implements IPresentQueryService {
    @Resource
    private PresentsInfoDas presentsInfoDas;
    @Resource
    private PresentDas presentDas;
    @Autowired
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;

    @Override
    public PageInfo<PresentListRespDto> queryByPage(String filters, Integer pageNum, Integer pageSize) {
        if (StringUtils.isEmpty((CharSequence)filters)) {
            filters = "{}";
        }
        PresentQueryReqDto reqDto = (PresentQueryReqDto)JSON.parseObject((String)filters, PresentQueryReqDto.class);
        PresentsInfoEo condition = new PresentsInfoEo();
        BeanUtils.copyProperties((Object)reqDto, (Object)condition);
        PageInfo pageInfo = this.presentsInfoDas.selectPage((BaseEo)condition, pageNum, pageSize);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)result, (String[])new String[]{"list"});
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            ArrayList resultList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), (Collection)resultList, PresentListRespDto.class);
            result.setList((List)resultList);
        }
        return result;
    }

    @Override
    public PresentDetailRespDto queryDetailById(Long groupId) {
        if (groupId == null) {
            return null;
        }
        PresentDetailRespDto respDto = new PresentDetailRespDto();
        PresentsInfoEo presentsInfoEo = (PresentsInfoEo)this.presentsInfoDas.selectByPrimaryKey(groupId);
        if (presentsInfoEo == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)presentsInfoEo, (Object)respDto, (String[])new String[]{"presentList"});
        List presentList = this.presentDas.queryAllPresentByGroupId(groupId);
        if (CollectionUtils.isNotEmpty((Collection)presentList)) {
            ArrayList presents = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)presents, (Collection)presentList, PresentInfoDto.class);
            respDto.setPresentList((List)presents);
        }
        return respDto;
    }

    @Override
    public PresentDetailExtRespDto queryDetailExtById(Long groupId) {
        PresentDetailExtRespDto result = new PresentDetailExtRespDto();
        PresentDetailRespDto detailRespDto = this.queryDetailById(groupId);
        if (detailRespDto != null) {
            BeanUtils.copyProperties((Object)detailRespDto, (Object)result, (String[])new String[]{"presentList"});
            List sourceList = detailRespDto.getPresentList();
            ArrayList presentList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)sourceList)) {
                sourceList.forEach(a -> {
                    PresentDetailExtRespDto.PresentListDto targetDto = new PresentDetailExtRespDto.PresentListDto();
                    BeanUtils.copyProperties((Object)a, (Object)targetDto);
                    if (Objects.equals(detailRespDto.getType(), PresentTypeEnum.COUPON.getType()) && StringUtils.isNotEmpty((CharSequence)a.getObjId())) {
                        this.queryCouponTemplate(Long.valueOf(a.getObjId()), targetDto);
                    }
                    presentList.add(targetDto);
                });
                result.setPresentList((List)presentList);
            }
        }
        return result;
    }

    private void queryCouponTemplate(Long templateId, PresentDetailExtRespDto.PresentListDto dto) {
        CouponTemplateExtRespDto data = this.couponTemplateExtQueryService.queryById(templateId);
        if (data != null) {
            dto.setType(data.getCouponType());
            Long total = data.getTotalIssueQuantity();
            dto.setMaxSendNum(total);
            Long remain = data.getRemainingQuantity();
            if (total != null & remain != null) {
                dto.setSendNum(Long.valueOf(total - remain));
            }
        }
    }
}

