/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.fullreduction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.BeanCopierUtils;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.PromotionActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.fullreduction.FullReductionActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.returngift.ReturnGiftActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.FullDecActItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.AbstractBaseTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullDecItemsCondition
extends AbstractBaseTemplate {
    private static Logger logger = LoggerFactory.getLogger(FullDecItemsCondition.class);

    @Override
    public long getConditionTemplateId() {
        return 1196944771412880283L;
    }

    @Override
    public long getRuleId() {
        return 0L;
    }

    @Override
    public boolean support(ActivityType type) {
        return ActivityType.FULL_REDUCTION_ACTIVITY.equals((Object)type) || ActivityType.FULL_RETURNING_ACTIVITY.equals((Object)type) || ActivityType.FULL_PRESENT_ACTIVITY.equals((Object)type);
    }

    @Override
    public <T extends BaseActivityDto> ConditionReqDto convertToCondition(T t) {
        List promotionActivityItemDtos;
        ConditionReqDto condition = this.getConditionReqDto();
        HashMap conditionParam = Maps.newHashMap();
        if (ActivityType.FULL_PRESENT_ACTIVITY.equals((Object)t.getActivityType()) || ActivityType.FULL_RETURNING_ACTIVITY.equals((Object)t.getActivityType())) {
            ReturnGiftActivityDto returnGiftActivityDto = (ReturnGiftActivityDto)t;
            promotionActivityItemDtos = returnGiftActivityDto.getActivityItems();
            conditionParam.put("ItemFullDecCondition.type", returnGiftActivityDto.getSelectType());
        } else {
            FullReductionActivityDto fullReductionActivityDto = (FullReductionActivityDto)t;
            promotionActivityItemDtos = fullReductionActivityDto.getActivityItems();
            conditionParam.put("ItemFullDecCondition.type", fullReductionActivityDto.getSelectType());
        }
        List fullDecActItems = promotionActivityItemDtos.stream().map(itemDto -> {
            FullDecActItem fullDecActItem = new FullDecActItem();
            fullDecActItem.setItemId(itemDto.getItemId());
            fullDecActItem.setItemCode(itemDto.getItemCode());
            fullDecActItem.setItemName(itemDto.getItemName());
            fullDecActItem.setPrice(itemDto.getSellPrice());
            fullDecActItem.setShopId(itemDto.getShopId());
            return fullDecActItem;
        }).collect(Collectors.toList());
        conditionParam.put("ItemFullDecCondition.items", fullDecActItems);
        conditionParam.put("ItemFullDecCondition.sellerIds", Lists.newArrayList());
        logger.info("\u6ee1\u51cf\u6ee1\u6298\u6d3b\u52a8\u9002\u7528\u5546\u54c1\u6761\u4ef6\u53c2\u6570={}", (Object)JSON.toJSONString((Object)conditionParam));
        condition.setConditionParams(JSON.toJSONString((Object)conditionParam));
        return condition;
    }

    @Override
    protected <T extends BaseActivityDto> void parse(ConditionRespDto conditionRespDto, T t) {
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        Integer selectType = jsonObject.getInteger("ItemFullDecCondition.type");
        List fullDecActItems = JSON.parseArray((String)jsonObject.getString("ItemFullDecCondition.items"), FullDecActItem.class);
        List<PromotionActivityItemDto> activityItems = this.getPromotionActivityItems(fullDecActItems);
        if (ActivityType.FULL_RETURNING_ACTIVITY.equals((Object)t.getActivityType()) || ActivityType.FULL_PRESENT_ACTIVITY.equals((Object)t.getActivityType())) {
            ReturnGiftActivityDto returnGiftActivityDto = (ReturnGiftActivityDto)t;
            returnGiftActivityDto.setSelectType(selectType);
            returnGiftActivityDto.setActivityItems(activityItems);
        } else {
            FullReductionActivityDto fullReductionActivityDto = (FullReductionActivityDto)t;
            fullReductionActivityDto.setSelectType(selectType);
            fullReductionActivityDto.setActivityItems(activityItems);
        }
    }

    private List<PromotionActivityItemDto> getPromotionActivityItems(List<FullDecActItem> fullDecActItems) {
        if (CollectionUtils.isNotEmpty(fullDecActItems)) {
            List activityItems = BeanCopierUtils.copyList(fullDecActItems, PromotionActivityItemDto.class);
            ArrayList itemIds = Lists.newArrayList();
            HashSet shopIds = Sets.newHashSet();
            for (PromotionActivityItemDto itemDto : activityItems) {
                itemIds.add(itemDto.getItemId());
                shopIds.add(itemDto.getShopId());
            }
            Map<Long, ItemRespDto> itemMap = this.queryItemByIds(itemIds);
            Map<Long, ShopBaseDto> shopMap = this.queryShopByIds(shopIds);
            for (PromotionActivityItemDto itemDto : activityItems) {
                if (!itemMap.containsKey(itemDto.getItemId())) continue;
                ItemRespDto itemRespDto = itemMap.get(itemDto.getItemId());
                itemDto.setItemCode(itemRespDto.getCode());
                itemDto.setItemName(itemRespDto.getName());
                if (shopMap.containsKey(itemDto.getShopId())) {
                    itemDto.setShopName(shopMap.get(itemDto.getShopId()).getName());
                }
                IItem itemService = (IItem)SpringBeanUtil.getBean(IItem.class);
                BigDecimal price = itemService.queryItemPrice(itemDto.getShopId(), itemDto.getItemId(), null);
                itemDto.setSellPrice(price);
                Long storage = ItemTypeEnum.BUNDLE.getType().equals(itemRespDto.getType()) ? this.queryBundleItemStock(itemDto.getItemId(), itemDto.getShopId()) : itemService.queryItemVirStorage(itemDto.getShopId(), itemDto.getItemId());
                itemDto.setTotalStock(storage);
                itemDto.setSellPrice(price);
            }
            return activityItems;
        }
        return Collections.EMPTY_LIST;
    }
}

