/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.PromotionActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.fullreduction.FullReductionActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IActivityAggService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IFullReductionActivity;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ActivityFactory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.AbstractActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.MarketingModuleHelper;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FullReductionActivityImpl
extends AbstractActivityService
implements IFullReductionActivity {
    @Autowired
    private IContext context;
    @Resource(name="activityQueryApiImpl")
    private IActivityQueryApi activityQueryApi;
    @Autowired
    private MarketingModuleHelper marketingModuleHelper;
    @Autowired
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IActivityAggService activityService;

    @Override
    public Long add(FullReductionActivityDto activityReqDto) {
        activityReqDto.setActivityCode(this.marketingModuleHelper.generateCode("FR"));
        if (null != activityReqDto.getSelectType() && activityReqDto.getSelectType() == 0) {
            List<ItemShelfQueryRespDto> items = this.activityService.queryAllItem();
            List activityItems = items.stream().map(itemShelfQueryRespDto -> {
                PromotionActivityItemDto itemDto = new PromotionActivityItemDto();
                itemDto.setShopId(itemShelfQueryRespDto.getShopId());
                itemDto.setItemId(itemShelfQueryRespDto.getItemId());
                return itemDto;
            }).collect(Collectors.toList());
            activityReqDto.setActivityItems(activityItems);
        }
        return this.addActivity(activityReqDto);
    }

    @Override
    public FullReductionActivityDto getDetail(Long id) {
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(id.longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        FullReductionActivityDto fullReductionActivityDto = new FullReductionActivityDto();
        CubeBeanUtils.copyProperties((Object)fullReductionActivityDto, (Object)activityRespDto, (String[])new String[0]);
        List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(ActivityType.FULL_REDUCTION_ACTIVITY);
        templateList.forEach(conditionTemplate -> conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), fullReductionActivityDto));
        fullReductionActivityDto.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        fullReductionActivityDto.setOrganizationIds((List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryAllSuperiorOrgIdList()));
        return fullReductionActivityDto;
    }

    @Override
    protected <T extends BaseActivityDto> List<ActivityItemReqDto> getActivityItems(T activityReqDto) {
        FullReductionActivityDto activityDto = (FullReductionActivityDto)activityReqDto;
        ArrayList activityItemReqDtos = Lists.newArrayList();
        if (activityDto.getSelectType() == 1) {
            activityDto.getActivityItems().stream().forEach(itemDto -> {
                ActivityItemReqDto activityItemReqDto = new ActivityItemReqDto();
                activityItemReqDto.setActivityPrice(BigDecimal.ZERO);
                activityItemReqDto.setItemId(itemDto.getItemId());
                activityItemReqDto.setItemName(itemDto.getItemName());
                activityItemReqDto.setItemType(ActivityItemTypeEnum.ITEM.getKey());
                activityItemReqDto.setStatus(EnableStatusEnum.ENABLE);
                activityItemReqDto.setOriginalStock(Long.valueOf(null != itemDto.getTotalStock() ? itemDto.getTotalStock() : 0L));
                activityItemReqDto.setRemainingStock(Long.valueOf(null != itemDto.getTotalStock() ? itemDto.getTotalStock() : 0L));
                activityItemReqDto.setInstanceId(this.context.instanceId());
                activityItemReqDto.setTenantId(this.context.tenantId());
                activityItemReqDto.setShopId(itemDto.getShopId());
                activityItemReqDtos.add(activityItemReqDto);
            });
        }
        return activityItemReqDtos;
    }
}

