/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.PolicyQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.PolicyReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActionTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.CheckpointRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ConditionTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PolicyRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.RuleRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.TriggerRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBusinessRuntimeException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils.ExpressionParser;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActionTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.ICheckPointService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IPolicyService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IRuleService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.ITriggerService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActionDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ConditionDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.PolicyDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.PolicyEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PolicyServiceImpl
implements IPolicyService {
    @Autowired
    private PolicyDas policyDas;
    @Autowired
    private ICheckPointService checkPointService;
    @Autowired
    private ITriggerService triggerService;
    @Autowired
    private IRuleService ruleService;
    @Autowired
    private IActionTemplateService actionTemplateService;
    @Autowired
    private IConditionTemplateService conditionTemplateService;
    @Resource
    private ConditionDas conditionDas;
    @Resource
    private ActionDas actionDas;

    @Override
    public List<ActionRespDto> queryActionsByActivityId(Long activityId) {
        ActionEo actionEo = new ActionEo();
        actionEo.setActivityId(activityId);
        List actionEoList = this.actionDas.select((BaseEo)actionEo);
        ArrayList<ActionRespDto> actionRespDtoList = new ArrayList<ActionRespDto>();
        DtoHelper.eoList2DtoList((Collection)actionEoList, actionRespDtoList, ActionRespDto.class);
        return actionRespDtoList;
    }

    @Override
    public List<PolicyRespDto> queryPoliciesByCp(String checkpointCode) {
        CheckpointRespDto dto = this.checkPointService.findByCheckCode(checkpointCode);
        if (null == dto) {
            return Lists.newArrayList();
        }
        List<PolicyEo> result = this.queryByCpId(dto);
        return this.getPolicyRespDtos(result);
    }

    @Override
    public List<PolicyEo> queryByCpId(CheckpointRespDto dto) {
        PolicyEo eo = PolicyEo.newInstance();
        eo.setCheckpointId(dto.getId());
        return this.policyDas.select((BaseEo)eo);
    }

    @Override
    public List<PolicyRespDto> queryPoliciesByAcAndCP(Long activityId, String checkpointCode) {
        CheckpointRespDto dto = this.checkPointService.findByCheckCode(checkpointCode);
        if (null == dto) {
            return Lists.newLinkedList();
        }
        List<PolicyEo> po = this.policyDas.selectPolicysByActivityId(activityId.longValue()).stream().filter(p -> p.getCheckpointId().equals(dto.getId())).collect(Collectors.toList());
        return this.getPolicyRespDtos(po);
    }

    @Override
    public Long addPolicy(PolicyReqDto dto) {
        PolicyEo eo = new PolicyEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
        this.policyDas.insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    public void modifyPolicy(Long tId, PolicyReqDto dto) {
        if (tId == null) {
            throw new ProBusinessRuntimeException(ProExceptionCode.PARAMETER_ERROR);
        }
        PolicyEo eo = PolicyEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
        eo.setId(tId);
        this.policyDas.updateSelective((BaseEo)eo);
    }

    @Override
    public void deletePolicy(Long tId) {
        this.policyDas.logicDeleteById(tId);
    }

    @Override
    public List<ConditionRespDto> queryConditionsByActivityId(Long activityId) {
        ConditionEo conditionEo = new ConditionEo();
        conditionEo.setActivityId(activityId);
        List conditionEoList = this.conditionDas.select((BaseEo)conditionEo);
        ArrayList<ConditionRespDto> conditionRespDtoList = new ArrayList<ConditionRespDto>();
        DtoHelper.eoList2DtoList((Collection)conditionEoList, conditionRespDtoList, ConditionRespDto.class);
        return conditionRespDtoList;
    }

    @Override
    public PolicyRespDto queryPolicyDetail(Long id) {
        PolicyEo eo = this.checkById(id, ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        PolicyRespDto dto = new PolicyRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)eo, (String[])new String[0]);
        return dto;
    }

    @Override
    public List<PolicyRespDto> queryPolicyList(PolicyQueryReqDto dto) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        PolicyEo eo = this.getPolicyEo(dto);
        List eoList = this.policyDas.select((BaseEo)eo);
        ArrayList<PolicyRespDto> dtoList = new ArrayList<PolicyRespDto>();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoList, PolicyRespDto.class);
        return dtoList;
    }

    @Override
    public PageInfo<PolicyRespDto> queryPolicyPage(PolicyQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        PolicyEo eo = this.getPolicyEo(reqDto);
        PageInfo pageInfo = this.policyDas.selectPage((BaseEo)eo, pageNum, pageSize);
        ArrayList respDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), respDtoList, PolicyRespDto.class);
        pageInfo.setList(respDtoList);
        return pageInfo;
    }

    private PolicyEo getPolicyEo(PolicyQueryReqDto reqDto) {
        PolicyEo eo = PolicyEo.newInstance();
        CubeBeanUtils.copyProperties((Object)eo, (Object)reqDto, (String[])new String[0]);
        this.setQueryTimeConditions(eo, reqDto.getCreateStartTime(), reqDto.getCreateEndTime());
        eo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        eo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        return eo;
    }

    private void checkBase(Long instanceId, Long tenantId) {
    }

    private void setQueryTimeConditions(PolicyEo eo, String startTime, String endTime) {
        ArrayList<SqlFilter> sqlFilterList = eo.getSqlFilters();
        if (StringUtils.isNotEmpty((CharSequence)startTime)) {
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList<SqlFilter>();
            }
            sqlFilterList.add(SqlFilter.gt((String)"create_time", (Object)startTime));
        }
        if (StringUtils.isNotEmpty((CharSequence)endTime)) {
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList();
            }
            sqlFilterList.add(SqlFilter.lt((String)"create_time", (Object)endTime));
        }
        eo.setSqlFilters(sqlFilterList);
    }

    private PolicyEo checkById(Long id, Long instanceId, Long tenantId) {
        PolicyEo eo = (PolicyEo)this.policyDas.selectByPrimaryKey(id);
        return eo;
    }

    private List<PolicyRespDto> getPolicyRespDtos(List<PolicyEo> result) {
        Set<Long> policyIds = result.stream().map(BaseEo::getId).collect(Collectors.toSet());
        Collection<TriggerRespDto> triggerRespDtos = this.triggerService.queryByPolicyIds(policyIds);
        List<Long> triggerIds = triggerRespDtos.stream().map(TriggerRespDto::getId).collect(Collectors.toList());
        Collection<ActionTemplateRespDto> actionTemplateRespDtos = this.actionTemplateService.queryByTriggerIds(triggerIds);
        List expressions = triggerRespDtos.stream().map(TriggerRespDto::getTriggerExpression).collect(Collectors.toList());
        HashSet<Long> ruleIds = new HashSet<Long>();
        for (String ex : expressions) {
            ruleIds.addAll(ExpressionParser.extractCondition((String)ex));
        }
        Collection<RuleRespDto> rulerespDtos = this.ruleService.queryByIds(ruleIds);
        Collection<ConditionTemplateRespDto> conditionTemplateRespDtos = this.conditionTemplateService.queryByRules(ruleIds);
        rulerespDtos.forEach(t -> t.setConditionTemplateList(conditionTemplateRespDtos.stream().filter(d -> t.getId().equals(d.getRuleId())).collect(Collectors.toList())));
        triggerRespDtos.forEach(t -> {
            t.setActionTemplates(actionTemplateRespDtos.stream().filter(d -> d.getTriggerId().equals(t.getId())).collect(Collectors.toList()));
            LinkedList ts = new LinkedList();
            ExpressionParser.extractCondition((String)t.getTriggerExpression()).stream().forEach(l -> ts.addAll(rulerespDtos.stream().filter(r -> r.getId().equals(l)).collect(Collectors.toList())));
            t.setRuleList(ts);
        });
        LinkedList<PolicyRespDto> results = new LinkedList<PolicyRespDto>();
        result.stream().forEach(r -> {
            PolicyRespDto t = BeanCopyUtil.copyProperties(PolicyRespDto.class, r, "triggerList");
            t.setTriggerList(triggerRespDtos.stream().filter(tr -> tr.getPolicyId().equals(r.getId())).collect(Collectors.toList()));
            results.add(t);
        });
        return results;
    }
}

