/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.TriggerQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.TriggerReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.TriggerRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.ITriggerService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BatchOperationUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.TriggerActionMappingDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.TriggerDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.TriggerActionMappingEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.TriggerEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TriggerServiceImpl
implements ITriggerService {
    @Autowired
    private TriggerDas triggerDas;
    @Autowired
    private TriggerActionMappingDas triggerActionMappingDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addTrigger(TriggerReqDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getActionTemplateIds())) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u5173\u8054\u52a8\u4f5c\u4e0d\u80fd\u4e3a\u7a7a"}));
        }
        TriggerEo eo = BeanCopyUtil.copyProperties(TriggerEo.class, dto, new String[0]);
        this.triggerDas.insert((BaseEo)eo);
        this.triggerActionMappingDas.batchInsert(eo, dto.getActionTemplateIds());
        return eo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyTrigger(Long id, TriggerReqDto dto) {
        TriggerEo eo = BeanCopyUtil.copyProperties(TriggerEo.class, dto, new String[0]);
        eo.setId(id);
        if (!CollectionUtils.isEmpty((Collection)dto.getActionTemplateIds())) {
            TriggerActionMappingEo tempEo = TriggerActionMappingEo.newInstance();
            tempEo.setTriggerId(id);
            this.triggerActionMappingDas.deleteByExample((BaseEo)tempEo);
            this.triggerActionMappingDas.batchInsert(eo, dto.getActionTemplateIds());
        }
        this.triggerDas.updateSelective((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteTrigger(Long tId) {
        this.triggerDas.logicDeleteById(tId);
    }

    @Override
    public Collection<TriggerRespDto> queryByPolicyIds(Set<Long> policyIds) {
        if (CollectionUtils.isEmpty(policyIds)) {
            return Lists.newArrayList();
        }
        LinkedList<TriggerRespDto> result = new LinkedList<TriggerRespDto>();
        BatchOperationUtil.batchQuery(Lists.newLinkedList(policyIds), d -> {
            TriggerEo eo = TriggerEo.newInstance();
            eo.setSqlFilters(SqlFilterBuilder.newInstance().buildInSqlFilter("policy_id", (Collection<?>)d).get());
            List eos = this.triggerDas.select((BaseEo)eo);
            result.addAll(BeanCopyUtil.copyCollections(eos, TriggerRespDto.class, new String[0]));
        });
        return result;
    }

    @Override
    public Collection<TriggerEo> queryByAcTemplateId(long acTemplate) {
        return this.triggerDas.queryByAcTemplateId(acTemplate);
    }

    @Override
    public TriggerRespDto queryTriggerDetail(Long id) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        TriggerEo eo = this.checkById(id, ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        TriggerRespDto dto = new TriggerRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)eo, (String[])new String[0]);
        return dto;
    }

    @Override
    public List<TriggerRespDto> queryTriggerList(TriggerQueryReqDto dto) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        TriggerEo eo = TriggerEo.newInstance();
        CubeBeanUtils.copyProperties((Object)eo, (Object)dto, (String[])new String[0]);
        eo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        eo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        this.setQueryTimeConditions(eo, dto.getCreateStartTime(), dto.getCreateEndTime());
        List eoList = this.triggerDas.select((BaseEo)eo);
        ArrayList<TriggerRespDto> dtoList = new ArrayList<TriggerRespDto>();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoList, TriggerRespDto.class);
        return dtoList;
    }

    @Override
    public PageInfo<TriggerRespDto> queryTriggerPage(TriggerQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        TriggerEo eo = TriggerEo.newInstance();
        CubeBeanUtils.copyProperties((Object)eo, (Object)reqDto, (String[])new String[0]);
        eo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        eo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        this.setQueryTimeConditions(eo, reqDto.getCreateStartTime(), reqDto.getCreateEndTime());
        PageInfo pageInfo = this.triggerDas.selectPage((BaseEo)eo, pageNum, pageSize);
        ArrayList respDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), respDtoList, TriggerRespDto.class);
        pageInfo.setList(respDtoList);
        return pageInfo;
    }

    private void checkBase(Long instanceId, Long tenantId) {
    }

    private void setQueryTimeConditions(TriggerEo eo, String startTime, String endTime) {
        ArrayList<SqlFilter> sqlFilterList = eo.getSqlFilters();
        if (StringUtils.isNotEmpty((CharSequence)startTime)) {
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList<SqlFilter>();
            }
            sqlFilterList.add(SqlFilter.gt((String)"create_time", (Object)startTime));
        }
        if (StringUtils.isNotEmpty((CharSequence)endTime)) {
            if (sqlFilterList == null) {
                sqlFilterList = new ArrayList();
            }
            sqlFilterList.add(SqlFilter.lt((String)"create_time", (Object)endTime));
        }
        eo.setSqlFilters(sqlFilterList);
    }

    private TriggerEo checkById(Long id, Long instanceId, Long tenantId) {
        TriggerEo eo = (TriggerEo)this.triggerDas.selectByPrimaryKey(id);
        return eo;
    }
}

