/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.mq.consumer;

import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityResultMessage;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponService;
import java.util.Collection;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class ActivityResultProcessor
implements IMessageProcessor<ActivityResultMessage> {
    public static final Logger logger = LoggerFactory.getLogger(ActivityResultProcessor.class);
    @Autowired
    private ICouponService couponService;
    @Autowired
    private IActivityService activityService;

    public MessageResponse process(ActivityResultMessage message) {
        if (null == message.getSuccess()) {
            logger.info("\u6d3b\u52a8\u53c2\u4e0e\u7ed3\u679c\u6d88\u606f.\u53d1\u73b0\u65e0\u6548\u6d88\u606f\uff0c\u672a\u544a\u77e5\u6267\u884c\u7ed3\u679c\uff0c\u8be5\u6761\u6d88\u606f\u88ab\u5ffd\u7565\u3002\u6d88\u606f\u5185\u5bb9:{}", (Object)message);
            return MessageResponse.SUCCESS;
        }
        if (null == message.getParams()) {
            logger.info("\u6d3b\u52a8\u53c2\u4e0e\u7ed3\u679c\u6d88\u606f,\u53d1\u73b0\u65e0\u6548\u6d88\u606f.\uff0c\u8be5\u6761\u6d88\u606f\u88ab\u5ffd\u7565\u3002\u6d88\u606f\u5185\u5bb9:{}", (Object)message);
        }
        LinkedList<Long> couponIds = new LinkedList<Long>();
        if (!CollectionUtils.isEmpty((Collection)message.getParams().getCouponIds())) {
            couponIds.addAll(message.getParams().getCouponIds());
        }
        message.getParams().getItems().stream().mapToLong(ItemVo::getCouponId).forEach(l -> {
            if (l > 0L) {
                couponIds.add(l);
            }
        });
        if (message.getSuccess().booleanValue()) {
            if (!CollectionUtils.isEmpty(couponIds)) {
                this.couponService.deductCouponSuccess(message.getParams().getUserId(), message.getOrderCode(), null, couponIds, message.getParams().getUserId());
            } else {
                this.activityService.joinSuccess(message.getParams().getUserId(), message.getParams().getActivityId(), message.getOrderCode());
            }
        }
        if (!message.getSuccess().booleanValue()) {
            if (!CollectionUtils.isEmpty(couponIds)) {
                this.couponService.deductCouponFailure(message.getParams().getUserId(), message.getOrderCode(), null, couponIds, message.getParams().getUserId());
            } else {
                this.activityService.joinFailure(message.getParams().getUserId(), message.getParams().getActivityId());
            }
        }
        return MessageResponse.SUCCESS;
    }
}

