/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.seckill.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.model.SeckillItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ILoadConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ItemConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.seckill.util.SeckillKeyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeckillItemCondition
extends ItemConditionTemplate
implements ILoadConditionTemplate {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICacheService commonCacheService;
    private static final String CONFIG_PARAM_KEY_ITEMS = "SeckillItemCondition.items";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> activityParams) {
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u5546\u54c1\u6761\u4ef6[items]\u672a\u914d\u7f6e"}));
        }
        List items = (List)ConditionTemplate.converter(activityParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)items)) {
            return false;
        }
        Iterator it = params.getItems().iterator();
        while (it.hasNext()) {
            ItemVo itemVo = (ItemVo)it.next();
            boolean contain = false;
            for (SeckillItem seckillItem : items) {
                if (!itemVo.getSkuId().equals(seckillItem.getSkuId().toString()) || !itemVo.getShopId().equals(seckillItem.getShopId().toString())) continue;
                itemVo.setPrice(seckillItem.getActivityPrice());
                contain = true;
            }
            if (contain) continue;
            it.remove();
        }
        return CollectionUtils.isNotEmpty((Collection)params.getItems());
    }

    @Override
    public boolean apply(TemplateDefine define, ConditionRespDto conditionRespDto, ItemVo itemVo) {
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u5546\u54c1\u6761\u4ef6[items]\u672a\u914d\u7f6e"}));
        }
        JSONObject configParams = JSON.parseObject((String)conditionRespDto.getConditionParams());
        List items = (List)ConditionTemplate.converter(configParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)items)) {
            return false;
        }
        return items.stream().anyMatch(item -> {
            String target = item.getItemId().toString();
            String source = itemVo.getItemId();
            if (null != itemVo.getSkuId()) {
                target = target + item.getSkuId();
                source = source + itemVo.getSkuId();
            }
            target = target + item.getShopId();
            source = source + itemVo.getShopId();
            return target.equals(source);
        });
    }

    @Override
    public Set<ActivityItemDto> getItems(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> configParams) {
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        if (null == param) {
            return Collections.EMPTY_SET;
        }
        List items = (List)ConditionTemplate.converter(configParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)items)) {
            return Collections.EMPTY_SET;
        }
        return items.stream().map(seckillItem -> new ActivityItemDto(seckillItem.getShopId(), seckillItem.getItemId())).collect(Collectors.toSet());
    }

    @Override
    public void load(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> activityParams, int expire) {
        Long activityId = conditionRespDto.getActivityId();
        this.logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u52a0\u8f7d\u5546\u54c1\u4ef7\u683c\u6761\u4ef6\u5f00\u59cb=====", (Object)activityId);
        Param param = define.getParam(CONFIG_PARAM_KEY_ITEMS);
        List items = (List)ConditionTemplate.converter(activityParams.get(CONFIG_PARAM_KEY_ITEMS), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)items)) {
            this.logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u672a\u914d\u7f6e\u5546\u54c1");
            return;
        }
        items.forEach(seckActItem -> this.commonCacheService.hset(SeckillKeyUtil.getCacheKey("activity_item_price", activityId), SeckillKeyUtil.getKey("_", seckActItem.getShopId(), seckActItem.getSkuId()), (Object)seckActItem.getActivityPrice(), expire));
        this.logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u52a0\u8f7d\u5546\u54c1\u4ef7\u683c\u6761\u4ef6\u7ed3\u675f=====", (Object)activityId);
    }
}

