/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.shop.biz.bo.cache.ShopCacheDto;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopCacheService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="shopCacheServiceImpl")
public class ShopCacheServiceImpl
implements IShopCacheService {
    @Autowired
    private ICacheService cacheService;
    private static final int overTime = 1800;

    @Override
    public ShopCacheDto getByShopId(Long shopId) {
        return (ShopCacheDto)this.cacheService.getCache(this.getCacheKey(shopId), ShopCacheDto.class);
    }

    private String getCacheKey(Long shopId) {
        return "shop:" + shopId;
    }

    @Override
    public void removeByShopId(Long shopId) {
        this.cacheService.delCache(this.getCacheKey(shopId));
    }

    @Override
    public void addShopCache(ShopCacheDto shopDto) {
        this.cacheService.add(this.getCacheKey(shopDto.getShopId()), (Object)shopDto, 1800);
    }
}

