/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDeliveryDto;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ITransportTemplateService;
import com.dtyunxi.yundt.cube.center.shop.dao.das.TransportTemplateDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.StdTransportTemplateEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.TransportTemplateEo;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TransportTemplateServiceImpl
implements ITransportTemplateService {
    @Resource
    private TransportTemplateDas transportTemplateDas;
    @Resource
    private IAreaQueryApi areaQueryApi;

    @Override
    public void saveTransportTemplate(ShopDeliveryDto shopDeliveryDto) {
        TransportTemplateEo transportTemplate = this.transportTemplateDas.getByShopId(shopDeliveryDto.getShopId());
        if (transportTemplate == null) {
            transportTemplate = TransportTemplateEo.newInstance();
        }
        DtoHelper.dto2Eo((BaseVo)shopDeliveryDto, (BaseEo)transportTemplate);
        if (shopDeliveryDto.getCityDeliveryPeriod() != null) {
            transportTemplate.setCityDeliveryPeriod(JSON.toJSONString((Object)shopDeliveryDto.getCityDeliveryPeriod()));
        }
        if (shopDeliveryDto.getSelfPickUpPeriod() != null) {
            transportTemplate.setSelfPickUpPeriod(JSON.toJSONString((Object)shopDeliveryDto.getSelfPickUpPeriod()));
        }
        this.setO2OAreaName(transportTemplate, transportTemplate.getAddressProvince(), transportTemplate.getAddressCity(), transportTemplate.getAddressRegion());
        this.transportTemplateDas.save(transportTemplate);
    }

    private void setO2OAreaName(TransportTemplateEo transportTemplateEo, String provinceCode, String cityCode, String regionCode) {
        if (provinceCode != null) {
            RestResponse province = this.areaQueryApi.queryByCode(provinceCode);
            transportTemplateEo.setAddressProvinceName(((AreaDto)province.getData()).getName());
        }
        if (cityCode != null) {
            RestResponse city = this.areaQueryApi.queryByCode(cityCode);
            transportTemplateEo.setAddressCityName(((AreaDto)city.getData()).getName());
        }
        if (regionCode != null) {
            RestResponse county = this.areaQueryApi.queryByCode(regionCode);
            transportTemplateEo.setAddressRegionName(((AreaDto)county.getData()).getName());
        }
    }

    @Override
    public List<Long> queryByAddressCode(String provinceCode, String cityCode, String regionCode) {
        TransportTemplateEo param = TransportTemplateEo.newInstance();
        param.setAddressProvince(provinceCode);
        param.setAddressCity(cityCode);
        param.setAddressRegion(regionCode);
        return this.transportTemplateDas.select((BaseEo)param).stream().map(StdTransportTemplateEo::getShopId).collect(Collectors.toList());
    }
}

