/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.apiimpl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shop.api.ISellerApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerAreaDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerBatchReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerBusinessScopeReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerCertificationDeadlineDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerReqDto;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerBusinessScopeService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerService;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerBusinessScopeEo;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sellerApi")
public class SellerApiImpl
implements ISellerApi {
    @Autowired
    private ISellerService sellerService;
    @Autowired
    ISellerBusinessScopeService iSellerBusinessScopeService;

    public RestResponse<Long> addSeller(SellerReqDto sellerReqDto, boolean audit) {
        return RestResponse.createLong((Long)this.sellerService.addSeller(sellerReqDto, audit));
    }

    public RestResponse<Void> addSellers(@Valid List<SellerBatchReqDto> sellerReqDtos, boolean audit) {
        this.sellerService.addBatchSeller(sellerReqDtos, audit);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addSellerBusinessScope(SellerBusinessScopeReqDto sellerBusinessScopeReqDto) {
        SellerBusinessScopeEo sellerBusinessScopeEo = (SellerBusinessScopeEo)BaseEo.newInstance(SellerBusinessScopeEo.class, (Map)sellerBusinessScopeReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)sellerBusinessScopeReqDto, (BaseEo)sellerBusinessScopeEo);
        return new RestResponse((Object)this.iSellerBusinessScopeService.addSellerBusinessScope(sellerBusinessScopeEo));
    }

    public RestResponse<Void> modifySeller(SellerReqDto sellerReqDto, boolean needAudit) {
        this.sellerService.modifySeller(sellerReqDto, needAudit);
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifySellerBusinessScope(SellerBusinessScopeReqDto sellerBusinessScopeReqDto) {
        SellerBusinessScopeEo sellerBusinessScopeEo = (SellerBusinessScopeEo)BaseEo.newInstance(SellerBusinessScopeEo.class, (Map)sellerBusinessScopeReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)sellerBusinessScopeReqDto, (BaseEo)sellerBusinessScopeEo);
        this.iSellerBusinessScopeService.modifySellerBusinessScope(sellerBusinessScopeEo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeBusinessById(@NotNull(message="ID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="ID\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        this.iSellerBusinessScopeService.removeBusinessById(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> auditSeller(long id, long tenantId, String status, String result, String auditPerson) {
        this.sellerService.auditSeller(status, result, auditPerson, tenantId, id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeSellerById(@NotNull(message="\u5546\u6237ID\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u5546\u6237ID\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        this.sellerService.removeById(id);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addSellerArea(@Valid SellerAreaDto sellerAreaDto) {
        return RestResponse.createLong((Long)this.sellerService.addSellerArea(sellerAreaDto));
    }

    public RestResponse<Boolean> checkSellerName(String sellerName) {
        return new RestResponse((Object)this.sellerService.checkSellerName(sellerName));
    }

    public RestResponse<Void> batchUpdateSellerDeadline(SellerCertificationDeadlineDto sellerCertificationDeadlineDto) {
        this.sellerService.batchUpdateSellerDeadline(sellerCertificationDeadlineDto);
        return RestResponse.VOID;
    }
}

