/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.mq.consumer;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.message.ShopWarehouseUpdateMessageDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.AreaDto;
import com.dtyunxi.yundt.cube.center.shop.dao.das.TemplateRegionDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.TemplateRegionEo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(tag="WAREHOUSE_CHANGE")
public class WarehouseModifyProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(WarehouseModifyProcessor.class);
    @Resource
    private TemplateRegionDas templateRegionDas;

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(MessageVo message) {
        String data = String.valueOf(message.getData());
        logger.info("\u76d1\u542c\u4ed3\u5e93\u4fe1\u606f\u66f4\u65b0\u7684\u6d88\u606f: {}", (Object)data);
        ShopWarehouseUpdateMessageDto shopWarehouseUpdateMessageDto = (ShopWarehouseUpdateMessageDto)JSON.parseObject((String)data, ShopWarehouseUpdateMessageDto.class);
        Long warehouseId = shopWarehouseUpdateMessageDto.getId();
        TemplateRegionEo templateRegionEo = TemplateRegionEo.newInstance();
        templateRegionEo.setWarehouseId(warehouseId);
        List templateRegionEoList = this.templateRegionDas.select((BaseEo)templateRegionEo);
        if (!CollectionUtils.isEmpty((Collection)templateRegionEoList)) {
            templateRegionEoList.forEach(eo -> {
                if (!"NORMAL".equals(shopWarehouseUpdateMessageDto.getStatus())) {
                    this.templateRegionDas.logicDeleteById(eo.getId());
                } else {
                    eo.setWarehouseCode(shopWarehouseUpdateMessageDto.getCode());
                    eo.setWarehouseName(shopWarehouseUpdateMessageDto.getName());
                    if (1 == eo.getLevelDefine()) {
                        if (shopWarehouseUpdateMessageDto.getExpressDeliveryStatus().booleanValue()) {
                            List areaDtoList = shopWarehouseUpdateMessageDto.getServiceAreaList();
                            String paramValue = areaDtoList.stream().map(AreaDto::toString).collect(Collectors.joining(";"));
                            eo.setParamValue(paramValue);
                            this.templateRegionDas.updateSelective((BaseEo)eo);
                        } else {
                            this.templateRegionDas.logicDeleteById(eo.getId());
                        }
                    }
                    if (2 == eo.getLevelDefine()) {
                        if (shopWarehouseUpdateMessageDto.getCityDeliveryStatus().booleanValue()) {
                            eo.setParamValue(shopWarehouseUpdateMessageDto.getGeoFence());
                            this.templateRegionDas.updateSelective((BaseEo)eo);
                        } else {
                            this.templateRegionDas.logicDeleteById(eo.getId());
                        }
                    }
                }
            });
        }
        return null;
    }
}

