/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.agg.apiimpl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.module.api.IConfig;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.IShopApi;
import com.dtyunxi.yundt.cube.center.shop.api.agg.IShopAggApi;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.Shop;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.ShopAudit;
import com.dtyunxi.yundt.cube.center.shop.api.agg.constant.ShopConstant;
import com.dtyunxi.yundt.cube.center.shop.api.agg.dto.request.ShopAggQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.agg.dto.response.ExportResultRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.agg.enums.ShopModuleExceptionCode;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.AuditQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopTransportPartnerDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.AuditDataRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.enums.ShopQueryEnum;
import com.dtyunxi.yundt.cube.center.shop.api.query.IAuditDataQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.shop.biz.agg.impl.ShopModuleHelper;
import com.dtyunxi.yundt.cube.center.shop.biz.agg.impl.export.ExportShopDto;
import com.dtyunxi.yundt.cube.center.shop.biz.agg.impl.export.IStorageShopService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShopAggApiImpl
implements IShopAggApi {
    private static final Logger logger = LoggerFactory.getLogger(ShopAggApiImpl.class);
    @Autowired
    private IShopApi shopApi;
    @Autowired
    private IShopQueryApi shopQueryApi;
    @Autowired
    private ISellerQueryApi sellerQueryApi;
    @Autowired
    private IAuditDataQueryApi auditDataQueryApi;
    @Resource(name="huieryunCubeContext")
    private IContext context;
    @Resource(name="yundt.module.shop")
    private IConfig iConfig;
    @Autowired
    private ShopModuleHelper shopModuleHelper;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IStorageShopService storageShopService;

    public RestResponse<Void> audit(ShopAudit shopAudit) {
        ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryById(shopAudit.getId().longValue(), new String[]{ShopQueryEnum.ALL.name()}));
        if (shopDto == null) {
            throw new BizException(ShopModuleExceptionCode.QUERY_SHOP_FAIL.getCode(), ShopModuleExceptionCode.QUERY_SHOP_FAIL.getMsg());
        }
        AuditDataRespDto auditDataDto = null;
        AuditQueryReqDto auditQueryReqDto = new AuditQueryReqDto();
        auditQueryReqDto.setBusinessId(shopAudit.getId());
        List auditDataDtos = (List)RestResponseHelper.extractData((RestResponse)this.auditDataQueryApi.queryList(auditQueryReqDto));
        if (CollectionUtils.isNotEmpty((Collection)auditDataDtos)) {
            auditDataDto = (AuditDataRespDto)auditDataDtos.get(0);
        }
        if (auditDataDto != null && !"PENDING".equals(auditDataDto.getStatus())) {
            throw new BizException(ShopModuleExceptionCode.REAUDIT_SHOP_FAIL.getCode(), ShopModuleExceptionCode.REAUDIT_SHOP_FAIL.getMsg());
        }
        String userName = this.context.userName();
        String sellerPhone = this.getSellerPhone(shopDto.getSellerId());
        RestResponse response = null;
        if (ShopConstant.AUDIT_PASS.equals(shopAudit.getStatus())) {
            response = this.shopApi.auditShop(auditDataDto.getId().longValue(), this.context.tenantId().longValue(), "PASS", "", userName);
            if (StringUtils.isNotBlank((String)sellerPhone)) {
                this.shopModuleHelper.sendSms(sellerPhone, "ApplyShop_001", "name", shopDto.getName());
            }
        } else {
            if (StringUtils.isBlank((String)shopAudit.getOpinion())) {
                throw new BizException(ShopModuleExceptionCode.AUDIT_OPINION_NULL.getCode(), ShopModuleExceptionCode.AUDIT_OPINION_NULL.getMsg());
            }
            response = this.shopApi.auditShop(auditDataDto.getId().longValue(), this.context.tenantId().longValue(), "REFUSE", shopAudit.getOpinion(), userName);
            if (StringUtils.isNotBlank((String)sellerPhone)) {
                this.shopModuleHelper.sendSms(sellerPhone, "ApplyShop_002", "reason", shopAudit.getOpinion());
            }
            shopDto = new ShopDto();
            shopDto.setId(shopAudit.getId());
            shopDto.setStatus("CORRECTION");
            this.shopApi.modifyShop(shopDto, false);
        }
        if (!"0".equals(response.getResultCode())) {
            throw new BizException(response.getResultCode(), response.getResultMsg());
        }
        return new RestResponse();
    }

    private String getSellerPhone(Long sellerId) {
        String mobile = null;
        SellerRespDto sellerDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryById(sellerId));
        if (sellerDto != null && StringUtils.isNotBlank((String)sellerDto.getExtension())) {
            JSONObject jsonObject = JSONObject.parseObject((String)sellerDto.getExtension());
            mobile = jsonObject.getString("account");
        }
        return mobile;
    }

    public RestResponse<Void> enableShop(Long shopId) {
        ShopBaseDto shop = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseById(shopId));
        SellerRespDto seller = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryById(shop.getSellerId()));
        if (!"NORMAL".equals(seller.getStatus())) {
            throw new BizException("\u8be5\u5e97\u94fa\u6240\u5c5e\u5546\u5bb6\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u5546\u5bb6");
        }
        ShopDto shopDto = new ShopDto();
        shopDto.setId(shopId);
        shopDto.setStatus("NORMAL");
        RestResponse response = this.shopApi.modifyShop(shopDto, false);
        if (!"0".equals(response.getResultCode())) {
            throw new BizException(response.getResultCode(), response.getResultMsg());
        }
        return new RestResponse();
    }

    public RestResponse<Void> disableShop(Long shopId) {
        ShopDto shopDto = new ShopDto();
        shopDto.setId(shopId);
        shopDto.setStatus("BANNED");
        RestResponse response = this.shopApi.modifyShop(shopDto, false);
        if (!"0".equals(response.getResultCode())) {
            throw new BizException(response.getResultCode(), response.getResultMsg());
        }
        MessageVo messageVo = new MessageVo();
        ShopBaseDto shopBaseDto = new ShopBaseDto();
        shopBaseDto.setId(shopId);
        logger.info("\u53d1\u9001\u7981\u7528\u5e97\u94fa\u540e\uff0c\u4e0b\u67b6\u76f8\u5e94\u5546\u54c1\u7684\u6d88\u606f\uff0cshopId\uff1a{}", (Object)shopBaseDto.getId());
        messageVo.setData((Object)JSON.toJSONString((Object)shopBaseDto));
        this.commonsMqService.sendDelaySingleMessage("SHOP_ITEM_OFF_SHELF", (Object)messageVo, Long.valueOf(1L));
        return new RestResponse();
    }

    public RestResponse<PageInfo<Shop>> queryShopByPage(ShopAggQueryDto shopAggQueryDto, Integer pageNum, Integer pageSize) {
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        Shop shop = new Shop();
        CubeBeanUtils.copyProperties((Object)shop, (Object)shopAggQueryDto, (String[])new String[0]);
        shop.setName(shopAggQueryDto.getShopName());
        if (StringUtils.isNotBlank((String)shop.getSellerName())) {
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            sellerQueryReqDto.setName(shop.getSellerName());
            sellerQueryReqDto.setInstanceId(instanceId);
            sellerQueryReqDto.setTenantId(tenantId);
            List sellerData = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryList(sellerQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)sellerData)) {
                shop.setSellerId(((SellerRespDto)sellerData.get(0)).getId());
            } else {
                return new RestResponse();
            }
        }
        ShopQueryDto shopQueryDto = new ShopQueryDto();
        CubeBeanUtils.copyProperties((Object)shopQueryDto, (Object)shop, (String[])new String[0]);
        shopQueryDto.setInstanceId(instanceId);
        shopQueryDto.setTenantId(tenantId);
        RestResponse pageResponse = this.shopQueryApi.queryByConditions(shopQueryDto, pageSize.intValue(), pageNum.intValue());
        if (!"0".equals(pageResponse.getResultCode())) {
            throw new BizException(pageResponse.getResultCode(), pageResponse.getResultMsg());
        }
        PageInfo resultPage = (PageInfo)pageResponse.getData();
        List shopDtoList = ((PageInfo)pageResponse.getData()).getList();
        ArrayList shopList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)shopDtoList)) {
            CubeBeanUtils.copyCollection(shopList, (Collection)shopDtoList, Shop.class);
            for (Shop exam : shopList) {
                if (!StringUtils.isNotBlank((String)exam.getExtension())) continue;
                JSONObject extension = JSONObject.parseObject((String)exam.getExtension());
                exam.setChannel(extension.getString("channel"));
                exam.setServiceTel(extension.getString("serviceTel"));
            }
            resultPage.setList(shopList);
        }
        return new RestResponse((Object)resultPage);
    }

    public RestResponse<PageInfo<Shop>> queryStoreShopList(ShopQueryDto shopQueryDto, Integer pageNum, Integer pageSize) {
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        shopQueryDto.setInstanceId(instanceId);
        shopQueryDto.setTenantId(tenantId);
        RestResponse pageResponse = this.shopQueryApi.queryStoreShopList(shopQueryDto, pageSize.intValue(), pageNum.intValue());
        if (!"0".equals(pageResponse.getResultCode())) {
            throw new BizException(pageResponse.getResultCode(), pageResponse.getResultMsg());
        }
        PageInfo resultPage = (PageInfo)pageResponse.getData();
        List shopDtoList = ((PageInfo)pageResponse.getData()).getList();
        if (CollectionUtils.isEmpty((Collection)shopDtoList)) {
            return new RestResponse((Object)resultPage);
        }
        ArrayList shopList = new ArrayList();
        CubeBeanUtils.copyCollection(shopList, (Collection)shopDtoList, Shop.class);
        resultPage.setList(shopList);
        return new RestResponse((Object)resultPage);
    }

    public RestResponse<Integer> isCheckAddress(String locationX, String locationY, String shopIds) {
        RestResponse response = this.shopApi.isCheckAddress(locationX, locationY, shopIds);
        if (!"0".equals(response.getResultCode())) {
            throw new BizException(response.getResultCode(), response.getResultMsg());
        }
        return response;
    }

    public RestResponse<List<ShopTransportPartnerDto>> queryShopTransportPartner(Long shopId) {
        return this.shopQueryApi.queryShopTransportPartner(shopId);
    }

    public RestResponse<ExportResultRespDto> exportShopList(ShopAggQueryDto shopQueryDto, Integer pageNum, Integer pageSize) {
        Shop shop = new Shop();
        CubeBeanUtils.copyProperties((Object)shop, (Object)shopQueryDto, (String[])new String[0]);
        shop.setName(shopQueryDto.getShopName());
        List<Shop> shopList = this.shopList(shop);
        ExportResultRespDto exportResultRespDto = new ExportResultRespDto();
        if (CollectionUtils.isNotEmpty(shopList)) {
            String fileName = "shop" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + ".xlsx";
            String path = System.getProperty("java.io.tmpdir") + File.separator + fileName;
            ArrayList list = new ArrayList();
            ExecutorUtils.execute(() -> {
                try {
                    ExcelWriter write = EasyExcel.write((String)path, ExportShopDto.class).build();
                    WriteSheet sheet = EasyExcel.writerSheet((Integer)1).build();
                    for (Shop one : shopList) {
                        ExportShopDto exportShopDto = new ExportShopDto();
                        BeanUtils.copyProperties((Object)exportShopDto, (Object)one);
                        exportShopDto.setId(String.valueOf(one.getId()));
                        exportShopDto.setType(one.getType() == 1L ? "\u7ebf\u4e0a\u4e1a\u52a1" : "O2O\u4e1a\u52a1");
                        switch (one.getStatus()) {
                            case "PENDING": {
                                exportShopDto.setStatus("\u5f85\u5ba1\u6838");
                                break;
                            }
                            case "NORMAL": {
                                exportShopDto.setStatus("\u6b63\u5e38");
                                break;
                            }
                            case "BANNED": {
                                exportShopDto.setStatus("\u5c01\u7981");
                                break;
                            }
                            default: {
                                exportShopDto.setStatus("\u5ba1\u6838\u4e0d\u901a\u8fc7");
                            }
                        }
                        list.add(exportShopDto);
                    }
                    int listSize = list.size();
                    int index = 100;
                    for (int i = 0; i < list.size(); i += 100) {
                        if (i + 100 > listSize) {
                            index = listSize - i;
                        }
                        List subList = list.subList(i, i + index);
                        write.write(subList, sheet);
                    }
                    write.finish();
                    File file = new File(path);
                    this.storageShopService.uploadFile(file, fileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            String fileUrl = this.storageShopService.getFileUrl(fileName);
            exportResultRespDto.setDownloadUrl(fileUrl);
            exportResultRespDto.setDownloadFileName(fileName);
        }
        return new RestResponse((Object)exportResultRespDto);
    }

    private List<Shop> shopList(Shop shop) {
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        if (StringUtils.isNotBlank((String)shop.getSellerName())) {
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            sellerQueryReqDto.setName(shop.getSellerName());
            sellerQueryReqDto.setInstanceId(instanceId);
            sellerQueryReqDto.setTenantId(tenantId);
            List sellerData = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryList(sellerQueryReqDto));
            if (CollectionUtils.isNotEmpty((Collection)sellerData)) {
                shop.setSellerId(((SellerRespDto)sellerData.get(0)).getId());
            } else {
                return new ArrayList<Shop>();
            }
        }
        ShopQueryDto shopQueryDto = new ShopQueryDto();
        CubeBeanUtils.copyProperties((Object)shopQueryDto, (Object)shop, (String[])new String[0]);
        shopQueryDto.setInstanceId(instanceId);
        shopQueryDto.setTenantId(tenantId);
        RestResponse pageResponse = this.shopQueryApi.shopList(shopQueryDto);
        logger.info("\u57fa\u7840\u5c42\u67e5\u8be2\u7ed3\u679c: {}", (Object)pageResponse);
        if (!"0".equals(pageResponse.getResultCode())) {
            throw new BizException(pageResponse.getResultCode(), pageResponse.getResultMsg());
        }
        List shopDtoList = (List)pageResponse.getData();
        ArrayList<Shop> shopList = new ArrayList<Shop>();
        if (CollectionUtils.isNotEmpty((Collection)shopDtoList)) {
            CubeBeanUtils.copyCollection(shopList, (Collection)shopDtoList, Shop.class);
            for (Shop exam : shopList) {
                if (!StringUtils.isNotBlank((String)exam.getExtension())) continue;
                JSONObject extension = JSONObject.parseObject((String)exam.getExtension());
                exam.setChannel(extension.getString("channel"));
                exam.setServiceTel(extension.getString("serviceTel"));
            }
        }
        return shopList;
    }
}

