/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.shop.api.exception.ShopExceptionCode;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerBusinessScopeService;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SellerBusinessScopeDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.SellerDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerBusinessScopeEo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SellerBusinessScopeImpl
implements ISellerBusinessScopeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    SellerBusinessScopeDas sellerBusinessScopeDas;
    @Autowired
    SellerDas sellerDas;

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public Long addSellerBusinessScope(SellerBusinessScopeEo sellerBusinessScopeEo) {
        if (null == this.sellerDas.selectByPrimaryKey(sellerBusinessScopeEo.getSellerId())) {
            this.logger.info("\u7ed1\u5b9a\u7ecf\u8425\u533a\u57df\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u8981\u7ed1\u5b9a\u7684\u5546\u6237");
            throw new BizException(ShopExceptionCode.SELLERBUSINESS_ADD_DEFULT.getCode(), ShopExceptionCode.SELLERBUSINESS_ADD_DEFULT.getMsg());
        }
        this.sellerBusinessScopeDas.insert((BaseEo)sellerBusinessScopeEo);
        return sellerBusinessScopeEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public void addSellerBusinessScopeBatch(List<SellerBusinessScopeEo> sellerBusinessScopeEoList) {
        this.sellerBusinessScopeDas.insertBatch(sellerBusinessScopeEoList);
    }

    @Override
    public List<SellerBusinessScopeEo> queryBusinessScopeBySellerId(Long sellerId) {
        SellerBusinessScopeEo sellerBusinessScopeEo = (SellerBusinessScopeEo)BaseEo.newInstance(SellerBusinessScopeEo.class);
        sellerBusinessScopeEo.setSellerId(sellerId);
        return this.sellerBusinessScopeDas.select((BaseEo)sellerBusinessScopeEo);
    }

    @Override
    public SellerBusinessScopeEo queryBusinessScopeBySellerIdAndBusinessId(Long sellerId, Long businessId) {
        SellerBusinessScopeEo sellerBusinessScopeEo = (SellerBusinessScopeEo)BaseEo.newInstance(SellerBusinessScopeEo.class);
        sellerBusinessScopeEo.setSellerId(sellerId);
        sellerBusinessScopeEo.setBusinessId(businessId);
        return (SellerBusinessScopeEo)this.sellerBusinessScopeDas.selectOne((BaseEo)sellerBusinessScopeEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public void modifySellerBusinessScope(SellerBusinessScopeEo sellerBusinessScopeEo) {
        if (sellerBusinessScopeEo.getId() == null) {
            throw new BizException("\u5546\u6237\u7ecf\u8425\u533a\u57dfid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (sellerBusinessScopeEo.getSellerId() == null) {
            throw new BizException("\u5546\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (sellerBusinessScopeEo.getId() == null) {
            this.logger.info("\u66f4\u65b0\u7ed1\u5b9a\u7ecf\u8425\u533a\u57df\u5931\u8d25\uff0c\u68c0\u67e5id\u662f\u5426\u4e3a\u7a7a");
            throw new BizException(ShopExceptionCode.SELLERBUSINESS_UPDATE_DEFULT.getCode(), ShopExceptionCode.SELLERBUSINESS_UPDATE_DEFULT.getMsg());
        }
        this.sellerBusinessScopeDas.updateSelective((BaseEo)sellerBusinessScopeEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public void removeBusinessById(Long id) {
        this.sellerBusinessScopeDas.logicDeleteById(id);
    }

    @Override
    public void removeBusinessBySellerId(Long sellerId) {
        SellerBusinessScopeEo sellerBusinessScopeEo = new SellerBusinessScopeEo();
        sellerBusinessScopeEo.setSellerId(sellerId);
        this.sellerBusinessScopeDas.logicDelete((BaseEo)sellerBusinessScopeEo);
    }
}

