/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.apiimpl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.exception.ShopExceptionCode;
import com.dtyunxi.yundt.cube.center.shop.api.query.IFreightTemplateDistributeApi;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IFreightTemplateService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="freightTemplateDistributeApi")
public class FreightTemplateDistributeApiImpl
implements IFreightTemplateDistributeApi {
    @Resource(name="shopService")
    private IShopService shopService;
    @Autowired
    private IFreightTemplateService freightTemplateService;

    public RestResponse<Void> enable(Long templateId, Byte state) {
        int count = this.shopService.countByFreightTemplateId(templateId);
        if (count > 0) {
            throw new BizException(ShopExceptionCode.SHOP_TEMPLATE_RELATION_SHOP.getCode(), ShopExceptionCode.SHOP_TEMPLATE_RELATION_SHOP.getMsg());
        }
        this.freightTemplateService.modifyTemplateState(state, templateId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long templateId) {
        int count = this.shopService.countByFreightTemplateId(templateId);
        if (count > 0) {
            throw new BizException(ShopExceptionCode.SHOP_TEMPLATE_RELATION_SHOP.getCode(), ShopExceptionCode.SHOP_TEMPLATE_RELATION_SHOP.getMsg());
        }
        this.freightTemplateService.delete(templateId);
        return RestResponse.VOID;
    }
}

