/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.dtyunxi.cube.commons.exceptions.ValidateException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaTreeRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.constant.RuleAreaType;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.FreeFreightRuleReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.FreeFreightRuleRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.RuleAreaBase;
import com.dtyunxi.yundt.cube.center.shop.biz.bo.cache.AreaCache;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IFreeFreightRuleService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IFreightRuleAreaService;
import com.dtyunxi.yundt.cube.center.shop.dao.das.FreeFreightRuleDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.FreeFreightRuleEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.FreightRuleAreaEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.StdFreightRuleAreaEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="freeFreightRuleService")
public class FreeFreightRuleServiceImpl
implements IFreeFreightRuleService {
    @Autowired
    private FreeFreightRuleDas freeFreightRuleDas;
    @Autowired
    private IFreightRuleAreaService freightRuleAreaService;
    @Autowired
    private IAreaQueryApi areaQueryApi;

    @Override
    public List<FreeFreightRuleRespDto> add(Long templateId, List<FreeFreightRuleReqDto> ruleReqDtos) {
        FreeFreightRuleEo deleteEo = FreeFreightRuleEo.newInstance();
        deleteEo.setFreightTemplateId(templateId);
        List deleteList = this.freeFreightRuleDas.selectList((BaseEo)deleteEo);
        ArrayList filters = Lists.newArrayList();
        filters.add(SqlFilter.eq((String)"freightTemplateId", (Object)templateId));
        deleteEo.setFreightTemplateId(null);
        deleteEo.setSqlFilters((List)filters);
        this.freeFreightRuleDas.logicDelete((BaseEo)deleteEo);
        if (deleteList != null && !deleteList.isEmpty()) {
            List<Long> ruleIds = deleteList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.freightRuleAreaService.delete(ruleIds, RuleAreaType.FREE);
        }
        if (CollectionUtils.isEmpty(ruleReqDtos)) {
            return null;
        }
        List<FreeFreightRuleEo> eoList = this.getEoList(templateId, ruleReqDtos);
        this.freeFreightRuleDas.insertBatch(eoList);
        eoList.forEach(eo -> {
            if (eo.getId() != null) {
                this.freightRuleAreaService.add(eo.getId(), eo.getAreaCode(), RuleAreaType.FREE);
            }
        });
        return null;
    }

    @Override
    public List<FreeFreightRuleRespDto> getRules(Long templateId) {
        return this.getRules(templateId, false, false);
    }

    @Override
    public List<FreeFreightRuleRespDto> getRules(List<Long> templateId) {
        return null;
    }

    @Override
    public List<FreeFreightRuleRespDto> getRules(List<Long> templateIds, boolean getName, boolean getTree) {
        FreeFreightRuleEo eo = FreeFreightRuleEo.newInstance();
        ArrayList filters = Lists.newArrayList();
        filters.add(SqlFilter.in((String)"freightTemplateId", templateIds));
        eo.setSqlFilters((List)filters);
        List result = this.freeFreightRuleDas.select((BaseEo)eo);
        if (result == null || result.isEmpty()) {
            return null;
        }
        List<Long> ruleIds = result.stream().map(BaseEo::getId).collect(Collectors.toList());
        List<FreightRuleAreaEo> areaCodeList = this.freightRuleAreaService.getAreaList(ruleIds, RuleAreaType.FREE);
        List<AreaTreeRespDto> areaTreeRespDtoList = null;
        if (getName || getTree) {
            areaTreeRespDtoList = AreaCache.AREA_TREE_CACHE;
        }
        return this.eo2Resp(result, areaCodeList, areaTreeRespDtoList);
    }

    @Override
    public List<FreeFreightRuleRespDto> getRules(Long templateId, boolean getName, boolean getTree) {
        ArrayList<Long> templateIds = new ArrayList<Long>();
        templateIds.add(templateId);
        return this.getRules(templateIds, getName, getTree);
    }

    private FreeFreightRuleRespDto eo2Resp(FreeFreightRuleEo eo, List<String> areaCodeList, List<AreaTreeRespDto> areaTreeRespDtoList) {
        if (eo == null) {
            return null;
        }
        if (CollectionUtils.isEmpty(areaCodeList)) {
            return null;
        }
        FreeFreightRuleRespDto respDto = new FreeFreightRuleRespDto();
        BeanUtil.copyProperties((Object)eo, (Object)respDto, (String[])new String[0]);
        respDto.setAreaCodes(areaCodeList);
        if (areaTreeRespDtoList != null) {
            this.freightRuleAreaService.setAreaMoreInfo((RuleAreaBase)respDto, areaTreeRespDtoList);
        }
        return respDto;
    }

    private List<FreeFreightRuleRespDto> eo2Resp(List<FreeFreightRuleEo> eoList, List<FreightRuleAreaEo> areaCodeList, List<AreaTreeRespDto> areaTreeRespDtoList) {
        if (eoList == null || eoList.isEmpty()) {
            return null;
        }
        ArrayList<FreeFreightRuleRespDto> list = new ArrayList<FreeFreightRuleRespDto>();
        eoList.forEach(eo -> {
            List<String> areaCodes = areaCodeList.stream().filter(e -> e.getFreightRuleId().equals(eo.getId())).map(StdFreightRuleAreaEo::getAreaCode).collect(Collectors.toList());
            FreeFreightRuleRespDto respDto = this.eo2Resp((FreeFreightRuleEo)eo, areaCodes, areaTreeRespDtoList);
            if (respDto != null) {
                list.add(respDto);
            }
        });
        return list;
    }

    private List<FreeFreightRuleEo> getEoList(Long templateId, List<FreeFreightRuleReqDto> ruleReqDtos) {
        if (CollectionUtils.isEmpty(ruleReqDtos)) {
            return Collections.emptyList();
        }
        ArrayList<FreeFreightRuleEo> eoList = new ArrayList<FreeFreightRuleEo>();
        ruleReqDtos.forEach(ruleReqDto -> {
            ruleReqDto.setFreightTemplateId(templateId);
            FreeFreightRuleEo eo = this.getEo((FreeFreightRuleReqDto)ruleReqDto);
            eoList.add(eo);
        });
        return eoList;
    }

    private FreeFreightRuleEo getEo(FreeFreightRuleReqDto ruleReqDto) {
        if (CollectionUtils.isEmpty((Collection)ruleReqDto.getDeliveryAreaDtoList())) {
            throw new ValidateException("\u514d\u8fd0\u8d39\u89c4\u5219\u9002\u7528\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FreeFreightRuleEo eo = FreeFreightRuleEo.newInstance();
        ruleReqDto.list2Text();
        BeanUtil.copyProperties((Object)ruleReqDto, (Object)eo, (String[])new String[0]);
        return eo;
    }
}

