/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.constant.DrEnum;
import com.dtyunxi.yundt.cube.center.shop.api.dto.message.ShopChangeMessageDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.message.ShopWarehouseUpdateMessageDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.AddShopUserReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.AddressAreaReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.DeliveryAreaDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.DeliveryPeriodDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopAddressReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopAreaDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopBusinessScopeDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDeliveryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDirFreightDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopEsDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopTransportPartnerDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopWarehouseDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.DistanceFreightCountReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.ShopFreightCountReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.FreightCountRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.enums.ShopFreightTypeTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.api.enums.ShopQueryEnum;
import com.dtyunxi.yundt.cube.center.shop.api.enums.ShopTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.api.exception.ShopExceptionCode;
import com.dtyunxi.yundt.cube.center.shop.biz.bo.cache.ShopCacheDto;
import com.dtyunxi.yundt.cube.center.shop.biz.mq.producer.ShopChangeProducer;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IAuditDataService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ISellerService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopAddressService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopCacheService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopSearchService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ITransportPartnerService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ITransportTemplateService;
import com.dtyunxi.yundt.cube.center.shop.biz.util.BadWordsUtil;
import com.dtyunxi.yundt.cube.center.shop.biz.util.BeanCopyUtil;
import com.dtyunxi.yundt.cube.center.shop.biz.util.LocationUtils;
import com.dtyunxi.yundt.cube.center.shop.dao.das.AuditDataDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopAddressDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopAreaDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopBusinessScopeDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopDirFreightDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopUserDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopWarehouseDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.TemplateRegionDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.TransportPartnerDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.TransportTemplateDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.AuditDataEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopAddressEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopAreaEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopBusinessScopeEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopDirFreightEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopUserEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopWarehouseEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.StdShopWarehouseEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.TemplateRegionEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.TransportPartnerEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.TransportTemplateEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IApplicationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="shopService")
public class ShopServiceImpl
implements IShopService {
    private static Logger logger = LoggerFactory.getLogger(ShopServiceImpl.class);
    public static String SHOP_INDEX_NAME = "idx_shop";
    public static String SHOP_INDEX_TYPE_NAME = "shop";
    public static final String SHOP_SEARCH_SHOP_HOUSE = "templateRegionList";
    public static final String SHOP_LOCATION = "location";
    @Resource
    private ShopDas shopDas;
    @Resource
    private TransportPartnerDas transportPartnerDas;
    @Resource
    private AuditDataDas auditDataDas;
    @Resource
    private ShopWarehouseDas shopWarehouseDas;
    @Resource
    private ShopBusinessScopeDas shopBusinessScopeDas;
    @Resource
    private ShopAreaDas shopAreaDas;
    @Resource
    private ShopUserDas shopUserDas;
    @Resource
    private ShopAddressDas shopAddressDas;
    @Resource
    private IShopAddressService shopAddressService;
    @Resource
    private ITransportTemplateService transportTemplateService;
    @Resource
    private TransportTemplateDas transportTemplateDas;
    @Resource
    private TemplateRegionDas templateRegionDas;
    @Resource
    private IShopSearchService shopSearchService;
    @Resource
    private ShopChangeProducer shopChangeProducer;
    @Resource
    private IShopCacheService shopCacheService;
    @Autowired
    private ISellerService iSellerService;
    @Resource
    private IApplicationQueryApi applicationQueryApi;
    @Value(value="${yundt.module.shop.shopUrlPrefix}")
    private String shopUrlPrefix;
    @Resource
    private ITransportPartnerService transportPartnerService;
    @Resource
    private IAuditDataService auditDataService;
    @Resource
    private IAreaQueryApi areaQueryApi;
    @Autowired
    private ShopDirFreightDas shopDirFreightDas;
    @Resource
    private IContext context;
    public static final String CHACHE_SHOP_DETIL_PREFIX = "center_shop_shop_detail";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addShop(ShopDto shopDto, boolean needAudit) {
        ShopDeliveryDto shopDeliveryDto;
        Boolean cityDelivery;
        ShopEo shopEo = ShopEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shopDto, (BaseEo)shopEo);
        if (StringUtils.isBlank((CharSequence)shopDto.getStatus())) {
            shopEo.setStatus(needAudit ? "PENDING" : "NORMAL");
        }
        if (Strings.isNullOrEmpty((String)shopEo.getCode())) {
            shopEo.setCode(this.generateShopCode());
        }
        if ((cityDelivery = shopDto.getCityDelivery()) != null && cityDelivery.booleanValue()) {
            if (shopDto.getShopFreightType() == null) {
                throw new BizException("\u8fd0\u8d39\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (shopDto.getShopFreightType().equals(ShopFreightTypeTypeEnum.DIR_TYPE.getCode()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopDto.getShopDirFreightDtoList())) {
                throw new BizException("\u6309\u7c7b\u76ee\u7edf\u4e00\uff0c\u540e\u53f0\u7c7b\u76ee\u548c\u8fd0\u8d39\u6a21\u677f\u7684\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        this.checkShopNameOrCode(shopEo.getName(), shopEo.getCode(), shopEo.getInstanceId(), shopEo.getTenantId());
        shopEo.setIsWxacodeDownload(Integer.valueOf(0));
        this.shopDas.insert((BaseEo)shopEo);
        Long shopId = shopEo.getId();
        shopDto.setId(shopId);
        if (shopDto.getInstanceId() != null) {
            AppInstanceDto appInstanceDto;
            logger.info("\u751f\u6210\u5e97\u94faURL: {}", (Object)shopId);
            RestResponse appInstanceDtoRestResponse = this.applicationQueryApi.queryInsById(shopDto.getInstanceId(), "{}");
            if ("0".equals(appInstanceDtoRestResponse.getResultCode()) && (appInstanceDto = (AppInstanceDto)appInstanceDtoRestResponse.getData()) != null) {
                String shopUrl = StringUtils.join((Object[])new Serializable[]{this.shopUrlPrefix, shopId, "&appKey", appInstanceDto.getAppKey()});
                shopEo.setShopUrl(shopUrl);
                this.shopDas.updateSelective((BaseEo)shopEo);
            }
        }
        List shopDirFreightDtoList = shopDto.getShopDirFreightDtoList();
        if (shopDto.getShopFreightType() != null && shopDto.getShopFreightType() == ShopFreightTypeTypeEnum.DIR_TYPE.getCode() && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shopDirFreightDtoList)) {
            shopDirFreightDtoList.forEach(n -> n.setShopId(shopId));
            ArrayList shopDirFreightEoList = Lists.newArrayList();
            DtoHelper.dtoList2EoList((Collection)shopDirFreightDtoList, (Collection)shopDirFreightEoList, ShopDirFreightEo.class);
            this.shopDirFreightDas.insertBatch((List)shopDirFreightEoList);
        }
        if (shopEo.getType() != null && ShopTypeEnum.ONLINE.getCode().intValue() == shopEo.getType().intValue()) {
            this.saveShopDeliveryArea(shopId, shopDto.getDeliveryAreaDtoList());
        }
        if ((shopDeliveryDto = shopDto.getShopDeliveryDto()) != null) {
            shopDeliveryDto.setShopId(shopEo.getId());
            shopDeliveryDto.setSellerId(shopEo.getSellerId());
            this.transportTemplateService.saveTransportTemplate(shopDeliveryDto);
        }
        List transportPartnerDtoList = shopDto.getTransportPartnerDtoList();
        if (BooleanUtils.isTrue((Boolean)shopDto.getCityDelivery()) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)transportPartnerDtoList)) {
            this.transportPartnerService.batchAddTransportPartners(shopDto, transportPartnerDtoList);
        }
        if (needAudit) {
            this.auditDataService.addAuditData(shopEo.getId(), "SHOP", JSON.toJSONString((Object)shopDto), shopDto.getStatus());
        }
        if (!CollectionUtils.isEmpty((Collection)shopDto.getShopWarehouseIds())) {
            for (Long aLong1 : shopDto.getShopWarehouseIds()) {
                ShopWarehouseEo shopWarehouseEo = new ShopWarehouseEo();
                shopWarehouseEo.setShopId(shopId);
                shopWarehouseEo.setWarehouseId(aLong1);
                this.shopWarehouseDas.insert((BaseEo)shopWarehouseEo);
            }
        }
        this.shopSearchService.sysShopToEs(shopEo.getId());
        ShopChangeMessageDto messageDto = new ShopChangeMessageDto();
        messageDto.setShopId(shopId.toString());
        this.shopChangeProducer.sendShopChangeMessage(messageDto);
        return shopEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"center_shop_shop_detail"}, key="#id")
    public void modifyShop(ShopDto shopDto, Long id, boolean needAudit) {
        ShopDeliveryDto shopDeliveryDto;
        this.shopCacheService.removeByShopId(shopDto.getId());
        ShopEo shopEo = (ShopEo)this.shopDas.selectByPrimaryKey(id);
        if (shopEo == null || shopDto.getInstanceId() != null && !shopDto.getInstanceId().equals(shopEo.getInstanceId()) || shopDto.getTenantId() != null && !shopDto.getTenantId().equals(shopEo.getTenantId())) {
            throw new BizException(ShopExceptionCode.SHOP_NOT_EXIST_DEFULT.getCode(), ShopExceptionCode.SHOP_NOT_EXIST_DEFULT.getMsg());
        }
        if (StringUtils.isNotEmpty((CharSequence)shopDto.getName()) && !shopEo.getName().equals(shopDto.getName())) {
            this.checkShopName(shopDto.getName(), shopDto.getInstanceId(), shopDto.getTenantId());
        }
        if (StringUtils.isNotEmpty((CharSequence)shopDto.getCode()) && !shopEo.getCode().equals(shopDto.getCode())) {
            this.checkShopCode(shopDto.getCode(), shopDto.getInstanceId(), shopDto.getTenantId());
        }
        if (shopDto.getShopFreightType() != null && shopDto.getShopFreightType() == ShopFreightTypeTypeEnum.DIR_TYPE.getCode() && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopDto.getShopDirFreightDtoList())) {
            throw new BizException("\u6309\u7c7b\u76ee\u7edf\u4e00\uff0c\u540e\u53f0\u7c7b\u76ee\u548c\u8fd0\u8d39\u6a21\u677f\u7684\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DtoHelper.dto2Eo((BaseVo)shopDto, (BaseEo)shopEo);
        if (StringUtils.isBlank((CharSequence)shopDto.getStatus())) {
            shopEo.setStatus(needAudit ? "PENDING" : "NORMAL");
        }
        this.shopDas.updateSelective((BaseEo)shopEo);
        if (shopEo.getType() != null && ShopTypeEnum.ONLINE.getCode().intValue() == shopEo.getType().intValue()) {
            this.shopAreaDas.clear(id);
            this.saveShopDeliveryArea(id, shopDto.getDeliveryAreaDtoList());
        }
        if (needAudit) {
            this.auditDataService.addAuditData(shopEo.getId(), "SHOP", JSON.toJSONString((Object)shopDto), shopDto.getStatus());
        }
        if ((shopDeliveryDto = shopDto.getShopDeliveryDto()) != null) {
            logger.info("\u5e97\u94fa\u914d\u9001\u4fe1\u606f:{}", (Object)JacksonUtil.toJson((Object)shopDeliveryDto));
            shopDeliveryDto.setShopId(shopEo.getId());
            shopDeliveryDto.setSellerId(shopEo.getSellerId());
            this.transportTemplateService.saveTransportTemplate(shopDeliveryDto);
        } else {
            logger.info("\u5e97\u94fa\u914d\u9001\u4fe1\u606f:\u65e0");
        }
        this.transportPartnerService.clear(shopDto.getSellerId(), shopDto.getId());
        List transportPartnerDtoList = shopDto.getTransportPartnerDtoList();
        if (BooleanUtils.isTrue((Boolean)shopDto.getCityDelivery()) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)transportPartnerDtoList)) {
            this.transportPartnerService.batchAddTransportPartners(shopDto, transportPartnerDtoList);
        }
        ShopDirFreightEo shopDirFreightEo = ShopDirFreightEo.newInstance();
        shopDirFreightEo.setShopId(id);
        this.shopDirFreightDas.delete((BaseEo)shopDirFreightEo);
        List shopDirFreightDtoList = shopDto.getShopDirFreightDtoList();
        if (shopDto.getShopFreightType() != null && shopDto.getShopFreightType() == ShopFreightTypeTypeEnum.DIR_TYPE.getCode() && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shopDirFreightDtoList)) {
            ArrayList shopDirFreightEoList = Lists.newArrayList();
            DtoHelper.dtoList2EoList((Collection)shopDirFreightDtoList, (Collection)shopDirFreightEoList, ShopDirFreightEo.class);
            this.shopDirFreightDas.insertBatch((List)shopDirFreightEoList);
        }
        if (!CollectionUtils.isEmpty((Collection)shopDto.getShopWarehouseIds())) {
            this.shopWarehouseDas.getMapper().delete((Wrapper)new QueryWrapper().eq((Object)"shop_id", (Object)id));
            for (Long aLong1 : shopDto.getShopWarehouseIds()) {
                ShopWarehouseEo shopWarehouseEo = new ShopWarehouseEo();
                shopWarehouseEo.setShopId(id);
                shopWarehouseEo.setWarehouseId(aLong1);
                this.shopWarehouseDas.insert((BaseEo)shopWarehouseEo);
            }
        }
        this.shopSearchService.sysShopToEs(id);
        ShopChangeMessageDto messageDto = new ShopChangeMessageDto();
        messageDto.setShopId(id.toString());
        this.shopChangeProducer.sendShopChangeMessage(messageDto);
    }

    private void saveShopDeliveryArea(Long shopId, List<DeliveryAreaDto> deliveryAreaDtoList) {
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(deliveryAreaDtoList)) {
            List shopAreaEoList = deliveryAreaDtoList.stream().map(deliveryAreaDto -> {
                ShopAreaEo shopAreaEo = new ShopAreaEo();
                shopAreaEo.setShopId(shopId);
                shopAreaEo.setProvinceCode(deliveryAreaDto.getProvCode());
                shopAreaEo.setProvince(deliveryAreaDto.getProvName());
                shopAreaEo.setCityCode(deliveryAreaDto.getCityCode());
                shopAreaEo.setCity(deliveryAreaDto.getCityName());
                shopAreaEo.setAreaCode(deliveryAreaDto.getAreaCode());
                shopAreaEo.setArea(deliveryAreaDto.getAreaName());
                return shopAreaEo;
            }).collect(Collectors.toList());
            this.shopAreaDas.insertBatch(shopAreaEoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"center_shop_shop_detail"}, key="#id")
    public void removeShop(long id) {
        this.shopCacheService.removeByShopId(id);
        ShopBaseDto shopDto = this.queryBaseById(id);
        if (shopDto == null) {
            logger.error("\u5220\u9664\u5931\u8d25\uff1a\u5e97\u94fa\u4e0d\u5b58\u5728");
            throw new BizException(ShopExceptionCode.SHOP_NOT_EXIST_DEFULT.getCode(), ShopExceptionCode.SHOP_NOT_EXIST_DEFULT.getMsg());
        }
        this.shopDas.logicDeleteById(Long.valueOf(id));
        ShopAreaEo areaEo = ShopAreaEo.newInstance();
        areaEo.setShopId(Long.valueOf(id));
        List shopAreaEoList = this.shopAreaDas.select((BaseEo)areaEo);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopAreaEoList)) {
            shopAreaEoList.forEach(eo -> this.shopAreaDas.logicDelete((BaseEo)eo));
        }
        ShopBusinessScopeEo businessScopeEo = ShopBusinessScopeEo.newInstance();
        businessScopeEo.setShopId(Long.valueOf(id));
        List shopBusinessScopeEoList = this.shopBusinessScopeDas.select((BaseEo)businessScopeEo);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopBusinessScopeEoList)) {
            shopBusinessScopeEoList.forEach(eo -> this.shopBusinessScopeDas.logicDelete((BaseEo)eo));
        }
        ShopAddressEo shopAddressEo = ShopAddressEo.newInstance();
        shopAddressEo.setShopId(Long.valueOf(id));
        this.shopAddressDas.logicDelete((BaseEo)shopAddressEo);
        TransportTemplateEo transportTemplateEo = this.transportTemplateDas.getByShopId(shopDto.getId());
        if (transportTemplateEo != null) {
            Long templateId = transportTemplateEo.getId();
            this.transportTemplateDas.logicDeleteById(templateId);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addShopArea(ShopAreaEo shopAreaEo) {
        this.isExists(shopAreaEo.getShopId());
        this.shopCacheService.removeByShopId(shopAreaEo.getShopId());
        this.shopAreaDas.insertBatch((List)Lists.newArrayList((Object[])new ShopAreaEo[]{shopAreaEo}));
        return shopAreaEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyShopArea(long areaId, ShopAreaEo shopAreaEo) {
        this.shopCacheService.removeByShopId(shopAreaEo.getShopId());
        shopAreaEo.setId(Long.valueOf(areaId));
        this.shopAreaDas.updateSelective((BaseEo)shopAreaEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeShopAreaById(long areaId) {
        ShopAreaEo shopAreaEo = (ShopAreaEo)this.shopAreaDas.selectByPrimaryKey(Long.valueOf(areaId));
        if (null == shopAreaEo) {
            logger.error("\u5220\u9664\u5931\u8d25\uff1a\u7ecf\u8425\u533a\u57df\u4e0d\u5b58\u5728");
            throw new BizException(ShopExceptionCode.AREA_DELETE_DEFULT.getCode(), ShopExceptionCode.AREA_DELETE_DEFULT.getMsg());
        }
        this.shopCacheService.removeByShopId(shopAreaEo.getShopId());
        this.shopAreaDas.deleteById(shopAreaEo.getShopId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeShopAreaByShopId(long shopId) {
        int shop_id = this.shopAreaDas.getMapper().delete((Wrapper)new QueryWrapper().eq((Object)"shop_id", (Object)shopId));
        if (shop_id > 0) {
            this.shopCacheService.removeByShopId(shopId);
            this.shopAreaDas.deleteById(Long.valueOf(shopId));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addShopBusinessScope(ShopBusinessScopeEo shopBusinessScopeEo) {
        this.shopCacheService.removeByShopId(shopBusinessScopeEo.getShopId());
        this.isExists(shopBusinessScopeEo.getShopId());
        this.shopBusinessScopeDas.insertBatch((List)Lists.newArrayList((Object[])new ShopBusinessScopeEo[]{shopBusinessScopeEo}));
        return shopBusinessScopeEo.getId();
    }

    private void isExists(Long shopId) {
        if (this.queryBaseById(shopId) == null) {
            logger.error("\u4e0d\u5b58\u5728\u8be5\u5e97\u94fa\u4fe1\u606f:{}", (Object)shopId);
            throw new BizException(ShopExceptionCode.SHOP_NOT_EXIST_DEFULT.getCode(), ShopExceptionCode.SHOP_NOT_EXIST_DEFULT.getMsg());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyShopBusinessScope(ShopBusinessScopeEo shopBusinessScopeEo, long businessScopeId) {
        this.shopCacheService.removeByShopId(shopBusinessScopeEo.getShopId());
        shopBusinessScopeEo.setId(Long.valueOf(businessScopeId));
        this.shopBusinessScopeDas.updateSelective((BaseEo)shopBusinessScopeEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeShopBusinessScopeById(Long shopId, Long businessId) {
        this.shopCacheService.removeByShopId(shopId);
        ShopBusinessScopeEo businessScopeEo = ShopBusinessScopeEo.newInstance();
        businessScopeEo.setShopId(shopId);
        List shopBusinessScopeEo = this.shopBusinessScopeDas.select((BaseEo)businessScopeEo);
        for (ShopBusinessScopeEo eo : shopBusinessScopeEo) {
            if (businessId != null && !eo.getBusinessId().equals(businessId)) continue;
            eo.setDr(DrEnum.DELETED.getCode());
            this.shopBusinessScopeDas.updateSelective((BaseEo)eo);
        }
    }

    @Override
    public PageInfo<ShopDto> queryByConditions(ShopQueryDto shopQueryDto, int pageSize, int page) {
        ShopEo eo = ShopEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shopQueryDto, (BaseEo)eo);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (eo != null) {
            String channelCode;
            String status;
            Long type;
            String name;
            String code = shopQueryDto.getCode();
            if (StringUtils.isNotBlank((CharSequence)code)) {
                sqlFilterList.add(SqlFilter.eq((String)"code", (Object)code));
            }
            if (StringUtils.isNotBlank((CharSequence)(name = shopQueryDto.getName()))) {
                sqlFilterList.add(SqlFilter.like((String)"name", (Object)StringUtils.wrapIfMissing((String)name, (String)"%")));
                eo.setName(null);
            }
            if ((type = shopQueryDto.getType()) != null) {
                sqlFilterList.add(SqlFilter.eq((String)"type", (Object)type));
            }
            if (StringUtils.isNotBlank((CharSequence)(status = shopQueryDto.getStatus()))) {
                sqlFilterList.add(SqlFilter.eq((String)"status", (Object)status));
            }
            if (StringUtils.isNotBlank((CharSequence)(channelCode = shopQueryDto.getChannelCode()))) {
                HashMap<String, String> param = new HashMap<String, String>(1);
                param.put("channel", channelCode);
                String jsonString = JSONObject.toJSONString(param);
                String result = StringUtils.wrapIfMissing((String)StringUtils.substring((String)jsonString, (int)1, (int)(jsonString.length() - 1)), (String)"%");
                sqlFilterList.add(SqlFilter.like((String)"extension", (Object)result));
                eo.setChannelCode(null);
            }
            if (StringUtils.isNotBlank((CharSequence)shopQueryDto.getUpdateTimeStart())) {
                sqlFilterList.add(SqlFilter.ge((String)"updateTime", (Object)shopQueryDto.getUpdateTimeStart()));
                eo.setUpdateTime(null);
            }
            if (StringUtils.isNotBlank((CharSequence)shopQueryDto.getUpdateTimeEnd())) {
                sqlFilterList.add(SqlFilter.le((String)"updateTime", (Object)shopQueryDto.getUpdateTimeEnd()));
                eo.setUpdateTime(null);
            }
            if (shopQueryDto.getId() != null) {
                sqlFilterList.add(SqlFilter.like((String)"id", (Object)shopQueryDto.getId()));
            }
            if (StringUtils.isNotEmpty((CharSequence)shopQueryDto.getOrganizationName())) {
                sqlFilterList.add(SqlFilter.like((String)"organizationName", (Object)shopQueryDto.getOrganizationName()));
            }
            if (StringUtils.isNotEmpty((CharSequence)shopQueryDto.getOrganizationCode())) {
                sqlFilterList.add(SqlFilter.like((String)"organizationCode", (Object)shopQueryDto.getOrganizationCode()));
            }
            if (StringUtils.isNotEmpty((CharSequence)shopQueryDto.getContactPhone())) {
                sqlFilterList.add(SqlFilter.like((String)"contactPhone", (Object)shopQueryDto.getContactPhone()));
            }
            eo.setSqlFilters(sqlFilterList);
            eo.setOrderByDesc("updateTime");
        }
        PageInfo eos = this.shopDas.selectPage((BaseEo)eo, Integer.valueOf(page), Integer.valueOf(pageSize), Boolean.valueOf(true));
        ArrayList results = new ArrayList();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)eos.getList())) {
            results = new ArrayList(eos.getList().size());
            DtoHelper.eoList2DtoList((Collection)eos.getList(), results, ShopDto.class);
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)eos, (String[])new String[]{"list", "navigatepageNums"});
            results.forEach(shopDto -> {
                ShopCacheDto shopCacheDto = this.shopCacheService.getByShopId(shopDto.getId());
                if (shopCacheDto == null) {
                    shopCacheDto = this.addShopCache(shopDto.getId());
                }
                ShopDto shopCacheDtoShopDto = shopCacheDto.getShopDto();
                shopDto.setShopChannelList(shopCacheDtoShopDto.getShopChannelList());
                String[] enums = new String[]{ShopQueryEnum.SHOP_AREA.name()};
                this.fillShopDtoByCache(enums, (ShopDto)shopDto, shopCacheDtoShopDto);
                shopDto.setSellerName(shopCacheDtoShopDto.getSellerName());
            });
            pageInfo.setList(results);
            pageInfo.setNavigatepageNums(eos.getNavigatepageNums());
            return pageInfo;
        }
        return new PageInfo(results);
    }

    @Override
    public List<ShopAreaDto> queryShopAreaByShopIds(AddressAreaReqDto reqDto) {
        logger.info("\u6536\u5230\u67e5\u8be2\u5e97\u94fa\u7ecf\u8425\u8303\u56f4\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        if (null == reqDto.getShopIds()) {
            logger.error("\u5e97\u94faid\u96c6\u5408\u4e3a\u7a7a");
            return null;
        }
        List shopAreaEos = this.shopAreaDas.queryShopAreaList(reqDto.getShopIds(), reqDto.getAreaCode(), reqDto.getCityCode(), reqDto.getProvCode());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopAreaEos)) {
            logger.error("\u5f53\u524d\u5e97\u94faid\u96c6\u5408:{} \u4e0d\u652f\u6301\u5f53\u524d\u7701\u5e02\u533a\u7684\u914d\u9001", (Object)JSON.toJSONString((Object)reqDto.getShopIds()));
            return null;
        }
        ArrayList<ShopAreaDto> areas = new ArrayList<ShopAreaDto>();
        DtoHelper.eoList2DtoList((Collection)shopAreaEos, areas, ShopAreaDto.class);
        return areas;
    }

    private ShopCacheDto addShopCache(long shopId) {
        List shopAreaEoList;
        ShopCacheDto shopCacheDto = new ShopCacheDto();
        shopCacheDto.setShopId(shopId);
        ShopEo shopEo = (ShopEo)this.shopDas.selectByPrimaryKey(Long.valueOf(shopId));
        if (shopEo == null) {
            logger.warn("\u6839\u636eshopId\u67e5\u8be2\u5e97\u94fa\u4fe1\u606f\u5f02\u5e38: {}", (Object)shopId);
            return shopCacheDto;
        }
        ShopDto simpleShop = new ShopDto();
        DtoHelper.eo2Dto((BaseEo)shopEo, (BaseVo)simpleShop);
        shopCacheDto.setSimpleShop(simpleShop);
        ShopDto dto = new ShopDto();
        DtoHelper.eo2Dto((BaseEo)shopEo, (BaseVo)dto);
        TransportTemplateEo transportTemplate = this.transportTemplateDas.getByShopId(Long.valueOf(shopId));
        if (transportTemplate != null) {
            ShopDeliveryDto shopDeliveryDto = new ShopDeliveryDto();
            DtoHelper.eo2Dto((BaseEo)transportTemplate, (BaseVo)shopDeliveryDto);
            if (StringUtils.isNotBlank((CharSequence)transportTemplate.getCityDeliveryPeriod())) {
                shopDeliveryDto.setCityDeliveryPeriod((DeliveryPeriodDto)JSON.parseObject((String)transportTemplate.getCityDeliveryPeriod(), DeliveryPeriodDto.class));
            }
            if (StringUtils.isNotBlank((CharSequence)transportTemplate.getSelfPickUpPeriod())) {
                shopDeliveryDto.setSelfPickUpPeriod((DeliveryPeriodDto)JSON.parseObject((String)transportTemplate.getSelfPickUpPeriod(), DeliveryPeriodDto.class));
            }
            dto.setShopDeliveryDto(shopDeliveryDto);
            if (BooleanUtils.isTrue((Boolean)dto.getCityDelivery())) {
                List<Object> transportPartnerDtoList = Lists.newArrayList();
                List<TransportPartnerEo> transportPartnerEoList = this.transportPartnerService.list(dto.getSellerId(), dto.getId());
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(transportPartnerEoList)) {
                    transportPartnerDtoList = transportPartnerEoList.stream().map(transportPartnerEo -> {
                        ShopTransportPartnerDto transportPartnerDto = new ShopTransportPartnerDto();
                        DtoHelper.eo2Dto((BaseEo)transportPartnerEo, (BaseVo)transportPartnerDto);
                        return transportPartnerDto;
                    }).collect(Collectors.toList());
                }
                dto.setTransportPartnerDtoList((List)transportPartnerDtoList);
            }
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(shopAreaEoList = this.shopAreaDas.queryByShopId(Long.valueOf(shopId))))) {
            List deliveryAreaDtoList = shopAreaEoList.stream().map(shopAreaEo -> {
                DeliveryAreaDto deliveryAreaDto = new DeliveryAreaDto();
                deliveryAreaDto.setProvCode(shopAreaEo.getProvinceCode());
                deliveryAreaDto.setProvName(shopAreaEo.getProvince());
                deliveryAreaDto.setCityCode(shopAreaEo.getCityCode());
                deliveryAreaDto.setCityName(shopAreaEo.getCity());
                deliveryAreaDto.setAreaCode(shopAreaEo.getAreaCode());
                deliveryAreaDto.setAreaName(shopAreaEo.getArea());
                return deliveryAreaDto;
            }).collect(Collectors.toList());
            dto.setDeliveryAreaDtoList(deliveryAreaDtoList);
        }
        ShopDirFreightEo shopDirFreightEo = new ShopDirFreightEo();
        shopDirFreightEo.setShopId(Long.valueOf(shopId));
        List shopDirFreightEoList = this.shopDirFreightDas.select((BaseEo)shopDirFreightEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shopDirFreightEoList)) {
            ArrayList shopDirFreightDtoList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)shopDirFreightEoList, (Collection)shopDirFreightDtoList, ShopDirFreightDto.class);
            dto.setShopDirFreightDtoList((List)shopDirFreightDtoList);
        }
        this.fillShopDto(dto);
        SellerEo sellerRespDto = this.iSellerService.querySellerById(dto.getSellerId());
        if (sellerRespDto != null) {
            dto.setSellerName(sellerRespDto.getName());
            dto.setSellerCode(sellerRespDto.getCode());
        }
        this.getShopWarehouse(shopId, dto);
        shopCacheDto.setShopDto(dto);
        this.shopCacheService.addShopCache(shopCacheDto);
        return shopCacheDto;
    }

    @Override
    public ShopDto queryById(long shopId, String ... enums) {
        ShopDto shopCache;
        ShopCacheDto shopCacheDto = this.shopCacheService.getByShopId(shopId);
        if (shopCacheDto == null) {
            shopCacheDto = this.addShopCache(shopId);
        }
        if ((shopCache = shopCacheDto.getShopDto()) != null) {
            ShopDto resultShop = shopCacheDto.getSimpleShop();
            resultShop.setDeliveryAreaDtoList(shopCache.getDeliveryAreaDtoList());
            resultShop.setShopChannelList(shopCache.getShopChannelList());
            resultShop.setShopAreaDto(shopCache.getShopAreaDto());
            resultShop.setShopWarehouseIds(shopCache.getShopWarehouseIds());
            resultShop.setSellerName(shopCache.getSellerName());
            resultShop.setSellerCode(shopCache.getSellerCode());
            ShopDeliveryDto shopDeliveryDto = shopCache.getShopDeliveryDto();
            if (shopDeliveryDto != null) {
                if (shopDeliveryDto.getAddressProvinceName() == null && shopDeliveryDto.getAddressProvince() != null) {
                    RestResponse province = this.areaQueryApi.queryByCode(shopDeliveryDto.getAddressProvince());
                    shopDeliveryDto.setAddressProvinceName(((AreaDto)province.getData()).getName());
                }
                if (shopDeliveryDto.getAddressProvinceName() == null && shopDeliveryDto.getAddressCity() != null) {
                    RestResponse city = this.areaQueryApi.queryByCode(shopDeliveryDto.getAddressCity());
                    shopDeliveryDto.setAddressCityName(((AreaDto)city.getData()).getName());
                }
                if (shopDeliveryDto.getAddressRegionName() == null && shopDeliveryDto.getAddressRegion() != null) {
                    RestResponse county = this.areaQueryApi.queryByCode(shopDeliveryDto.getAddressRegion());
                    shopDeliveryDto.setAddressRegionName(((AreaDto)county.getData()).getName());
                }
            }
            resultShop.setShopDeliveryDto(shopDeliveryDto);
            resultShop.setShopWarehouseDto(shopCache.getShopWarehouseDto());
            resultShop.setTransportPartnerDtoList(shopCache.getTransportPartnerDtoList());
            resultShop.setShopDirFreightDtoList(shopCache.getShopDirFreightDtoList());
            if (enums != null) {
                this.fillShopDtoByCache(enums, resultShop, shopCache);
            }
            return resultShop;
        }
        return null;
    }

    private void getShopWarehouse(long shopId, ShopDto resultShop) {
        this.extracted(resultShop, shopId);
    }

    @Override
    public ShopDto queryByCode(String code) {
        ShopDto dto = new ShopDto();
        ShopEo queryEo = new ShopEo();
        queryEo.setCode(code);
        List eoList = this.shopDas.select((BaseEo)queryEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)eoList)) {
            ShopEo shopEo = (ShopEo)eoList.get(0);
            DtoHelper.eo2Dto((BaseEo)shopEo, (BaseVo)dto);
            return dto;
        }
        return null;
    }

    @Override
    @Cacheable(value={"center_shop_shop_detail"}, key="#shopId", unless="#result == null")
    public ShopBaseDto queryBaseById(Long shopId) {
        List shopWarehouseEos;
        ShopEo shopEo = (ShopEo)this.shopDas.selectByPrimaryKey(shopId);
        if (shopEo == null) {
            throw new BizException(ShopExceptionCode.SHOP_NOT_EXIST_DEFULT.getCode(), ShopExceptionCode.SHOP_NOT_EXIST_DEFULT.getMsg());
        }
        ShopBaseDto shopBaseDto = new ShopBaseDto();
        CubeBeanUtils.copyProperties((Object)shopBaseDto, (Object)shopEo, (String[])new String[0]);
        ShopDirFreightEo shopDirFreightEo = new ShopDirFreightEo();
        shopDirFreightEo.setShopId(shopId);
        shopDirFreightEo.setOrderByDesc("back_parent_dir_id");
        List shopDirFreightEoList = this.shopDirFreightDas.select((BaseEo)shopDirFreightEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shopDirFreightEoList)) {
            ArrayList shopDirFreightDtoList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)shopDirFreightEoList, (Collection)shopDirFreightDtoList, ShopDirFreightDto.class);
            shopBaseDto.setShopDirFreightDtoList((List)shopDirFreightDtoList);
        }
        ArrayList collect = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(shopWarehouseEos = this.shopWarehouseDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"SHOP_ID", (Object)shopId)))) ? new ArrayList() : shopWarehouseEos.stream().map(StdShopWarehouseEo::getWarehouseId).collect(Collectors.toList());
        shopBaseDto.setShopWarehouseIds(collect);
        List transportPartnerEoList = this.transportPartnerDas.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"shop_id", (Object)shopId)).eq((Object)"dr", (Object)0));
        ArrayList list = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)transportPartnerEoList, list, ShopTransportPartnerDto.class);
        shopBaseDto.setTransportPartnerDtoList(list);
        return shopBaseDto;
    }

    @Override
    @CacheEvict(value={"center_shop_shop_detail"}, key="#shopId")
    public void clearShopBaseByShopId(Long shopId) {
    }

    @Override
    public PageInfo<ShopBaseDto> queryBaseShopPage(ShopQueryDto shopQueryDto, Integer pageSize, Integer page) {
        PageInfo pageInfo = new PageInfo();
        ArrayList list = new ArrayList();
        ShopEo shopEo = new ShopEo();
        CubeBeanUtils.copyProperties((Object)shopEo, (Object)shopQueryDto, (String[])new String[0]);
        shopEo.setCountyCode(shopQueryDto.getRegionCode());
        PageInfo shopEoPageInfo = this.shopDas.selectPage((BaseEo)shopEo, page, pageSize);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopEoPageInfo.getList())) {
            return pageInfo;
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)shopEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        CubeBeanUtils.copyCollection(list, (Collection)shopEoPageInfo.getList(), ShopBaseDto.class);
        pageInfo.setList(list);
        return pageInfo;
    }

    @Override
    public List<ShopBaseDto> queryBaseShopList(ShopQueryDto shopQueryDto) {
        ArrayList<ShopBaseDto> list = new ArrayList<ShopBaseDto>();
        ShopEo shopEo = new ShopEo();
        CubeBeanUtils.copyProperties((Object)shopEo, (Object)shopQueryDto, (String[])new String[0]);
        shopEo.setCountyCode(shopQueryDto.getRegionCode());
        List shopEoList = this.shopDas.select((BaseEo)shopEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopEoList)) {
            return list;
        }
        CubeBeanUtils.copyCollection(list, (Collection)shopEoList, ShopBaseDto.class);
        return list;
    }

    @Override
    public Long countShop(ShopQueryDto shopQueryDto) {
        ShopEo shopEo = new ShopEo();
        CubeBeanUtils.copyProperties((Object)shopEo, (Object)shopQueryDto, (String[])new String[0]);
        shopEo.setCountyCode(shopQueryDto.getRegionCode());
        int count = this.shopDas.count((BaseEo)shopEo);
        return Long.parseLong(String.valueOf(count));
    }

    @Override
    public List<ShopBaseDto> queryBaseListByIds(Set<Long> shopIds) {
        ArrayList shopBaseDtoList = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(shopIds)) {
            return shopBaseDtoList;
        }
        for (Long shopId : shopIds) {
            try {
                shopBaseDtoList.add(this.queryBaseById(shopId));
            }
            catch (BizException e) {
                logger.error("\u5e97\u94fa\u5217\u8868\u67e5\u8be2\u65f6,id:{}\u4e0d\u5b58\u5728", (Object)shopId);
            }
            catch (Exception e) {
                logger.error("\u5e97\u94fa\u5217\u8868\u67e5\u8be2\u65f6,id:{}\u67e5\u8be2\u5f02\u5e38:{}", (Object)shopId, (Object)e.getMessage());
            }
        }
        return shopBaseDtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addShopUser(AddShopUserReqDto addShopUserReqDto) {
        boolean flag = this.shopUserDas.validatShopUserIsExist(addShopUserReqDto.getShopId(), addShopUserReqDto.getUserId(), addShopUserReqDto.getInstanceId());
        if (flag) {
            throw new BizException(ShopExceptionCode.SHOP_USER_ISEXIST.getCode(), ShopExceptionCode.SHOP_USER_ISEXIST.getMsg());
        }
        ShopUserEo shopUserEo = BeanCopyUtil.copyProperties((BaseVo)addShopUserReqDto, ShopUserEo.class);
        this.shopUserDas.insert((BaseEo)shopUserEo);
        return shopUserEo.getId();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditShop(long id, long tenantId, String status, String result, String auditPerson) {
        AuditDataEo auditDataEo;
        block8: {
            block6: {
                block7: {
                    auditDataEo = (AuditDataEo)this.auditDataDas.selectByPrimaryKey(Long.valueOf(id));
                    if (null == auditDataEo || tenantId != auditDataEo.getTenantId()) break block6;
                    auditDataEo.setStatus(status);
                    auditDataEo.setAuditPerson(auditPerson);
                    auditDataEo.setAuditTime(new Date());
                    auditDataEo.setResult(result);
                    if (!"PASS".equals(status)) break block7;
                    long shopId = auditDataEo.getBusinessId();
                    this.auditDataDas.updateSelective((BaseEo)auditDataEo);
                    if (StringUtils.isNotBlank((CharSequence)auditDataEo.getData())) {
                        List shopBusinessScopeDto;
                        ShopDto shopDto = (ShopDto)JSON.parseObject((String)auditDataEo.getData(), ShopDto.class);
                        ShopEo eo = ShopEo.newInstance();
                        DtoHelper.dto2Eo((BaseVo)shopDto, (BaseEo)eo);
                        eo.setId(Long.valueOf(shopId));
                        eo.setStatus("NORMAL");
                        this.shopDas.updateSelective((BaseEo)eo);
                        List shopAreaDtos = shopDto.getShopAreaDto();
                        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopAreaDtos)) {
                            for (ShopAreaDto dto : shopAreaDtos) {
                                ShopAreaEo t = BeanCopyUtil.copyProperties((BaseVo)dto, ShopAreaEo.class);
                                this.shopAreaDas.updateSelective((BaseEo)t);
                            }
                        }
                        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(shopBusinessScopeDto = shopDto.getShopBusinessScopeDto()))) {
                            for (ShopBusinessScopeDto dto : shopBusinessScopeDto) {
                                ShopBusinessScopeEo t = BeanCopyUtil.copyProperties((BaseVo)dto, ShopBusinessScopeEo.class);
                                this.shopBusinessScopeDas.updateSelective((BaseEo)t);
                            }
                        }
                    }
                    break block8;
                }
                if (!status.equals("PENDING") && !"REFUSE".equals(status)) {
                    logger.error("\u5ba1\u6838\u5b57\u6bb5\u4e0d\u5408\u6cd5");
                    throw new BizException(ShopExceptionCode.SHOP_AUDIT_ILLEGAL.getCode(), ShopExceptionCode.SHOP_AUDIT_ILLEGAL.getMsg());
                }
                this.auditDataDas.updateSelective((BaseEo)auditDataEo);
                break block8;
            }
            logger.error("\u5ba1\u6838\u6570\u636e\u4e0d\u5b58\u5728");
            throw new BizException(ShopExceptionCode.SHOP_DATA_NOT_EXIST.getCode(), ShopExceptionCode.SHOP_DATA_NOT_EXIST.getMsg());
        }
        this.shopCacheService.removeByShopId(auditDataEo.getBusinessId());
        this.shopSearchService.sysShopToEs(auditDataEo.getBusinessId());
    }

    @Override
    public List<ShopDto> queryByIds(Set<Long> shopIds) {
        LinkedList<ShopDto> dtos = new LinkedList<ShopDto>();
        for (Long shopId : shopIds) {
            ShopEo shopEo = (ShopEo)this.shopDas.selectByPrimaryKey(shopId);
            if (null == shopEo) continue;
            ShopDto shopDto = new ShopDto();
            DtoHelper.eo2Dto((BaseEo)shopEo, (BaseVo)shopDto);
            dtos.add(shopDto);
            this.extracted(shopDto, shopId);
        }
        return dtos;
    }

    private void extracted(ShopDto shopDto, Long shopId) {
        List shopWarehouseEos = this.shopWarehouseDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"SHOP_ID", (Object)shopId));
        ArrayList collect = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopWarehouseEos) ? new ArrayList() : shopWarehouseEos.stream().map(StdShopWarehouseEo::getWarehouseId).collect(Collectors.toList());
        shopDto.setShopWarehouseIds(collect);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBatchShop(@Valid List<ShopReqDto> shopDtos, boolean needAudit) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(shopDtos)) {
            return;
        }
        for (ShopReqDto shopReqDto : shopDtos) {
            ShopDto shopDto = new ShopDto();
            CubeBeanUtils.copyProperties((Object)shopDto, (Object)shopReqDto, (String[])new String[0]);
            this.addShop(shopDto, needAudit);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ShopDto> batchAddShop(@Valid List<ShopReqDto> shopDtos, boolean needAudit) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(shopDtos)) {
            return null;
        }
        ArrayList shopList = Lists.newArrayList();
        for (ShopReqDto shopReqDto : shopDtos) {
            ShopDto shopDto = new ShopDto();
            CubeBeanUtils.copyProperties((Object)shopDto, (Object)shopReqDto, (String[])new String[0]);
            Long id = this.addShop(shopDto, needAudit);
            shopDto.setId(id);
            shopList.add(shopDto);
        }
        return shopList;
    }

    @Override
    public void modifyShopOnly(Long id, ShopReqDto shopReqDto) {
        ShopEo shopEo = (ShopEo)this.shopDas.selectByPrimaryKey(id);
        if (null == shopEo) {
            throw new BizException("\u5e97\u94faid\u4e0d\u5b58\u5728");
        }
        ShopEo updateShopEo = ShopEo.newInstance();
        BeanUtils.copyProperties((Object)shopReqDto, (Object)updateShopEo);
        updateShopEo.setId(id);
        this.shopDas.updateSelective((BaseEo)updateShopEo);
    }

    private void fillShopDtoByCache(String[] enums, ShopDto targetShop, ShopDto shopCache) {
        block8: for (String anEnum : enums) {
            ShopQueryEnum queryEnum = ShopQueryEnum.getEnum((String)anEnum);
            if (null == queryEnum) {
                return;
            }
            switch (queryEnum) {
                case ALL: {
                    targetShop.setShopAreaDto(shopCache.getShopAreaDto());
                    targetShop.setShopBusinessScopeDto(shopCache.getShopBusinessScopeDto());
                    targetShop.setShopAddressList(shopCache.getShopAddressList());
                    targetShop.setShopWarehouseDto(shopCache.getShopWarehouseDto());
                    targetShop.setDeliveryAreaDtoList(shopCache.getDeliveryAreaDtoList());
                    continue block8;
                }
                case SHOP_AREA: {
                    targetShop.setShopAreaDto(shopCache.getShopAreaDto());
                    continue block8;
                }
                case SHOP_BUSI: {
                    targetShop.setShopBusinessScopeDto(shopCache.getShopBusinessScopeDto());
                    continue block8;
                }
                case SHOP_WAREHOUSE: {
                    targetShop.setShopWarehouseDto(shopCache.getShopWarehouseDto());
                    continue block8;
                }
                case SHOP_ADDRESS: {
                    targetShop.setShopAddressList(shopCache.getShopAddressList());
                    continue block8;
                }
                case SHOP_DELIVERY_AREA: {
                    targetShop.setDeliveryAreaDtoList(shopCache.getDeliveryAreaDtoList());
                    continue block8;
                }
            }
        }
    }

    private void fillShopDto(ShopDto dto) {
        dto.setShopAreaDto(this.queryShopAreaByShopId(dto.getId()));
        dto.setShopBusinessScopeDto(this.queryShopBusiByShopId(dto.getId()));
        dto.setShopAddressList(this.shopAddressService.queryAddressByShopId(dto.getId()));
    }

    public List<ShopAreaDto> queryShopAreaByShopId(long shopId) {
        ShopAreaEo areaEo = ShopAreaEo.newInstance();
        areaEo.setShopId(Long.valueOf(shopId));
        List shopAreaEos = this.shopAreaDas.select((BaseEo)areaEo);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopAreaEos)) {
            ArrayList<ShopAreaDto> areas = new ArrayList<ShopAreaDto>(shopAreaEos.size());
            DtoHelper.eoList2DtoList((Collection)shopAreaEos, areas, ShopAreaDto.class);
            return areas;
        }
        return Collections.EMPTY_LIST;
    }

    public List<ShopBusinessScopeDto> queryShopBusiByShopId(long shopId) {
        ShopBusinessScopeEo businessScopeEo = new ShopBusinessScopeEo();
        businessScopeEo.setShopId(Long.valueOf(shopId));
        List businessScopeEos = this.shopBusinessScopeDas.select((BaseEo)businessScopeEo);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)businessScopeEos)) {
            ArrayList<ShopBusinessScopeDto> businessScopeDtos = new ArrayList<ShopBusinessScopeDto>(businessScopeEos.size());
            DtoHelper.eoList2DtoList((Collection)businessScopeEos, businessScopeDtos, ShopBusinessScopeDto.class);
            return businessScopeDtos;
        }
        return Collections.emptyList();
    }

    public List<ShopWarehouseDto> queryShopWareByShopId(long shopId) {
        ShopWarehouseEo warehouseEo = new ShopWarehouseEo();
        warehouseEo.setShopId(Long.valueOf(shopId));
        List shopWarehouseEos = this.shopWarehouseDas.select((BaseEo)warehouseEo);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopWarehouseEos)) {
            ArrayList<ShopWarehouseDto> dtos = new ArrayList<ShopWarehouseDto>(shopWarehouseEos.size());
            DtoHelper.eoList2DtoList((Collection)shopWarehouseEos, dtos, ShopWarehouseDto.class);
            return dtos;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void checkShopNameOrCode(String shopName, String shopCode, Long instanceId, Long tenantId) {
        this.checkShopName(shopName, instanceId, tenantId);
        this.checkShopCode(shopCode, instanceId, tenantId);
    }

    @Override
    public Boolean checkShopName(String shopName) {
        if (Strings.isNullOrEmpty((String)shopName)) {
            throw new BizException(ShopExceptionCode.SHOP_NAME_CAN_NOT_BE_EMPTY.getCode(), ShopExceptionCode.SHOP_NAME_CAN_NOT_BE_EMPTY.getMsg());
        }
        ShopEo shopEo = new ShopEo();
        shopEo.setName(shopName);
        shopEo.setInstanceId(this.context.instanceId());
        shopEo.setTenantId(this.context.tenantId());
        return this.shopDas.count((BaseEo)shopEo) > 0;
    }

    @Override
    public Boolean checkShopCode(String shopCode) {
        if (Strings.isNullOrEmpty((String)shopCode)) {
            throw new BizException(ShopExceptionCode.SHOP_CODE_CAN_NOT_BE_EMPTY.getCode(), ShopExceptionCode.SHOP_CODE_CAN_NOT_BE_EMPTY.getMsg());
        }
        ShopEo shopEo = new ShopEo();
        shopEo.setCode(shopCode);
        shopEo.setInstanceId(this.context.instanceId());
        shopEo.setTenantId(this.context.tenantId());
        return this.shopDas.count((BaseEo)shopEo) > 0;
    }

    @Override
    public ShopDto queryEarliestShop() {
        ShopEo shopEo = this.shopDas.queryEarliestShop();
        ShopDto shopDto = null;
        if (shopEo != null) {
            shopDto = new ShopDto();
            CubeBeanUtils.copyProperties((Object)shopDto, (Object)shopEo, (String[])new String[0]);
        }
        return shopDto;
    }

    private void checkShopName(String shopName, Long instanceId, Long tenantId) {
        if (Strings.isNullOrEmpty((String)shopName)) {
            throw new BizException(ShopExceptionCode.SHOP_NAME_CAN_NOT_BE_EMPTY.getCode(), ShopExceptionCode.SHOP_NAME_CAN_NOT_BE_EMPTY.getMsg());
        }
        ShopEo shopEo = new ShopEo();
        shopEo.setName(shopName);
        shopEo.setInstanceId(instanceId);
        shopEo.setTenantId(tenantId);
        if (this.shopDas.count((BaseEo)shopEo) > 0) {
            throw new BizException(ShopExceptionCode.SHOP_NAME_ISEXIST.getCode(), ShopExceptionCode.SHOP_NAME_ISEXIST.getMsg());
        }
    }

    private void checkShopCode(String shopCode, Long instanceId, Long tenantId) {
        if (Strings.isNullOrEmpty((String)shopCode)) {
            throw new BizException(ShopExceptionCode.SHOP_CODE_CAN_NOT_BE_EMPTY.getCode(), ShopExceptionCode.SHOP_CODE_CAN_NOT_BE_EMPTY.getMsg());
        }
        ShopEo shopEo = new ShopEo();
        shopEo.setCode(shopCode);
        shopEo.setInstanceId(instanceId);
        shopEo.setTenantId(tenantId);
        if (this.shopDas.count((BaseEo)shopEo) > 0) {
            throw new BizException(ShopExceptionCode.SHOP_CODE_ISEXIST.getCode(), ShopExceptionCode.SHOP_CODE_ISEXIST.getMsg());
        }
    }

    private String generateShopCode() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            char c = (char)(Math.random() * 26.0 + 97.0);
            sb.append(String.valueOf(c).toUpperCase());
        }
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < 5; ++i) {
            sb.append(random.nextInt(10));
        }
        return sb.toString();
    }

    @Deprecated
    private void updateShopDefault(ShopEo shopEo, Long shopId) {
        ShopAddressReqDto shopAddressReqDto = new ShopAddressReqDto();
        shopEo.setStatus(null);
        shopEo.setType(null);
        DtoHelper.eo2Dto((BaseEo)shopEo, (BaseVo)shopAddressReqDto);
        shopAddressReqDto.setShopId(shopId);
        shopAddressReqDto.setType("shop");
        shopAddressReqDto.setStatus("default");
        this.shopAddressService.addShopAddress(shopAddressReqDto);
    }

    @Override
    public List<ShopAreaDto> queryShopAreaList(ShopAreaDto shopAreaDto) {
        ShopAreaEo shopAreaEo = new ShopAreaEo();
        DtoHelper.dto2Eo((BaseVo)shopAreaDto, (BaseEo)shopAreaEo);
        List shopAreaEoList = this.shopAreaDas.select((BaseEo)shopAreaEo);
        ArrayList shopAreaDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)shopAreaEoList, (Collection)shopAreaDtoList, ShopAreaDto.class);
        return shopAreaDtoList;
    }

    @Override
    public Double getDeliveryDistance(ShopFreightCountReqDto shopFreightCountReqDto, AddressDto addressDto) {
        DistanceFreightCountReqDto distanceFreightCountReqDto = new DistanceFreightCountReqDto();
        if (addressDto.getLocationX() == null || addressDto.getLocationY() == null) {
            return 0.0;
        }
        distanceFreightCountReqDto.setDestinationLon(shopFreightCountReqDto.getDestinationLon());
        distanceFreightCountReqDto.setDestinationLat(shopFreightCountReqDto.getDestinationLat());
        distanceFreightCountReqDto.setOriginLon(addressDto.getLocationX());
        distanceFreightCountReqDto.setOriginLat(addressDto.getLocationY());
        double distance = LocationUtils.getDistance(distanceFreightCountReqDto.getOriginLon(), distanceFreightCountReqDto.getOriginLat(), distanceFreightCountReqDto.getDestinationLon(), distanceFreightCountReqDto.getDestinationLat());
        return distance / 1000.0;
    }

    @Override
    public FreightCountRespDto countFreight(ShopFreightCountReqDto shopFreightCountReqDto) {
        return new FreightCountRespDto();
    }

    @Override
    public PageInfo<ShopDto> queryStoreShopList(ShopQueryDto shopQueryDto, int pageSize, int page) {
        String name;
        ShopEo eo = ShopEo.newInstance();
        eo.setType(shopQueryDto.getType());
        eo.setManageType(Integer.valueOf(1));
        eo.setStatus(shopQueryDto.getStatus());
        eo.setOrderByDesc("createTime");
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        String code = shopQueryDto.getCode();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            sqlFilters.add(SqlFilter.like((String)"code", (Object)StringUtils.wrapIfMissing((String)code, (String)"%")));
        }
        if (StringUtils.isNotBlank((CharSequence)(name = shopQueryDto.getName()))) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)StringUtils.wrapIfMissing((String)name, (String)"%")));
        }
        if (StringUtils.isNotBlank((CharSequence)shopQueryDto.getUpdateTimeStart())) {
            sqlFilters.add(SqlFilter.ge((String)"updateTime", (Object)shopQueryDto.getUpdateTimeStart()));
        }
        if (StringUtils.isNotBlank((CharSequence)shopQueryDto.getUpdateTimeEnd())) {
            sqlFilters.add(SqlFilter.le((String)"updateTime", (Object)shopQueryDto.getUpdateTimeEnd()));
        }
        eo.setSqlFilters(sqlFilters);
        PageInfo eos = this.shopDas.selectPage((BaseEo)eo, Integer.valueOf(page), Integer.valueOf(pageSize), Boolean.valueOf(true));
        PageInfo pageInfo = new PageInfo();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)eos.getList())) {
            ArrayList results = new ArrayList(eos.getList().size());
            DtoHelper.eoList2DtoList((Collection)eos.getList(), results, ShopDto.class);
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)eos, (String[])new String[]{"list", "navigatepageNums"});
            pageInfo.setList(results);
            pageInfo.setNavigatepageNums(eos.getNavigatepageNums());
        }
        return pageInfo;
    }

    @Override
    public Integer isCheckAddress(String locationX, String locationY, String shopIds) {
        if (this.shopSearchService.checkRangeShop(Double.valueOf(locationX), Double.valueOf(locationY), shopIds)) {
            return 2;
        }
        return 1;
    }

    @Override
    public List<ShopEsDto> queryRangeShopListByGeo(String lat, String lon, Boolean isValidRegion) {
        return this.shopSearchService.queryRangeShopListByGeo(Double.valueOf(lat), Double.valueOf(lon), isValidRegion);
    }

    @Override
    public void updateShopWarehouse(ShopWarehouseUpdateMessageDto shopWarehouseUpdateDto) {
    }

    @Override
    public List<ShopWarehouseDto> queryShopWarehouseByShopId(Long shopId, Integer type) {
        List eoList;
        List<Object> list = Lists.newLinkedList();
        TemplateRegionEo paramEo = TemplateRegionEo.newInstance();
        paramEo.setShopId(shopId);
        if (type != null) {
            paramEo.setLevelDefine(type);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(eoList = this.templateRegionDas.select((BaseEo)paramEo)))) {
            list = eoList.stream().map(eo -> {
                ShopWarehouseDto dto = new ShopWarehouseDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
                return dto;
            }).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public List<ShopDto> queryShopList(ShopQueryDto queryCondition) {
        List<Long> shopIds;
        ShopEo shopEo = ShopEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)queryCondition, (BaseEo)shopEo);
        if ((StringUtils.isNotBlank((CharSequence)queryCondition.getProvinceCode()) || StringUtils.isNotBlank((CharSequence)queryCondition.getCityCode()) || StringUtils.isNotBlank((CharSequence)queryCondition.getRegionCode())) && org.apache.commons.collections.CollectionUtils.isNotEmpty(shopIds = this.transportTemplateService.queryByAddressCode(queryCondition.getProvinceCode(), queryCondition.getCityCode(), queryCondition.getRegionCode()))) {
            ArrayList sqlFilters = Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"shopId", shopIds)});
            shopEo.setSqlFilters((List)sqlFilters);
        }
        if (CollUtil.isNotEmpty((Collection)queryCondition.getOrganizationIdList())) {
            ArrayList sqlFilters = Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"organizationId", (Object)queryCondition.getOrganizationIdList())});
            shopEo.setSqlFilters((List)sqlFilters);
        }
        List shopEoList = this.shopDas.select((BaseEo)shopEo);
        ArrayList shopDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)shopEoList, (Collection)shopDtoList, ShopDto.class);
        return shopDtoList;
    }

    @Override
    public List<ShopTransportPartnerDto> queryShopTransportPartnerList(Long shopId) {
        List<Object> list = Lists.newArrayList();
        List<TransportPartnerEo> transportPartnerEoList = this.transportPartnerService.list(null, shopId);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(transportPartnerEoList)) {
            list = transportPartnerEoList.stream().map(eo -> {
                ShopTransportPartnerDto dto = new ShopTransportPartnerDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
                return dto;
            }).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public Integer countByFreightTemplateId(Long freightTemplateId) {
        ShopEo shopEo = ShopEo.newInstance();
        shopEo.setFreightTemplateId(freightTemplateId);
        return this.shopDas.count((BaseEo)shopEo);
    }

    @Override
    public boolean checkName(Long id, String shopName) {
        if (Strings.isNullOrEmpty((String)shopName)) {
            throw new BizException(ShopExceptionCode.SHOP_NAME_CAN_NOT_BE_EMPTY.getCode(), ShopExceptionCode.SHOP_NAME_CAN_NOT_BE_EMPTY.getMsg());
        }
        ShopEo shopEo = ShopEo.newInstance();
        shopEo.setName(shopName);
        ShopEo shopEo1 = (ShopEo)this.shopDas.selectOne((BaseEo)shopEo);
        if (shopEo1 != null && !shopEo1.getId().equals(id)) {
            throw new BizException(ShopExceptionCode.SHOP_NAME_ISEXIST.getCode(), ShopExceptionCode.SHOP_NAME_ISEXIST.getMsg());
        }
        boolean flag = BadWordsUtil.checkWord(shopName);
        if (flag) {
            throw new BizException(ShopExceptionCode.SHOP_NAME_WORD_ISEXIST.getCode(), ShopExceptionCode.SHOP_NAME_WORD_ISEXIST.getMsg());
        }
        return true;
    }

    @Override
    public List<ShopDto> shopList(ShopQueryDto shopQueryDto) {
        ShopEo eo = ShopEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shopQueryDto, (BaseEo)eo);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (eo != null) {
            String channelCode;
            String status;
            Long type;
            String name;
            String code = shopQueryDto.getCode();
            if (StringUtils.isNotBlank((CharSequence)code)) {
                sqlFilterList.add(SqlFilter.eq((String)"code", (Object)code));
            }
            if (StringUtils.isNotBlank((CharSequence)(name = shopQueryDto.getName()))) {
                sqlFilterList.add(SqlFilter.like((String)"name", (Object)StringUtils.wrapIfMissing((String)name, (String)"%")));
            }
            if ((type = shopQueryDto.getType()) != null) {
                sqlFilterList.add(SqlFilter.eq((String)"type", (Object)type));
            }
            if (StringUtils.isNotBlank((CharSequence)(status = shopQueryDto.getStatus()))) {
                sqlFilterList.add(SqlFilter.eq((String)"status", (Object)status));
            }
            if (StringUtils.isNotBlank((CharSequence)(channelCode = shopQueryDto.getChannelCode()))) {
                sqlFilterList.add(SqlFilter.like((String)"channelCode", (Object)StringUtils.wrapIfMissing((String)channelCode, (String)"%")));
            }
            if (StringUtils.isNotBlank((CharSequence)shopQueryDto.getUpdateTimeStart())) {
                sqlFilterList.add(SqlFilter.ge((String)"updateTime", (Object)shopQueryDto.getUpdateTimeStart()));
            }
            if (StringUtils.isNotBlank((CharSequence)shopQueryDto.getUpdateTimeEnd())) {
                sqlFilterList.add(SqlFilter.le((String)"updateTime", (Object)shopQueryDto.getUpdateTimeEnd()));
            }
            if (shopQueryDto.getId() != null) {
                sqlFilterList.add(SqlFilter.like((String)"id", (Object)shopQueryDto.getId()));
            }
            if (StringUtils.isNotEmpty((CharSequence)shopQueryDto.getOrganizationName())) {
                sqlFilterList.add(SqlFilter.like((String)"organizationName", (Object)shopQueryDto.getOrganizationName()));
            }
            if (StringUtils.isNotEmpty((CharSequence)shopQueryDto.getContactPhone())) {
                sqlFilterList.add(SqlFilter.like((String)"contactPhone", (Object)shopQueryDto.getContactPhone()));
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopQueryDto.getSellerIdList())) {
                sqlFilterList.add(SqlFilter.in((String)"sellerId", (Object)shopQueryDto.getSellerIdList()));
            }
            eo.setSqlFilters(sqlFilterList);
            eo.setOrderByDesc("updateTime");
        }
        List eos = this.shopDas.select((BaseEo)eo);
        ArrayList<ShopDto> results = new ArrayList<ShopDto>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)eos)) {
            DtoHelper.eoList2DtoList((Collection)eos, results, ShopDto.class);
            results.forEach(shopDto -> {
                ShopCacheDto shopCacheDto = this.shopCacheService.getByShopId(shopDto.getId());
                if (shopCacheDto == null) {
                    shopCacheDto = this.addShopCache(shopDto.getId());
                }
                ShopDto shopCacheDtoShopDto = shopCacheDto.getShopDto();
                shopDto.setShopChannelList(shopCacheDtoShopDto.getShopChannelList());
                String[] enums = new String[]{ShopQueryEnum.SHOP_AREA.name()};
                this.fillShopDtoByCache(enums, (ShopDto)shopDto, shopCacheDtoShopDto);
                shopDto.setSellerName(shopCacheDtoShopDto.getSellerName());
            });
        }
        return results;
    }

    @Override
    public SellerRespDto querySellerByOrganizationId(Long organizationId) {
        if (organizationId == null || organizationId == 0L) {
            return null;
        }
        SellerEo sellerEo = this.iSellerService.querySellerByOrganizationId(organizationId);
        if (sellerEo == null) {
            return null;
        }
        SellerRespDto sellerRespDto = new SellerRespDto();
        DtoHelper.eo2Dto((BaseEo)sellerEo, (BaseVo)sellerRespDto);
        List shopEoList = this.shopDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"seller_id", (Object)sellerEo.getId()));
        sellerRespDto.setShopId(!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)shopEoList) ? ((ShopEo)shopEoList.get(0)).getId() : null);
        return sellerRespDto;
    }

    @Override
    public ShopBaseDto queryBaseDasById(Long shopId) {
        List shopWarehouseEos;
        ShopEo shopEo = (ShopEo)this.shopDas.getMapper().findById(shopId);
        if (shopEo == null) {
            throw new BizException(ShopExceptionCode.SHOP_NOT_EXIST_DEFULT.getCode(), ShopExceptionCode.SHOP_NOT_EXIST_DEFULT.getMsg());
        }
        ShopBaseDto shopBaseDto = new ShopBaseDto();
        CubeBeanUtils.copyProperties((Object)shopBaseDto, (Object)shopEo, (String[])new String[0]);
        ShopDirFreightEo shopDirFreightEo = new ShopDirFreightEo();
        shopDirFreightEo.setShopId(shopId);
        shopDirFreightEo.setOrderByDesc("back_parent_dir_id");
        List shopDirFreightEoList = this.shopDirFreightDas.select((BaseEo)shopDirFreightEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shopDirFreightEoList)) {
            ArrayList shopDirFreightDtoList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)shopDirFreightEoList, (Collection)shopDirFreightDtoList, ShopDirFreightDto.class);
            shopBaseDto.setShopDirFreightDtoList((List)shopDirFreightDtoList);
        }
        ArrayList collect = org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(shopWarehouseEos = this.shopWarehouseDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"SHOP_ID", (Object)shopId)))) ? new ArrayList() : shopWarehouseEos.stream().map(StdShopWarehouseEo::getWarehouseId).collect(Collectors.toList());
        shopBaseDto.setShopWarehouseIds(collect);
        List transportPartnerEoList = this.transportPartnerDas.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"shop_id", (Object)shopId)).eq((Object)"dr", (Object)0));
        ArrayList list = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)transportPartnerEoList, list, ShopTransportPartnerDto.class);
        shopBaseDto.setTransportPartnerDtoList(list);
        return shopBaseDto;
    }

    @Override
    public List<ShopDto> queryShopByCode(List<String> codes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(codes)) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        ShopEo query = ShopEo.newInstance();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"code", (Object)StringUtils.join(codes, (String)",")));
        query.setSqlFilters((List)sqlFilters);
        List select = this.shopDas.select((BaseEo)query);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)select)) {
            select.forEach(eo -> {
                List<ShopWarehouseDto> shopWarehouseDtos = this.queryShopWareByShopId(eo.getId());
                ShopDto dto = new ShopDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
                dto.setShopWarehouseDto(shopWarehouseDtos);
                result.add(dto);
            });
        }
        return result;
    }
}

