/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDirFreightDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.CountFreightRuleReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.DistanceFreightCountReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.ShopFreightCountReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.FreightCountRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.FreeFreightRuleRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.FreightRuleRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.FreightTemplateRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.enums.FreightCountType;
import com.dtyunxi.yundt.cube.center.shop.api.enums.ShopFreightTypeTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.api.enums.ShopQueryEnum;
import com.dtyunxi.yundt.cube.center.shop.biz.service.ICountFreightService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IFreightTemplateService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopService;
import com.dtyunxi.yundt.cube.center.shop.biz.util.LocationUtils;
import com.dtyunxi.yundt.cube.center.user.api.dto.AddressDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserInfoQueryApi;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ICountFreightServiceImpl
implements ICountFreightService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IFreightTemplateService freightTemplateService;
    @Resource
    private IShopService shopService;
    @Resource
    private IUserInfoQueryApi userInfoQueryApi;

    private Long getFreightTemplateId(String skuId, ShopFreightCountReqDto shopFreightCountReqDto) {
        return shopFreightCountReqDto.getItemAttrValues().stream().filter(countFreightItemValue -> countFreightItemValue.getSkuId().equals(skuId)).findFirst().get().getFreightTemplateId();
    }

    private void fillDistanceAndAddressInfo(ShopDto shopBaseDto, ShopFreightCountReqDto shopFreightCountReqDto) {
        AddressDto addressDto = null;
        if (shopFreightCountReqDto.getAddressId() != null) {
            RestResponse addressDtoRestResponse = this.userInfoQueryApi.queryAddressById(shopFreightCountReqDto.getAddressId(), "{}");
            if (!"0".equals(addressDtoRestResponse.getResultCode())) {
                throw new BizException(addressDtoRestResponse.getResultCode(), addressDtoRestResponse.getResultMsg());
            }
            if (addressDtoRestResponse.getData() == null) {
                throw new BizException("\u65e0\u6cd5\u67e5\u8be2\u5230\u5730\u5740\u6570\u636e");
            }
            addressDto = (AddressDto)addressDtoRestResponse.getData();
            shopFreightCountReqDto.setCityCode(addressDto.getCityCode());
            shopFreightCountReqDto.setProvinceCode(addressDto.getProvinceCode());
            shopFreightCountReqDto.setAreaCode(addressDto.getDistrictCode());
            if (shopBaseDto.getShopDeliveryDto() != null && !StringUtils.isEmpty((CharSequence)shopBaseDto.getShopDeliveryDto().getGeo())) {
                String geo = shopBaseDto.getShopDeliveryDto().getGeo();
                String[] split = geo.split(",");
                shopFreightCountReqDto.setDestinationLon(split[0]);
                shopFreightCountReqDto.setDestinationLat(split[1]);
            }
        } else {
            shopFreightCountReqDto.setDestinationLon(shopFreightCountReqDto.getDestinationLon());
            shopFreightCountReqDto.setDestinationLat(shopFreightCountReqDto.getDestinationLat());
            addressDto = new AddressDto();
            addressDto.setLocationX(shopFreightCountReqDto.getDestinationLon());
            addressDto.setLocationY(shopFreightCountReqDto.getDestinationLat());
        }
        Double deliveryDistance = this.shopService.getDeliveryDistance(shopFreightCountReqDto, addressDto);
        Set skuSet = shopFreightCountReqDto.getItemAttrValues().stream().map(ShopFreightCountReqDto.CountFreightItemValue::getSkuId).collect(Collectors.toSet());
        for (String skuId : skuSet) {
            ShopFreightCountReqDto.CountFreightItemValue countFreightItemValue = new ShopFreightCountReqDto.CountFreightItemValue();
            countFreightItemValue.setSkuId(skuId);
            countFreightItemValue.setCountValue(new BigDecimal(deliveryDistance));
            countFreightItemValue.setCountType(FreightCountType.FREIGHT_COUNT_TYPE_DISTANCE);
            countFreightItemValue.setFreightTemplateId(this.getFreightTemplateId(skuId, shopFreightCountReqDto));
            shopFreightCountReqDto.getItemAttrValues().add(countFreightItemValue);
        }
    }

    private BigDecimal getMaxStartingPric(ShopFreightCountReqDto shopFreightCountReqDto) {
        BigDecimal maxStartPrice = BigDecimal.ZERO;
        for (ShopFreightCountReqDto.CountFreightItemValue countFreightItemValue : shopFreightCountReqDto.getItemAttrValues()) {
            if (countFreightItemValue.getFreightTemplateRespDto() == null || countFreightItemValue.getFreightTemplateRespDto().getStartingPric() == null || countFreightItemValue.getFreightTemplateRespDto().getStartingPric().compareTo(maxStartPrice) <= 0) continue;
            maxStartPrice = countFreightItemValue.getFreightTemplateRespDto().getStartingPric();
        }
        return maxStartPrice;
    }

    @Override
    public FreightCountRespDto count(ShopFreightCountReqDto shopFreightCountReqDto) {
        BigDecimal freightAmount;
        this.logger.info("\u8ba1\u7b97\u8fd0\u8d39\u63a5\u53d7\u5230\u53c2\u6570{}", (Object)JSON.toJSONString((Object)shopFreightCountReqDto));
        FreightCountRespDto freightCountRespDto = new FreightCountRespDto();
        freightCountRespDto.setShopId(shopFreightCountReqDto.getShopId());
        freightCountRespDto.setFreight(BigDecimal.ZERO);
        if (shopFreightCountReqDto.getAddressId() == null) {
            return freightCountRespDto;
        }
        this.logger.info("\u521d\u59cb\u5316\u540e\u7684\u6570\u636e\u4e3a{}", (Object)JSON.toJSONString((Object)shopFreightCountReqDto));
        ShopDto shopBaseDto = this.shopService.queryById(shopFreightCountReqDto.getShopId(), ShopQueryEnum.ALL.name());
        Integer shopFreightType = shopBaseDto.getShopFreightType();
        if (shopFreightType == null) {
            return freightCountRespDto;
        }
        this.fillDistanceAndAddressInfo(shopBaseDto, shopFreightCountReqDto);
        this.logger.info("\u67e5\u8be2\u5230\u7684\u5e97\u94fa\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)shopBaseDto));
        if (ShopFreightTypeTypeEnum.SHOP_TYPE.getCode().equals(shopFreightType)) {
            if (shopBaseDto.getFreightTemplateId() == null) {
                return freightCountRespDto;
            }
            CountFreightRuleReqDto countFreightRuleReqDto = new CountFreightRuleReqDto();
            FreightTemplateRespDto freightTemplateRespDto = this.freightTemplateService.getById(shopBaseDto.getFreightTemplateId(), true);
            this.logger.info("\u8fd0\u8d39\u6a21\u677f\u4e3a:{}", (Object)JacksonUtil.toJson((Object)freightTemplateRespDto));
            countFreightRuleReqDto.setFreightTemplate(freightTemplateRespDto);
            freightCountRespDto.setStartingPric(freightTemplateRespDto.getStartingPric());
            freightAmount = this.countShopFreightAmount(shopFreightCountReqDto, countFreightRuleReqDto);
            this.logger.info("\u6309\u5e97\u94fa\u7edf\u4e00\u8fd0\u8d39\u91d1\u989d\u4e3a:{}", (Object)JacksonUtil.toJson((Object)freightAmount));
            freightCountRespDto.setFreight(freightAmount);
            String matchFreeFreightRuleDes = this.getMatchFreeFreightRuleDes(shopFreightCountReqDto, freightTemplateRespDto, shopFreightType, "");
            freightCountRespDto.setFreeFreightDes(matchFreeFreightRuleDes);
        }
        List itemAttrValues = shopFreightCountReqDto.getItemAttrValues();
        if (ShopFreightTypeTypeEnum.DIR_TYPE.getCode().equals(shopFreightType)) {
            Iterator iterator = shopFreightCountReqDto.getItemAttrValues().iterator();
            while (iterator.hasNext()) {
                ShopFreightCountReqDto.CountFreightItemValue next = (ShopFreightCountReqDto.CountFreightItemValue)iterator.next();
                if (next.getBackDirLabelId() != null) continue;
                this.logger.info("\u7c7b\u76ee\u7edf\u4e00,\u8fc7\u6ee4\u672a\u914d\u7f6e\u7c7b\u76ee\u5305\u90ae\u6570\u636e:{}", (Object)next.getSkuId());
                iterator.remove();
            }
            this.logger.info("\u6309\u7c7b\u76ee\u7edf\u4e00\u8ba1\u7b97:{}", (Object)JacksonUtil.toJson((Object)shopFreightCountReqDto.getItemAttrValues()));
            this.dealWithDriFreight(shopFreightCountReqDto, freightCountRespDto, shopBaseDto, shopFreightType);
        }
        if (ShopFreightTypeTypeEnum.ITEM_TYPE.getCode() == shopFreightType) {
            CountFreightRuleReqDto countFreightRuleReqDto = this.countItemFreightRuleReqDto(shopBaseDto, itemAttrValues);
            this.logger.info("\u51c6\u5907\u597d\u53c2\u6570\uff0c\u8fdb\u5165\u8ba1\u7b97{},\u89c4\u5219\u53c2\u6570{}", (Object)JSON.toJSONString((Object)shopFreightCountReqDto), (Object)JSON.toJSONString((Object)shopFreightCountReqDto));
            freightAmount = this.countFreightAmount(shopFreightCountReqDto, countFreightRuleReqDto);
            freightCountRespDto.setFreight(freightAmount);
            freightCountRespDto.setStartingPric(this.getMaxStartingPric(shopFreightCountReqDto));
        }
        return freightCountRespDto;
    }

    private CountFreightRuleReqDto countItemFreightRuleReqDto(ShopDto shopBaseDto, List<ShopFreightCountReqDto.CountFreightItemValue> itemAttrValues) {
        CountFreightRuleReqDto countFreightRuleReqDto = new CountFreightRuleReqDto();
        countFreightRuleReqDto.setShop(shopBaseDto);
        HashMap<Long, FreightTemplateRespDto> freightTemplateRespDtoMap = new HashMap<Long, FreightTemplateRespDto>(16);
        for (ShopFreightCountReqDto.CountFreightItemValue countFreightItemValue : itemAttrValues) {
            if (countFreightItemValue.getFreightTemplateId() == null) continue;
            FreightTemplateRespDto freightTemplateRespDto = (FreightTemplateRespDto)freightTemplateRespDtoMap.get(countFreightItemValue.getFreightTemplateId());
            if (freightTemplateRespDto == null) {
                freightTemplateRespDto = this.freightTemplateService.getById(countFreightItemValue.getFreightTemplateId(), true);
                freightTemplateRespDtoMap.put(countFreightItemValue.getFreightTemplateId(), freightTemplateRespDto);
            }
            countFreightItemValue.setFreightTemplateRespDto(freightTemplateRespDto);
        }
        return countFreightRuleReqDto;
    }

    private void setItemCountType(Byte unit, ShopFreightCountReqDto shopFreightCountReqDto) {
        List itemAttrValues;
        if (!shopFreightCountReqDto.getShoppingCart()) {
            return;
        }
        this.logger.info("\u4ece\u8d2d\u7269\u8f66\u8fdb\u6765\uff0c\u5546\u54c1\u539f\u59cb\u6570\u636e:{}", (Object)JacksonUtil.toJson((Object)shopFreightCountReqDto.getItemAttrValues()));
        if (Integer.valueOf(0).equals(unit)) {
            itemAttrValues = shopFreightCountReqDto.getItemAttrValues();
            itemAttrValues.forEach(n -> {
                if (n.getItemNum() != null && n.getPrice() != null) {
                    n.setCountType(FreightCountType.FREIGHT_COUNT_TYPE_AMOUNT);
                    n.setCountValue(n.getPrice().multiply(n.getItemNum()));
                } else {
                    n.setCountValue(null);
                }
            });
        }
        if (Integer.valueOf(1).equals(unit)) {
            itemAttrValues = shopFreightCountReqDto.getItemAttrValues();
            itemAttrValues.forEach(n -> {
                if (n.getItemNum() != null) {
                    n.setCountType(FreightCountType.FREIGHT_COUNT_TYPE_NUM);
                    n.setCountValue(n.getItemNum());
                } else {
                    n.setCountValue(null);
                }
            });
        }
    }

    private void dealWithDriFreight(ShopFreightCountReqDto shopFreightCountReqDto, FreightCountRespDto freightCountRespDto, ShopDto shopBaseDto, Integer shopFreightType) {
        List itemAttrValues = shopFreightCountReqDto.getItemAttrValues();
        BigDecimal freightAmount = new BigDecimal(0);
        if (CollectionUtils.isEmpty((Collection)itemAttrValues)) {
            this.logger.info("\u5546\u54c1\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        List shopDirFreightDtoList = shopBaseDto.getShopDirFreightDtoList();
        StringBuffer description = new StringBuffer();
        Map<Long, List<ShopFreightCountReqDto.CountFreightItemValue>> freightItemListMap = itemAttrValues.stream().filter(item -> item.getBackDirLabelId() != null).collect(Collectors.groupingBy(ShopFreightCountReqDto.CountFreightItemValue::getBackDirLabelId));
        this.logger.info("freightItemListMap\u5206\u7ec4:{}", (Object)JacksonUtil.toJson(freightItemListMap));
        if (freightItemListMap == null) {
            this.logger.info("\u7c7b\u76ee\u6807\u7b7e\u4e3a\u7a7a");
            return;
        }
        shopDirFreightDtoList.sort(Comparator.comparing(ShopDirFreightDto::getNum));
        for (Long backLabelId : freightItemListMap.keySet()) {
            List<ShopFreightCountReqDto.CountFreightItemValue> countFreightItemValues = freightItemListMap.get(backLabelId);
            shopFreightCountReqDto.setItemAttrValues(countFreightItemValues);
            for (ShopDirFreightDto shopDirFreightDto : shopDirFreightDtoList) {
                String backParentDirId = shopDirFreightDto.getBackParentDirId();
                this.logger.info("backParentDirId\u4e3a:{},backLabelId:{}", (Object)JacksonUtil.toJson((Object)backParentDirId), (Object)backLabelId);
                if (!backParentDirId.contains(String.valueOf(backLabelId))) continue;
                this.logger.info("\u7b49\u8c03\u8bd5\u901a\u8fc7\u5220\u9664\uff0c\u8fd0\u8d39\u6a21\u677fid:{}", (Object)shopDirFreightDto.getFreightTemplateId());
                shopFreightCountReqDto.setFreightTemplateId(shopDirFreightDto.getFreightTemplateId());
                break;
            }
            this.logger.info("\u8fd0\u8d39\u6a21\u677fid\u4e3a:{}", (Object)JacksonUtil.toJson((Object)shopFreightCountReqDto.getFreightTemplateId()));
            FreightTemplateRespDto freightTemplateRespDto = this.freightTemplateService.getById(shopFreightCountReqDto.getFreightTemplateId(), true);
            this.logger.info("\u8fd0\u8d39\u6a21\u677f\u53c2\u6570:{}", (Object)JacksonUtil.toJson((Object)freightTemplateRespDto));
            String matchFreeFreightRuleDes = this.getMatchFreeFreightRuleDes(shopFreightCountReqDto, freightTemplateRespDto, shopFreightType, countFreightItemValues.get(0).getBackDirLabelName());
            this.logger.info("\u8fd4\u56de\u7684\u63cf\u8ff0:{},backLabelIdL:{}", (Object)matchFreeFreightRuleDes, (Object)backLabelId);
            if (!StringUtils.isEmpty((CharSequence)matchFreeFreightRuleDes)) {
                description.append(matchFreeFreightRuleDes);
            }
            for (ShopFreightCountReqDto.CountFreightItemValue itemAttrValue : countFreightItemValues) {
                itemAttrValue.setFreightTemplateRespDto(freightTemplateRespDto);
            }
            CountFreightRuleReqDto countFreightRuleReqDto = new CountFreightRuleReqDto();
            countFreightRuleReqDto.setShop(shopBaseDto);
            countFreightRuleReqDto.setFreightTemplate(freightTemplateRespDto);
            BigDecimal bigDecimal = this.countFreightAmount(shopFreightCountReqDto, countFreightRuleReqDto);
            this.logger.info("\u5f53\u524d\u7c7b\u76ee\u8fd0\u8d39:{},backLabelIdL:{}", (Object)bigDecimal, (Object)backLabelId);
            freightAmount = freightAmount.add(bigDecimal);
        }
        this.logger.info("\u6309\u7c7b\u76ee\u7edf\u4e00\u8fd0\u8d39\u91d1\u989d\u4e3a:{}", (Object)JacksonUtil.toJson((Object)freightAmount));
        freightCountRespDto.setFreight(freightAmount);
        if (String.valueOf(description).equals("\u5df2\u6ee1\u8db3\u5305\u90ae\u6761\u4ef6")) {
            freightCountRespDto.setFreight(new BigDecimal(0));
        }
        freightCountRespDto.setFreeFreightDes(String.valueOf(description));
    }

    @Override
    public List<FreightCountRespDto> queryCountFreight(List<ShopFreightCountReqDto> shopFreightCountReqList) {
        ArrayList list = Lists.newArrayList();
        Map<Long, List<ShopFreightCountReqDto>> freightItemListMap = shopFreightCountReqList.stream().filter(item -> item.getShopId() != null).collect(Collectors.groupingBy(ShopFreightCountReqDto::getShopId));
        freightItemListMap.keySet().forEach(n -> {
            List shopFreightCountReqDtos = (List)freightItemListMap.get(n);
            shopFreightCountReqDtos.forEach(shopFreightCountReqDto -> list.add(this.count((ShopFreightCountReqDto)shopFreightCountReqDto)));
        });
        return list;
    }

    public BigDecimal countTotalByType(List<ShopFreightCountReqDto.CountFreightItemValue> countFreightItemValues, Integer type) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (ShopFreightCountReqDto.CountFreightItemValue countFreightItemValue : countFreightItemValues) {
            if (!countFreightItemValue.getCountType().equals(type) || countFreightItemValue.getCountValue() == null) continue;
            if (FreightCountType.FREIGHT_COUNT_TYPE_DISTANCE.equals(countFreightItemValue.getCountType())) {
                return countFreightItemValue.getCountValue();
            }
            totalAmount = totalAmount.add(countFreightItemValue.getCountValue());
        }
        return totalAmount;
    }

    private Integer getTypeByFullUnit(Byte unit) {
        if (Integer.valueOf(unit.byteValue()).equals(1)) {
            return FreightCountType.FREIGHT_COUNT_TYPE_NUM;
        }
        if (Integer.valueOf(unit.byteValue()).equals(0)) {
            return FreightCountType.FREIGHT_COUNT_TYPE_AMOUNT;
        }
        if (Integer.valueOf(unit.byteValue()).equals(2)) {
            return FreightCountType.FREIGHT_COUNT_TYPE_DISTANCE;
        }
        return Integer.MAX_VALUE;
    }

    private Boolean isMatchFreeFreightRule(List<ShopFreightCountReqDto.CountFreightItemValue> countFreightItemValues, ShopFreightCountReqDto shopFreightCountReqDto, FreeFreightRuleRespDto freeFreightRuleRespDto) {
        if (!CollectionUtils.isEmpty((Collection)freeFreightRuleRespDto.getAreaCodes())) {
            for (String code : freeFreightRuleRespDto.getAreaCodes()) {
                BigDecimal total;
                Integer type;
                if (!code.equals(shopFreightCountReqDto.getAreaCode()) && !code.equals(shopFreightCountReqDto.getCityCode()) && !code.equals(shopFreightCountReqDto.getProvinceCode()) || !(FreightCountType.FREIGHT_COUNT_TYPE_DISTANCE.equals(type = this.getTypeByFullUnit(freeFreightRuleRespDto.getUnit())) ? (total = this.countTotalByType(countFreightItemValues, type)).compareTo(freeFreightRuleRespDto.getFullValue()) <= 0 : (total = this.countTotalByType(countFreightItemValues, type)).compareTo(freeFreightRuleRespDto.getFullValue()) >= 0)) continue;
                return true;
            }
        }
        return false;
    }

    private String getUnitDesByUnit(BigDecimal fullValue, Byte unit, ShopFreightCountReqDto shopFreightCountReqDto, Integer shopFreightType, String backDirLabelName) {
        this.setItemCountType(unit, shopFreightCountReqDto);
        this.logger.info("\u5355\u4f4d:{}\uff0c\u8fd0\u8d39\u7c7b\u578b:{},\u5546\u54c1\u4fe1\u606f:{},fullValue:{}", new Object[]{unit, shopFreightType, JacksonUtil.toJson((Object)shopFreightCountReqDto.getItemAttrValues()), fullValue});
        if (Integer.valueOf(2).equals(unit)) {
            this.logger.info("\u9009\u62e9\u7684\u662f\u8ddd\u79bb\uff0c\u4e0d\u663e\u793a\u8fd0\u8d39\u89c4\u5219");
            return "";
        }
        if (Integer.valueOf(0).equals(unit)) {
            List<ShopFreightCountReqDto.CountFreightItemValue> collect = this.getCountFreightItemValues(shopFreightCountReqDto, shopFreightType, backDirLabelName, 4);
            this.logger.info("\u5143,\u7c7b\u76ee\u5305\u90ae,\u6bcf\u6b21\u8ba1\u7b97\u4e0d\u9700\u8981\u533a\u5206\u7c7b\u76ee:{}", (Object)JSON.toJSONString(collect));
            String freeConditions = "\u5546\u54c1\u6ee1" + fullValue.doubleValue() + "\u5143\u5305\u90ae";
            double doubleValue = collect.stream().map(ShopFreightCountReqDto.CountFreightItemValue::getCountValue).reduce(BigDecimal.ZERO, BigDecimal::add).doubleValue();
            double countMoney = new BigDecimal(fullValue.doubleValue() - doubleValue).setScale(2, 4).doubleValue();
            if (ShopFreightTypeTypeEnum.DIR_TYPE.getCode() == shopFreightType) {
                if (countMoney <= 0.0) {
                    return "\u5df2\u6ee1\u8db3\u5305\u90ae\u6761\u4ef6";
                }
                return backDirLabelName + freeConditions + "\uff0c\u5df2\u9009" + backDirLabelName + "\u5546\u54c1" + doubleValue + "\u5143\uff0c\u8fd8\u5dee" + countMoney + "\u5143\uff1b";
            }
            if (ShopFreightTypeTypeEnum.SHOP_TYPE.getCode().equals(shopFreightType)) {
                if (countMoney <= 0.0) {
                    return "\u5df2\u6ee1\u8db3\u5305\u90ae\u6761\u4ef6";
                }
                return freeConditions + "\uff0c\u5df2\u9009\u5546\u54c1" + doubleValue + "\u5143,\u8fd8\u5dee" + countMoney + "\u5143\uff1b";
            }
            return freeConditions + ",\u8fd8\u5dee" + fullValue.subtract(BigDecimal.valueOf(doubleValue)) + "\u5143\uff1b";
        }
        if (Integer.valueOf(1).equals(unit)) {
            List<ShopFreightCountReqDto.CountFreightItemValue> collect = this.getCountFreightItemValues(shopFreightCountReqDto, shopFreightType, backDirLabelName, 1);
            this.logger.info("\u4ef6,\u7c7b\u76ee\u5305\u90ae,\u6bcf\u6b21\u8ba1\u7b97\u4e0d\u9700\u8981\u533a\u5206\u7c7b\u76ee:{}", (Object)JSON.toJSONString(collect));
            String freeConditions = "\u5546\u54c1\u6ee1" + fullValue.intValue() + "\u4ef6\u514d\u90ae\u5305\u90ae";
            Double doubleValue = collect.stream().map(ShopFreightCountReqDto.CountFreightItemValue::getCountValue).reduce(BigDecimal.ZERO, BigDecimal::add).doubleValue();
            int count = doubleValue.intValue();
            if (ShopFreightTypeTypeEnum.SHOP_TYPE.getCode().equals(shopFreightType)) {
                if (fullValue.intValue() - count <= 0) {
                    return "\u5df2\u6ee1\u8db3\u5305\u90ae\u6761\u4ef6";
                }
                return freeConditions + "\uff0c\u5df2\u9009\u5546\u54c1" + count + "\u4ef6\uff0c\u8fd8\u5dee" + (fullValue.intValue() - count) + "\u4ef6\uff1b";
            }
            if (ShopFreightTypeTypeEnum.DIR_TYPE.getCode().equals(shopFreightType)) {
                if (fullValue.intValue() - count <= 0) {
                    return "\u5df2\u6ee1\u8db3\u5305\u90ae\u6761\u4ef6";
                }
                return backDirLabelName + freeConditions + "\uff0c\u5df2\u9009" + backDirLabelName + "\u5546\u54c1" + doubleValue + "\u4ef6\uff0c\u8fd8\u5dee" + (fullValue.intValue() - count) + "\u4ef6\uff1b";
            }
            return freeConditions + ",\u8fd8\u5dee" + (fullValue.intValue() - count) + "\u4ef6;";
        }
        if (Integer.valueOf(2).equals(unit)) {
            List<ShopFreightCountReqDto.CountFreightItemValue> collect = this.getCountFreightItemValues(shopFreightCountReqDto, shopFreightType, backDirLabelName, 3);
            return "\u4f4e\u4e8e" + fullValue.intValue() + "km\u514d\u90ae,\u8fd8\u5dee" + (fullValue.intValue() - collect.get(0).getCountValue().intValue()) + "km;";
        }
        return "";
    }

    private List<ShopFreightCountReqDto.CountFreightItemValue> getCountFreightItemValues(ShopFreightCountReqDto shopFreightCountReqDto, Integer shopFreightType, String backDirLabelName, int i) {
        List collect;
        if (ShopFreightTypeTypeEnum.DIR_TYPE.getCode().equals(shopFreightType) && !Integer.valueOf(4).equals(i)) {
            Iterator iterator = shopFreightCountReqDto.getItemAttrValues().iterator();
            while (iterator.hasNext()) {
                ShopFreightCountReqDto.CountFreightItemValue item2 = (ShopFreightCountReqDto.CountFreightItemValue)iterator.next();
                if (i == item2.getCountType() && item2.getCountValue() != null && StringUtils.isNotBlank((CharSequence)item2.getBackDirLabelName()) && item2.getBackDirLabelName().equals(backDirLabelName)) continue;
                iterator.remove();
            }
            collect = shopFreightCountReqDto.getItemAttrValues();
        } else {
            collect = shopFreightCountReqDto.getItemAttrValues().stream().filter(item -> i == item.getCountType() && item.getCountValue() != null).collect(Collectors.toList());
        }
        return collect;
    }

    private String getMatchFreeFreightRuleDes(ShopFreightCountReqDto shopFreightCountReqDto, FreightTemplateRespDto freightTemplateRespDto, Integer shopFreightType, String backDirLabelName) {
        if (CollectionUtils.isEmpty((Collection)freightTemplateRespDto.getFreeFreightRuleList())) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (FreeFreightRuleRespDto freeFreightRuleRespDto : freightTemplateRespDto.getFreeFreightRuleList()) {
            for (String code : freeFreightRuleRespDto.getAreaCodes()) {
                if (!code.equals(shopFreightCountReqDto.getAreaCode()) && !code.equals(shopFreightCountReqDto.getCityCode()) && !code.equals(shopFreightCountReqDto.getProvinceCode())) continue;
                stringBuffer.append(this.getUnitDesByUnit(freeFreightRuleRespDto.getFullValue(), freeFreightRuleRespDto.getUnit(), shopFreightCountReqDto, shopFreightType, backDirLabelName));
            }
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    private boolean ifFreeFreightAll(ShopFreightCountReqDto shopFreightCountReqDto) {
        Map<String, List<ShopFreightCountReqDto.CountFreightItemValue>> skuMap = shopFreightCountReqDto.getItemAttrValues().stream().collect(Collectors.groupingBy(ShopFreightCountReqDto.CountFreightItemValue::getSkuId));
        for (String key : skuMap.keySet()) {
            List<ShopFreightCountReqDto.CountFreightItemValue> countFreightItemValues = skuMap.get(key);
            FreightTemplateRespDto freightTemplateRespDto = countFreightItemValues.get(0).getFreightTemplateRespDto();
            if (this.isFreeFreightMatch(freightTemplateRespDto, countFreightItemValues, shopFreightCountReqDto)) continue;
            return false;
        }
        return true;
    }

    private boolean isFreeFreightMatch(FreightTemplateRespDto freightTemplateRespDto, List<ShopFreightCountReqDto.CountFreightItemValue> countFreightItemValues, ShopFreightCountReqDto shopFreightCountReqDto) {
        if (freightTemplateRespDto == null || CollectionUtils.isEmpty((Collection)freightTemplateRespDto.getFreeFreightRuleList())) {
            return false;
        }
        if (Integer.valueOf(0).equals(freightTemplateRespDto.getFreeFreight().intValue())) {
            return false;
        }
        for (FreeFreightRuleRespDto freeFreightRuleRespDto : freightTemplateRespDto.getFreeFreightRuleList()) {
            if (!this.isMatchFreeFreightRule(countFreightItemValues, shopFreightCountReqDto, freeFreightRuleRespDto).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean ifFreeFreightSingle(ShopFreightCountReqDto shopFreightCountReqDto) {
        this.logger.info("\u8ba1\u7b97\u5355\u4e2asku\u662f\u5426\u5305\u90ae:{}", (Object)JacksonUtil.toJSon((Object)shopFreightCountReqDto));
        Map<String, List<ShopFreightCountReqDto.CountFreightItemValue>> skuMap = shopFreightCountReqDto.getItemAttrValues().stream().collect(Collectors.groupingBy(ShopFreightCountReqDto.CountFreightItemValue::getSkuId));
        for (String key : skuMap.keySet()) {
            List<ShopFreightCountReqDto.CountFreightItemValue> countFreightItemValues = skuMap.get(key);
            this.logger.info("\u8ba1\u7b97\u5355\u4e2asku\u662f\u5426\u5305\u90aeShopFreightCountReqDto:{}", (Object)JacksonUtil.toJSon(countFreightItemValues));
            FreightTemplateRespDto freightTemplateRespDto = countFreightItemValues.get(0).getFreightTemplateRespDto();
            if (!this.isFreeFreightMatch(freightTemplateRespDto, countFreightItemValues, shopFreightCountReqDto)) continue;
            return true;
        }
        return false;
    }

    private boolean ifFreeShopFreight(FreightTemplateRespDto freightTemplate, ShopFreightCountReqDto shopFreightCountReqDto) {
        return this.isFreeFreightMatch(freightTemplate, shopFreightCountReqDto.getItemAttrValues(), shopFreightCountReqDto);
    }

    public BigDecimal countShopFreightAmount(ShopFreightCountReqDto shopFreightCountReqDto, CountFreightRuleReqDto countFreightRuleReqDto) {
        if (this.ifFreeShopFreight(countFreightRuleReqDto.getFreightTemplate(), shopFreightCountReqDto)) {
            return BigDecimal.ZERO;
        }
        BigDecimal freightAmount = this.countFreightAmount(countFreightRuleReqDto.getFreightTemplate(), shopFreightCountReqDto, shopFreightCountReqDto.getItemAttrValues());
        return freightAmount;
    }

    public BigDecimal countFreightAmount(ShopFreightCountReqDto shopFreightCountReqDto, CountFreightRuleReqDto countFreightRuleReqDto) {
        if (countFreightRuleReqDto.getShop().getFreightMailType() != null && countFreightRuleReqDto.getShop().getFreightMailType().equals(FreightCountType.IF_MATCH_ALL) ? this.ifFreeFreightAll(shopFreightCountReqDto) : this.ifFreeFreightSingle(shopFreightCountReqDto)) {
            return BigDecimal.ZERO;
        }
        if (countFreightRuleReqDto.getShop().getFreightCountType() != null && countFreightRuleReqDto.getShop().getFreightCountType().equals(FreightCountType.IF_ADD)) {
            return this.addCountFreight(shopFreightCountReqDto);
        }
        return this.maxCountFreight(shopFreightCountReqDto);
    }

    private BigDecimal countFreightByRule(BigDecimal totalAmount, FreightRuleRespDto matchFreightRuleRespDto) {
        if (totalAmount.compareTo(matchFreightRuleRespDto.getFirstValue()) <= 0) {
            return matchFreightRuleRespDto.getFirstFreight();
        }
        BigDecimal addAmount = BigDecimal.ZERO;
        if (matchFreightRuleRespDto.getContinueValue().compareTo(BigDecimal.ZERO) > 0) {
            addAmount = totalAmount.subtract(matchFreightRuleRespDto.getFirstValue()).divide(matchFreightRuleRespDto.getContinueValue()).setScale(0, 0).multiply(matchFreightRuleRespDto.getContinueFreight());
        }
        return matchFreightRuleRespDto.getFirstFreight().add(addAmount);
    }

    private BigDecimal addCountFreight(ShopFreightCountReqDto shopFreightCountReqDto) {
        this.logger.info("addCountFreight:{}", (Object)JacksonUtil.toJSon((Object)shopFreightCountReqDto));
        BigDecimal totalFreight = BigDecimal.ZERO;
        Map<String, List<ShopFreightCountReqDto.CountFreightItemValue>> skuMap = shopFreightCountReqDto.getItemAttrValues().stream().collect(Collectors.groupingBy(ShopFreightCountReqDto.CountFreightItemValue::getSkuId));
        for (String skuId : skuMap.keySet()) {
            List<ShopFreightCountReqDto.CountFreightItemValue> countFreightItemValues = skuMap.get(skuId);
            FreightTemplateRespDto freightTemplateRespDto = countFreightItemValues.get(0).getFreightTemplateRespDto();
            BigDecimal freightAmount = this.countFreightAmount(freightTemplateRespDto, shopFreightCountReqDto, countFreightItemValues);
            totalFreight = totalFreight.add(freightAmount);
        }
        return totalFreight;
    }

    private BigDecimal countFreightAmount(FreightTemplateRespDto freightTemplateRespDto, ShopFreightCountReqDto shopFreightCountReqDto, List<ShopFreightCountReqDto.CountFreightItemValue> countFreightItemValues) {
        this.logger.info("countFreightAmount\u65b9\u6cd5,countFreightItemValues\u5165\u53c2:{}", (Object)JSON.toJSONString(countFreightItemValues));
        BigDecimal freightAmount = BigDecimal.ZERO;
        if (freightTemplateRespDto != null) {
            FreightRuleRespDto matchFreightRuleRespDto = this.getMatchFreightRuleRespDto(freightTemplateRespDto.getFreightRuleList(), shopFreightCountReqDto);
            this.logger.info("countFreightAmount\u65b9\u6cd5\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)matchFreightRuleRespDto));
            if (matchFreightRuleRespDto != null) {
                freightAmount = this.countRulesFreightAmount(freightTemplateRespDto, countFreightItemValues, matchFreightRuleRespDto);
            }
        }
        return freightAmount;
    }

    private BigDecimal countRulesFreightAmount(FreightTemplateRespDto freightTemplateRespDto, List<ShopFreightCountReqDto.CountFreightItemValue> countFreightItemValues, FreightRuleRespDto matchFreightRuleRespDto) {
        if (FreightCountType.FREIGHT_COUNT_TYPE_AMOUNT.equals(freightTemplateRespDto.getFreightType().intValue())) {
            return matchFreightRuleRespDto.getFixedCost();
        }
        BigDecimal totalAmount = this.countTotalByType(countFreightItemValues, (int)freightTemplateRespDto.getFreightType());
        return this.countFreightByRule(totalAmount, matchFreightRuleRespDto);
    }

    private BigDecimal maxCountFreight(ShopFreightCountReqDto shopFreightCountReqDto) {
        this.logger.info("\u8ba1\u7b97\u6700\u5927\u7684\u8fd0\u8d39:{}", (Object)JacksonUtil.toJson((Object)shopFreightCountReqDto));
        BigDecimal maxFreight = BigDecimal.ZERO;
        Map<String, List<ShopFreightCountReqDto.CountFreightItemValue>> skuMap = shopFreightCountReqDto.getItemAttrValues().stream().collect(Collectors.groupingBy(ShopFreightCountReqDto.CountFreightItemValue::getSkuId));
        for (String skuId : skuMap.keySet()) {
            List<ShopFreightCountReqDto.CountFreightItemValue> countFreightItemValues = skuMap.get(skuId);
            FreightTemplateRespDto freightTemplateRespDto = countFreightItemValues.get(0).getFreightTemplateRespDto();
            BigDecimal freightAmount = this.countFreightAmount(freightTemplateRespDto, shopFreightCountReqDto, countFreightItemValues);
            if (freightAmount.compareTo(maxFreight) <= 0) continue;
            maxFreight = freightAmount;
        }
        return maxFreight;
    }

    private FreightRuleRespDto getMatchFreightRuleRespDto(List<FreightRuleRespDto> freightRuleList, ShopFreightCountReqDto shopFreightCountReqDto) {
        if (CollectionUtils.isEmpty(freightRuleList)) {
            return null;
        }
        for (FreightRuleRespDto freightRuleRespDto : freightRuleList) {
            for (String code : freightRuleRespDto.getAreaCodes()) {
                if (!code.equals(shopFreightCountReqDto.getAreaCode()) && !code.equals(shopFreightCountReqDto.getCityCode()) && !code.equals(shopFreightCountReqDto.getProvinceCode())) continue;
                return freightRuleRespDto;
            }
        }
        return null;
    }

    @Override
    public BigDecimal count(DistanceFreightCountReqDto distanceFreightCountReqDto) {
        if (distanceFreightCountReqDto.getDistance() == null) {
            if (distanceFreightCountReqDto.getDestinationLat() == null || distanceFreightCountReqDto.getDestinationLon() == null) {
                throw new BizException("\u76ee\u7684\u5730\u7684\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (distanceFreightCountReqDto.getOriginLat() == null || distanceFreightCountReqDto.getOriginLon() == null) {
                throw new BizException("\u6e90\u5730\u5740\u7684\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            double distance = LocationUtils.getDistance(distanceFreightCountReqDto.getOriginLon(), distanceFreightCountReqDto.getOriginLat(), distanceFreightCountReqDto.getDestinationLon(), distanceFreightCountReqDto.getDestinationLat());
            distanceFreightCountReqDto.setDistance(Double.valueOf(distance));
        }
        if (distanceFreightCountReqDto.getBaseDistance() == null || distanceFreightCountReqDto.getBaseDistance().equals(0.0)) {
            return distanceFreightCountReqDto.getBaseFreight();
        }
        if (distanceFreightCountReqDto.getIncreaseDistance() == null || distanceFreightCountReqDto.getIncreaseDistance().equals(0.0)) {
            return distanceFreightCountReqDto.getBaseFreight();
        }
        if (distanceFreightCountReqDto.getIncreaseFreight() == null || distanceFreightCountReqDto.getIncreaseFreight().compareTo(BigDecimal.ZERO) == 0) {
            return distanceFreightCountReqDto.getBaseFreight();
        }
        if (distanceFreightCountReqDto.getDistance() <= distanceFreightCountReqDto.getBaseDistance()) {
            return distanceFreightCountReqDto.getBaseFreight();
        }
        Double overDistance = distanceFreightCountReqDto.getDistance() - distanceFreightCountReqDto.getBaseDistance();
        if (overDistance == null || overDistance.equals(0.0)) {
            return distanceFreightCountReqDto.getBaseFreight();
        }
        BigDecimal overFreight = distanceFreightCountReqDto.getIncreaseFreight().multiply(new BigDecimal(Math.ceil(overDistance / distanceFreightCountReqDto.getIncreaseDistance())));
        BigDecimal totalFreight = distanceFreightCountReqDto.getBaseFreight().add(overFreight);
        return totalFreight;
    }
}

