/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.agg.apiimpl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.ISubStationApi;
import com.dtyunxi.yundt.cube.center.shop.api.agg.ISubStationAggApi;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.SubStation;
import com.dtyunxi.yundt.cube.center.shop.api.agg.constant.SubStationConstant;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SubStationDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SubStationQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISubStationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="subStationAggApiImpl")
public class SubStationAggApiImpl
implements ISubStationAggApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubStationQueryApi subStationQueryApi;
    @Autowired
    private ISubStationApi subStationApi;
    @Autowired
    private IContext context;
    @Resource
    private IAreaQueryApi areaQueryApi;

    public RestResponse<Long> create(SubStation subStation) {
        SubStationDto subStationDto = new SubStationDto();
        CubeBeanUtils.copyProperties((Object)subStationDto, (Object)subStation, (String[])new String[0]);
        subStationDto.setTenantId(this.context.tenantId());
        subStationDto.setInstanceId(this.context.instanceId());
        return this.subStationApi.addSubStation(subStationDto);
    }

    public RestResponse<Long> modify(SubStation subStation) {
        SubStationDto subStationDto = new SubStationDto();
        CubeBeanUtils.copyProperties((Object)subStationDto, (Object)subStation, (String[])new String[0]);
        RestResponse response = this.subStationApi.modifySubStation(subStationDto);
        if (!"0".equals(response.getResultCode())) {
            throw new BizException(response.getResultCode(), response.getResultMsg());
        }
        return new RestResponse((Object)subStation.getId());
    }

    public RestResponse<Void> enableShop(Long id) {
        SubStationDto subStationDto = new SubStationDto();
        subStationDto.setId(id);
        subStationDto.setStatus(SubStationConstant.STATUS_ENABLE);
        RestResponse response = this.subStationApi.modifySubStation(subStationDto);
        if (!"0".equals(response.getResultCode())) {
            throw new BizException(response.getResultCode(), response.getResultMsg());
        }
        return new RestResponse();
    }

    public RestResponse<Void> disableShop(Long id) {
        SubStationDto subStationDto = new SubStationDto();
        subStationDto.setId(id);
        subStationDto.setStatus(SubStationConstant.STATUS_DISABLE);
        RestResponse response = this.subStationApi.modifySubStation(subStationDto);
        if (!"0".equals(response.getResultCode())) {
            throw new BizException(response.getResultCode(), response.getResultMsg());
        }
        return new RestResponse();
    }

    public RestResponse<SubStation> matchSubStation(String city) {
        Assert.notNull((Object)city, (String)"\u53c2\u6570\u4e3a\u7a7a");
        SubStationQueryDto subStationQueryDto = new SubStationQueryDto();
        subStationQueryDto.setAddress(city);
        RestResponse pageResponse = this.subStationQueryApi.queryByConditions(subStationQueryDto, 1, 1);
        if (!"0".equals(pageResponse.getResultCode())) {
            throw new BizException(pageResponse.getResultCode(), pageResponse.getResultMsg());
        }
        PageInfo resultPage = (PageInfo)pageResponse.getData();
        List subStationDtoList = resultPage.getList();
        SubStation subStation = null;
        if (CollectionUtils.isNotEmpty((Collection)subStationDtoList)) {
            subStation = new SubStation();
            CubeBeanUtils.copyProperties((Object)subStation, subStationDtoList.get(0), (String[])new String[0]);
        }
        return new RestResponse((Object)subStation);
    }

    public RestResponse<SubStation> getById(Long id) {
        RestResponse restResponse;
        RestResponse subStationResponse = this.subStationQueryApi.queryById(id.longValue());
        if (!"0".equals(subStationResponse.getResultCode())) {
            throw new BizException(subStationResponse.getResultCode(), subStationResponse.getResultMsg());
        }
        SubStationDto subStationDto = (SubStationDto)subStationResponse.getData();
        SubStation subStation = new SubStation();
        CubeBeanUtils.copyProperties((Object)subStation, (Object)subStationDto, (String[])new String[0]);
        if (null != subStation && StringUtils.isNotBlank((CharSequence)subStation.getCityCode()) && null != (restResponse = this.areaQueryApi.queryByCode(subStation.getCityCode())).getData()) {
            subStation.setCity(((AreaDto)restResponse.getData()).getName());
        }
        return new RestResponse((Object)subStation);
    }

    public RestResponse<PageInfo<SubStation>> querySubStationByPage(SubStationQueryDto subStationQueryDto, Integer pageNum, Integer pageSize) {
        Long instanceId = this.context.instanceId();
        Long tenantId = this.context.tenantId();
        subStationQueryDto.setInstanceId(instanceId);
        subStationQueryDto.setTenantId(tenantId);
        RestResponse pageResponse = this.subStationQueryApi.queryByConditions(subStationQueryDto, pageSize.intValue(), pageNum.intValue());
        if (!"0".equals(pageResponse.getResultCode())) {
            throw new BizException(pageResponse.getResultCode(), pageResponse.getResultMsg());
        }
        PageInfo resultPage = (PageInfo)pageResponse.getData();
        List subStationDtoList = ((PageInfo)pageResponse.getData()).getList();
        ArrayList<SubStation> subStationList = new ArrayList<SubStation>();
        if (CollectionUtils.isNotEmpty((Collection)subStationDtoList)) {
            for (SubStationDto subStationDto : subStationDtoList) {
                SubStation subStationRespDto = new SubStation();
                CubeBeanUtils.copyProperties((Object)subStationRespDto, (Object)subStationDto, (String[])new String[0]);
                subStationList.add(subStationRespDto);
            }
            resultPage.setList(subStationList);
        }
        return new RestResponse((Object)resultPage);
    }
}

