/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.apiimpl.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.AddressAreaReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopAreaDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopTransportPartnerDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopWarehouseDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.freight.ShopFreightCountReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.FreightCountRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.validation.annotation.Validated;

@Service(value="shopQueryApi")
public class ShopQueryApiImpl
implements IShopQueryApi {
    @Resource
    private IShopService shopService;

    @Validated
    public RestResponse<PageInfo<ShopDto>> queryBySellerId(@Min(value=1L, message="\u5546\u6237ID\u5fc5\u987b\u4e3a\u5408\u6cd5\u6570\u503c") @Min(value=1L, message="\u5546\u6237ID\u5fc5\u987b\u4e3a\u5408\u6cd5\u6570\u503c") long sellerId, @Min(value=1L, message="\u9875\u5927\u5c0f\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") @Min(value=1L, message="\u9875\u5927\u5c0f\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") int pageSize, @Min(value=1L, message="\u5f53\u524d\u9875\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") @Min(value=1L, message="\u5f53\u524d\u9875\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") int page) {
        ShopQueryDto dto = new ShopQueryDto();
        dto.setSellerId(Long.valueOf(sellerId));
        PageInfo<ShopDto> lists = this.shopService.queryByConditions(dto, pageSize, page);
        return new RestResponse(lists);
    }

    @Validated
    public RestResponse<List<ShopAreaDto>> queryShopAreaByShopIds(AddressAreaReqDto reqDto) {
        return new RestResponse(this.shopService.queryShopAreaByShopIds(reqDto));
    }

    @Validated
    public RestResponse<PageInfo<ShopDto>> queryByTenantId(@Min(value=1L, message="\u79df\u6237ID\u5fc5\u987b\u4e3a\u5408\u6cd5\u6570\u503c") @Min(value=1L, message="\u79df\u6237ID\u5fc5\u987b\u4e3a\u5408\u6cd5\u6570\u503c") long tenantId, @Min(value=1L, message="\u9875\u5927\u5c0f\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") @Min(value=1L, message="\u9875\u5927\u5c0f\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") int pageSize, @Min(value=1L, message="\u5f53\u524d\u9875\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") @Min(value=1L, message="\u5f53\u524d\u9875\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") int page) {
        ShopQueryDto dto = new ShopQueryDto();
        dto.setTenantId(Long.valueOf(tenantId));
        PageInfo<ShopDto> lists = this.shopService.queryByConditions(dto, pageSize, page);
        return new RestResponse(lists);
    }

    @Validated
    public RestResponse<PageInfo<ShopDto>> queryByConditions(ShopQueryDto shopQueryDto, @Min(value=1L, message="\u9875\u5927\u5c0f\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") @Min(value=1L, message="\u9875\u5927\u5c0f\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") int pageSize, @Min(value=1L, message="\u5f53\u524d\u9875\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") @Min(value=1L, message="\u5f53\u524d\u9875\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") int page) {
        PageInfo<ShopDto> lists = this.shopService.queryByConditions(shopQueryDto, pageSize, page);
        return new RestResponse(lists);
    }

    public RestResponse<ShopDto> queryById(long shopId, String ... enums) {
        ShopDto dto = this.shopService.queryById(shopId, enums);
        return new RestResponse((Object)dto);
    }

    public RestResponse<ShopDto> queryByCode(String code) {
        ShopDto dto = this.shopService.queryByCode(code);
        return new RestResponse((Object)dto);
    }

    public RestResponse<ShopBaseDto> queryBaseById(Long shopId) {
        return new RestResponse((Object)this.shopService.queryBaseById(shopId));
    }

    public RestResponse<ShopBaseDto> queryBaseDasById(Long shopId) {
        return new RestResponse((Object)this.shopService.queryBaseDasById(shopId));
    }

    public RestResponse<List<ShopBaseDto>> queryBaseListByIds(@NotNull Set<Long> shopIds) {
        return new RestResponse(this.shopService.queryBaseListByIds(shopIds));
    }

    public RestResponse<List<ShopDto>> queryByIds(@NotNull Set<Long> shopIds) {
        return new RestResponse(this.shopService.queryByIds(shopIds));
    }

    public RestResponse<List<ShopAreaDto>> queryShopAreas(ShopAreaDto shopAreaDto) {
        return new RestResponse(this.shopService.queryShopAreaList(shopAreaDto));
    }

    @Validated
    public RestResponse<PageInfo<ShopDto>> queryStoreShopList(ShopQueryDto shopQueryDto, @Min(value=1L, message="\u9875\u5927\u5c0f\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") @Min(value=1L, message="\u9875\u5927\u5c0f\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") int pageSize, @Min(value=1L, message="\u5f53\u524d\u9875\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") @Min(value=1L, message="\u5f53\u524d\u9875\u5fc5\u987b\u4e3a\u6b63\u6574\u6570") int page) {
        PageInfo<ShopDto> lists = this.shopService.queryStoreShopList(shopQueryDto, pageSize, page);
        return new RestResponse(lists);
    }

    public RestResponse<FreightCountRespDto> countFreight(Long addressId, Long shopId) {
        ShopFreightCountReqDto shopFreightCountReqDto = new ShopFreightCountReqDto();
        shopFreightCountReqDto.setAddressId(addressId);
        shopFreightCountReqDto.setShopId(shopId);
        FreightCountRespDto freightCountRespDto = this.shopService.countFreight(shopFreightCountReqDto);
        return new RestResponse((Object)freightCountRespDto);
    }

    public RestResponse<List<ShopWarehouseDto>> queryShopWarehouseByShopId(Long shopId, Integer type) {
        List<ShopWarehouseDto> list = this.shopService.queryShopWarehouseByShopId(shopId, type);
        return new RestResponse(list);
    }

    public RestResponse<List<ShopDto>> queryShopList(ShopQueryDto queryCondition) {
        return new RestResponse(this.shopService.queryShopList(queryCondition));
    }

    public RestResponse<List<ShopDto>> queryShopListNew(ShopQueryDto queryCondition) {
        return new RestResponse(this.shopService.queryShopList(queryCondition));
    }

    public RestResponse<List<ShopTransportPartnerDto>> queryShopTransportPartner(Long shopId) {
        return new RestResponse(this.shopService.queryShopTransportPartnerList(shopId));
    }

    public RestResponse<Integer> countByFreightTemplateId(Long freightTemplateId) {
        return null;
    }

    public RestResponse<ShopDto> queryEarliestShop() {
        return new RestResponse((Object)this.shopService.queryEarliestShop());
    }

    public RestResponse<List<ShopDto>> shopList(ShopQueryDto queryCondition) {
        return new RestResponse(this.shopService.shopList(queryCondition));
    }

    public RestResponse<List<ShopDto>> queryByIdsOnPost(@NotNull Set<Long> shopIds) {
        return new RestResponse(this.shopService.queryByIds(shopIds));
    }

    public RestResponse<List<ShopDto>> queryShopByCode(ShopQueryReqDto dto) {
        return new RestResponse(this.shopService.queryShopByCode(dto.getCodes()));
    }

    public RestResponse<PageInfo<ShopBaseDto>> queryBaseShopPage(ShopQueryDto shopQueryDto, Integer pageSize, Integer page) {
        PageInfo<ShopBaseDto> lists = this.shopService.queryBaseShopPage(shopQueryDto, pageSize, page);
        return new RestResponse(lists);
    }

    public RestResponse<List<ShopBaseDto>> queryBaseShopList(ShopQueryDto shopQueryDto) {
        List<ShopBaseDto> lists = this.shopService.queryBaseShopList(shopQueryDto);
        return new RestResponse(lists);
    }

    public RestResponse<Long> countShop(ShopQueryDto shopQueryDto) {
        return new RestResponse((Object)this.shopService.countShop(shopQueryDto));
    }
}

