/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.AuditQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.AuditDataRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.enums.SellApplyTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.api.exception.ShopExceptionCode;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IAuditDataService;
import com.dtyunxi.yundt.cube.center.shop.dao.das.AuditDataDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.AuditDataEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuditDataServiceImpl
implements IAuditDataService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    AuditDataDas auditDataDas;
    @Autowired
    IContext context;

    @Override
    public Long addAuditData(Long businessId, String businessType, String data, String shopStatus) {
        AuditDataEo ad = (AuditDataEo)this.auditDataDas.getMapper().selectOne((Wrapper)new QueryWrapper().eq((Object)"business_Id", (Object)businessId));
        AuditDataEo auditDataEo = ad != null ? ad : AuditDataEo.newInstance();
        auditDataEo.setBusinessId(businessId);
        auditDataEo.setData(data);
        boolean isDraft = "DRAFT".equals(shopStatus);
        auditDataEo.setStatus(isDraft ? "DRAFT" : "PENDING");
        auditDataEo.setBusinessType(businessType);
        auditDataEo.setTenantId(this.context.tenantId());
        auditDataEo.setInstanceId(this.context.instanceId());
        auditDataEo.setAuditPerson("\u5c1a\u65e0\u5ba1\u6838\u4eba\u5458");
        auditDataEo.setAuditTime(new Date());
        auditDataEo.setApplyType(SellApplyTypeEnum.ADD.toCode());
        String applyCode = "" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMdd") + Math.round((Math.random() + 1.0) * 1000.0);
        auditDataEo.setApplyCode(applyCode);
        auditDataEo.setApplyPerson(this.context.userName());
        if (ad != null) {
            this.auditDataDas.updateSelective((BaseEo)auditDataEo);
        } else {
            this.auditDataDas.insert((BaseEo)auditDataEo);
        }
        return auditDataEo.getId();
    }

    @Override
    public AuditDataEo queryAuditDataByKey(Long id) {
        if (id == null || this.auditDataDas.selectByPrimaryKey(id) == null) {
            this.logger.info("ID\u4e3a\u7a7a\u6216\u8005\u4e0d\u5b58\u5728ID\u4e3a" + id + "\u7684\u5ba1\u6838\u4fe1\u606f");
            throw new BizException(ShopExceptionCode.AUDITDATA_QUERY_DEFULT.getCode(), ShopExceptionCode.AUDITDATA_QUERY_DEFULT.getMsg());
        }
        return (AuditDataEo)this.auditDataDas.selectByPrimaryKey(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public boolean modifyAuditData(AuditDataEo auditDataEo) {
        Long id = auditDataEo.getId();
        if (id == null || this.queryAuditDataByKey(id) == null) {
            this.logger.info("\u66f4\u65b0\u533a\u57df\u4fe1\u606f\u5931\u8d25\uff1aID\u4e3a\u7a7a\u6216\u8005\u627e\u4e0d\u5230\u5bf9\u5e94ID\u5b9e\u4f53");
            throw new BizException(ShopExceptionCode.AUDITDATA_UPDATE_DEFULT.getCode(), ShopExceptionCode.AUDITDATA_UPDATE_DEFULT.getMsg());
        }
        this.auditDataDas.updateSelective((BaseEo)auditDataEo);
        Boolean flag = true;
        return flag;
    }

    @Override
    public List<AuditDataEo> queryList(AuditQueryReqDto auditQueryReqDto) {
        AuditDataEo auditDataEo = (AuditDataEo)BaseEo.newInstance(AuditDataEo.class, (Map)auditQueryReqDto.getExtFields());
        if (StringUtils.isNotBlank((CharSequence)auditQueryReqDto.getStatus())) {
            auditDataEo.setStatus(auditQueryReqDto.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)auditQueryReqDto.getBusinessType())) {
            auditDataEo.setBusinessType(auditQueryReqDto.getBusinessType());
        }
        if (auditQueryReqDto.getBusinessId() != null) {
            auditDataEo.setBusinessId(auditQueryReqDto.getBusinessId());
        }
        return this.auditDataDas.select((BaseEo)auditDataEo, false);
    }

    @Override
    public PageInfo<AuditDataRespDto> queryPage(AuditQueryReqDto auditQueryReqDto) {
        PageInfo pageInfo = new PageInfo();
        PageHelper.startPage((int)auditQueryReqDto.getPageNum(), (int)auditQueryReqDto.getPageSize());
        List<AuditDataEo> auditDataEos = this.queryList(auditQueryReqDto);
        if (CollectionUtils.isNotEmpty(auditDataEos)) {
            ArrayList auditDataRespDtos = Lists.newArrayList();
            DtoHelper.eoList2DtoList(auditDataEos, (Collection)auditDataRespDtos, AuditDataRespDto.class);
            pageInfo = new PageInfo((List)auditDataRespDtos);
        }
        return pageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public Long saveAuditData(AuditDataEo auditDataEo) {
        if (this.auditDataDas.insert((BaseEo)auditDataEo) != 0) {
            return auditDataEo.getId();
        }
        this.logger.info("\u65b0\u589e\u5931\u8d25");
        throw new BizException(ShopExceptionCode.AUDITDATA_INSERT_DEFULT.getCode(), ShopExceptionCode.AUDITDATA_INSERT_DEFULT.getMsg());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, readOnly=false)
    public boolean removeById(Long auditDataId) {
        boolean flag = false;
        if (auditDataId == null) {
            this.logger.info("\u5220\u9664\u5ba1\u6838\u4fe1\u606f\u5931\u8d25\uff1aID\u4e3a\u7a7a");
            throw new BizException(ShopExceptionCode.AUDITDATA_DELET_DEFULT.getCode(), ShopExceptionCode.AUDITDATA_DELET_DEFULT.getMsg());
        }
        if (this.auditDataDas.selectByPrimaryKey(auditDataId) != null) {
            this.auditDataDas.deleteById(auditDataId);
            flag = true;
            return flag;
        }
        return flag;
    }

    @Override
    public AuditDataEo queryAuditData(AuditDataEo auditDataEo) {
        return (AuditDataEo)this.auditDataDas.selectOne((BaseEo)auditDataEo);
    }
}

