/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.enums.DistanceUnit;
import com.dtyunxi.huieryun.opensearch.enums.ShapeType;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.utils.CustomBeanUtils;
import com.dtyunxi.huieryun.opensearch.vo.GeoShapeFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.huieryun.opensearch.vo.SortFieldVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.CoordinateDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.LocationDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDeliveryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopEsDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.TemplateRegionRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.GeoDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopLocationDto;
import com.dtyunxi.yundt.cube.center.shop.api.enums.ShopTypeEnum;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopSearchService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.impl.ShopServiceImpl;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ShopSearchServiceImpl
implements IShopSearchService {
    private static Logger logger = LoggerFactory.getLogger(ShopServiceImpl.class);
    @Value(value="${huieryun.searchindexbuilder.indexname.prefix}")
    private String INDEX_SHOP;
    private static final String INDEX_TYPE_NAME = "shop";
    public static final String SHOP_SEARCH_SHOP_HOUSE = "templateRegionList";
    public static final String SHOP_LOCATION = "location";
    @Value(value="${cube.global.profile:dev}")
    private String globalProfile;
    @Resource
    private IShopService shopService;
    @Resource
    private IAreaQueryApi areaQueryApi;
    @Resource
    private IOpenSearchService openSearchService;
    @Resource
    private ISearchIndexService searchIndexService;

    @Override
    public boolean checkRangeShop(Double lon, Double lat, String ids) {
        OSSearchVo osSearchVo = new OSSearchVo();
        GeoShapeFieldVo.PointType pointType = new GeoShapeFieldVo.PointType(lat.doubleValue(), lon.doubleValue());
        GeoShapeFieldVo geoShapeFieldVo = new GeoShapeFieldVo(SHOP_SEARCH_SHOP_HOUSE, ShapeType.POINT, pointType);
        String[] idArray = ids.split(",");
        osSearchVo.addGeoShapeQuery(new GeoShapeFieldVo[]{geoShapeFieldVo});
        osSearchVo.addInFilter("shopId", idArray);
        SearchResultVo searchResultVo = this.search(osSearchVo);
        return searchResultVo != null && searchResultVo.getTotalSize() > 0L;
    }

    @Override
    public void sysShopToEs(Long shopId) {
        logger.info("shopId={}\u540c\u6b65\u5e97\u94fa\u4fe1\u606f\u5f00\u59cb==========", (Object)shopId);
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.addEqualFilter("shopId", shopId.toString());
        SearchResultVo searchResultVo = this.search(osSearchVo);
        long totalSize = searchResultVo == null ? 0L : searchResultVo.getTotalSize();
        ShopDto shopDto = this.shopService.queryById(shopId, new String[0]);
        if (null == shopDto) {
            logger.info("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728shopId={}", (Object)shopId);
            if (totalSize > 0L) {
                this.delete(shopId.toString());
            }
        } else {
            logger.info("\u5e97\u94fashopId={}\uff0ctype={}\uff0c\u5e97\u94fa\u4fe1\u606f={}", new Object[]{shopId, shopDto.getType(), shopDto});
            if (shopDto.getType() != null && ShopTypeEnum.O2O.getCode().equals(shopDto.getType().intValue())) {
                ShopEsDto shopEsDto = this.convert(shopDto);
                if (totalSize > 0L) {
                    this.update(shopEsDto);
                } else {
                    this.create(shopEsDto);
                }
            } else if (totalSize > 0L) {
                this.delete(shopId.toString());
            }
        }
        logger.info("shopId={}\u540c\u6b65\u5e97\u94fa\u4fe1\u606f\u7ed3\u675f==========", (Object)shopId);
    }

    private ShopEsDto convert(ShopDto shopDto) {
        ShopEsDto shopEsDto = new ShopEsDto();
        shopEsDto.setShopId(shopDto.getId());
        shopEsDto.setBusinessType(shopDto.getBusinessType());
        shopEsDto.setShopName(shopDto.getName());
        shopEsDto.setAddress(shopDto.getAddress());
        shopEsDto.setType(shopDto.getType());
        shopEsDto.setManageType(shopDto.getManageType());
        shopEsDto.setCityDelivery(shopDto.getCityDelivery());
        shopEsDto.setDeliveryType(shopDto.getDeliveryType());
        shopEsDto.setSelfPickUp(shopDto.getSelfPickUp());
        shopEsDto.setStatus(shopDto.getStatus());
        shopEsDto.setBusinessType(Integer.valueOf(shopDto.getType().intValue()));
        shopEsDto.setContactPhone(shopDto.getContactPhone());
        ArrayList<LocationDto> locationDtos = new ArrayList<LocationDto>();
        ShopLocationDto shopLocationDto = this.getShopDeliveryGeo(shopDto);
        GeoDto geoDto = shopLocationDto.getGeoDto();
        if (null != geoDto) {
            LocationDto locationDto = new LocationDto();
            locationDto.setLon(Double.valueOf(geoDto.getLongitude()));
            locationDto.setLat(Double.valueOf(geoDto.getLatitude()));
            locationDtos.add(locationDto);
        }
        shopEsDto.setLocation(locationDtos);
        String provinceCode = shopLocationDto.getAddressProvince();
        String cityCode = shopLocationDto.getAddressCity();
        String regionCode = shopLocationDto.getAddressRegion();
        String detailAddress = shopLocationDto.getDetailAddress();
        String provinceName = null;
        String cityName = null;
        String countyName = null;
        if (provinceCode != null) {
            RestResponse province = this.areaQueryApi.queryByCode(provinceCode);
            provinceName = ((AreaDto)province.getData()).getName();
        }
        if (cityCode != null) {
            RestResponse city = this.areaQueryApi.queryByCode(cityCode);
            cityName = ((AreaDto)city.getData()).getName();
        }
        if (regionCode != null) {
            RestResponse county = this.areaQueryApi.queryByCode(regionCode);
            countyName = ((AreaDto)county.getData()).getName();
        }
        String shopAddress = provinceName + cityName + countyName + detailAddress;
        shopEsDto.setShopAddress(shopAddress);
        List<TemplateRegionRespDto> templateRegionList = this.getTemplateRegionRespDtoList(shopDto);
        shopEsDto.setTemplateRegionList(templateRegionList);
        return shopEsDto;
    }

    @Override
    public List<ShopEsDto> queryRangeShopListByGeo(Double lat, Double lon, Boolean isValidRegion) {
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setPageSize(1000);
        SortFieldVo sortFieldVo = SortFieldVo.build((String)SHOP_LOCATION, (SortOrder)SortOrder.ASC);
        sortFieldVo.setGeoDistanceSort(true);
        sortFieldVo.setLat(lat.doubleValue());
        sortFieldVo.setLon(lon.doubleValue());
        sortFieldVo.setDistanceUnit(DistanceUnit.METERS);
        osSearchVo.addSorts(new SortFieldVo[]{sortFieldVo});
        if (null != isValidRegion && isValidRegion.booleanValue()) {
            GeoShapeFieldVo.PointType pointType = new GeoShapeFieldVo.PointType(lat.doubleValue(), lon.doubleValue());
            GeoShapeFieldVo geoShapeFieldVo = new GeoShapeFieldVo(SHOP_SEARCH_SHOP_HOUSE, ShapeType.POINT, pointType);
            osSearchVo.addGeoShapeQuery(new GeoShapeFieldVo[]{geoShapeFieldVo});
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u5e97\u94fa\u641c\u7d22\u53c2\u6570osSearchVo={}", (Object)JSON.toJSONString((Object)osSearchVo));
        }
        SearchResultVo searchResultVo = this.search(osSearchVo);
        if (logger.isDebugEnabled()) {
            logger.debug("\u5e97\u94fa\u641c\u7d22\u7ed3\u679csearchResultVo={}", (Object)JSON.toJSONString((Object)searchResultVo));
        }
        if (null == searchResultVo) {
            return Collections.EMPTY_LIST;
        }
        return searchResultVo.getDocValues((TypeReference)new TypeReference<List<ShopEsDto>>(){});
    }

    private SearchResultVo search(OSSearchVo osSearchVo) {
        osSearchVo.setIndexName(this.INDEX_SHOP + "_" + INDEX_TYPE_NAME);
        osSearchVo.setTypeName(INDEX_TYPE_NAME);
        SearchResultVo search = null;
        try {
            search = this.openSearchService.search(osSearchVo);
        }
        catch (Exception e) {
            logger.info(" \u641c\u7d22es,\u8bbe\u7f6e\u7d22\u5f15\u540d\u79f0\u548ctype\u5931\u8d25,data----:" + JSONObject.toJSONString((Object)e.toString()));
            return null;
        }
        return search;
    }

    private ShopLocationDto getShopDeliveryGeo(ShopDto shopDtoEs) {
        ShopLocationDto shopLocationDto = new ShopLocationDto();
        ShopDeliveryDto shopDeliveryDto = shopDtoEs.getShopDeliveryDto();
        GeoDto geoDto = null;
        if (shopDeliveryDto != null) {
            String[] geo = StringUtils.split((String)shopDeliveryDto.getGeo(), (String)",");
            geoDto = new GeoDto();
            geoDto.setLongitude(geo[0]);
            geoDto.setLatitude(geo[1]);
        }
        shopLocationDto.setGeoDto(geoDto);
        shopLocationDto.setAddressProvince(shopDeliveryDto.getAddressProvince());
        shopLocationDto.setAddressCity(shopDeliveryDto.getAddressCity());
        shopLocationDto.setAddressRegion(shopDeliveryDto.getAddressRegion());
        shopLocationDto.setDetailAddress(shopDeliveryDto.getDetailAddress());
        return shopLocationDto;
    }

    private List<TemplateRegionRespDto> getTemplateRegionRespDtoList(ShopDto shopDtoEs) {
        List geoList;
        String geoFence;
        ArrayList templateRegionRespDtoList = Lists.newArrayList();
        ShopDeliveryDto shopDeliveryDto = shopDtoEs.getShopDeliveryDto();
        if (shopDeliveryDto != null && StringUtils.isNotBlank((CharSequence)(geoFence = shopDeliveryDto.getGeoFence())) && CollectionUtils.isNotEmpty(geoList = Stream.of(StringUtils.split((String)geoFence, (String)";")).map(geo -> {
            String[] geoPoints = StringUtils.split((String)geo, (String)",");
            if (geoPoints != null && geoPoints.length > 1) {
                return new CoordinateDto(Double.valueOf(Double.parseDouble(geoPoints[0])), Double.valueOf(Double.parseDouble(geoPoints[1])));
            }
            return null;
        }).collect(Collectors.toList()))) {
            CoordinateDto startPoint = (CoordinateDto)geoList.get(0);
            CoordinateDto endPoint = (CoordinateDto)geoList.get(geoList.size() - 1);
            if (startPoint.getLng().compareTo(endPoint.getLng()) != 0 || startPoint.getLat().compareTo(endPoint.getLat()) != 0) {
                geoList.add(startPoint);
            }
            ArrayList coordinates = new ArrayList();
            ArrayList geoFenceList = new ArrayList();
            for (CoordinateDto coordinateDto : geoList) {
                ArrayList<Double> pointsList = new ArrayList<Double>();
                pointsList.add(coordinateDto.getLng());
                pointsList.add(coordinateDto.getLat());
                geoFenceList.add(pointsList);
            }
            coordinates.add(geoFenceList);
            templateRegionRespDtoList.add(new TemplateRegionRespDto(coordinates));
        }
        return templateRegionRespDtoList;
    }

    private void create(ShopEsDto shopEsDto) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(String.valueOf(shopEsDto.getShopId()));
        Map describe = CustomBeanUtils.describe((Object)shopEsDto);
        indexDocContentVo.setDocValueMap(describe);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        logger.info("\u521b\u5efa\u7d22\u5f15\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.addData(indexDocumentVo);
    }

    private void update(ShopEsDto shopEsDto) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(String.valueOf(shopEsDto.getShopId()));
        Map describe = CustomBeanUtils.describe((Object)shopEsDto);
        indexDocContentVo.setDocValueMap(describe);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        logger.info("\u66f4\u65b0\u7d22\u5f15\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.updateData(indexDocumentVo);
    }

    private void delete(String indexId) {
        IndexDocumentVo indexDocumentVo = this.newInstance();
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo indexDocContentVo = new IndexDocContentVo();
        indexDocContentVo.setIndexId(indexId);
        contents.add(indexDocContentVo);
        indexDocumentVo.setContents((List)contents);
        logger.info("\u6839\u636eindexId\u5220\u9664\u6570\u636e:{}", (Object)JSON.toJSONString((Object)indexDocumentVo));
        this.searchIndexService.deleteData(indexDocumentVo);
    }

    private IndexDocumentVo newInstance() {
        return new IndexDocumentVo(this.INDEX_SHOP + "_" + INDEX_TYPE_NAME, INDEX_TYPE_NAME);
    }
}

