/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.svr.rest.agg;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.agg.IShopAggApi;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.Shop;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.ShopAudit;
import com.dtyunxi.yundt.cube.center.shop.api.agg.dto.request.ShopAggQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.agg.dto.response.ExportResultRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopTransportPartnerDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e97\u94fa\u7ec4\u4ef6\uff1a\u5e97\u94fa\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/shop"})
public class ShopAggRest
implements IShopAggApi {
    @Autowired
    private IShopAggApi shopAggApiImpl;

    @PutMapping(value={"/{shopId}/enable"})
    public RestResponse<Void> enableShop(@PathVariable(value="shopId") Long shopId) {
        return this.shopAggApiImpl.enableShop(shopId);
    }

    @PutMapping(value={"/{shopId}/disable"})
    public RestResponse<Void> disableShop(@PathVariable(value="shopId") Long shopId) {
        return this.shopAggApiImpl.disableShop(shopId);
    }

    @PutMapping(value={"/audit"})
    public RestResponse<Void> audit(@RequestBody ShopAudit shopAudit) {
        return this.shopAggApiImpl.audit(shopAudit);
    }

    @GetMapping(value={"/page"})
    public RestResponse<PageInfo<Shop>> queryShopByPage(ShopAggQueryDto shopAggQueryDto, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        return this.shopAggApiImpl.queryShopByPage(shopAggQueryDto, pageNum, pageSize);
    }

    @GetMapping(value={"/storeShopList"})
    public RestResponse<PageInfo<Shop>> queryStoreShopList(ShopQueryDto shopQueryDto, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        return this.shopAggApiImpl.queryStoreShopList(shopQueryDto, pageNum, pageSize);
    }

    @GetMapping(value={"/isCheckAddress"})
    public RestResponse<Integer> isCheckAddress(@RequestParam(value="locationX") String locationX, @RequestParam(value="locationY") String locationY, @RequestParam(value="shopIds") String shopIds) {
        return this.shopAggApiImpl.isCheckAddress(locationX, locationY, shopIds);
    }

    @GetMapping(value={"/{shopId}/partners"})
    public RestResponse<List<ShopTransportPartnerDto>> queryShopTransportPartner(@PathVariable(value="shopId") Long shopId) {
        return this.shopAggApiImpl.queryShopTransportPartner(shopId);
    }

    @GetMapping(value={"/exportShopList"})
    public RestResponse<ExportResultRespDto> exportShopList(ShopAggQueryDto shopQueryDto, @RequestParam(value="pageNum", defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize) {
        return this.shopAggApiImpl.exportShopList(shopQueryDto, pageNum, pageSize);
    }
}

