/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.api.constants;

import org.apache.commons.lang3.StringUtils;

public enum ShippingTypeEnum {
    EXPRESS(1, "express", "\u5feb\u9012"),
    INTRA_CITY(2, "intra-city", "\u540c\u57ce\u914d\u9001"),
    PICKUP(3, "pickup", "\u4e0a\u95e8\u81ea\u63d0"),
    CLERK(4, "clerk", "\u5e97\u5458\u914d\u9001");

    private int code;
    private String type;
    private String shippingTypeName;

    private ShippingTypeEnum(int code, String type, String shippingTypeName) {
        this.code = code;
        this.type = type;
        this.shippingTypeName = shippingTypeName;
    }

    public static ShippingTypeEnum getByCode(int code) {
        for (ShippingTypeEnum shipType : ShippingTypeEnum.values()) {
            if (code != shipType.getCode()) continue;
            return shipType;
        }
        return null;
    }

    public static ShippingTypeEnum getByType(String type) {
        for (ShippingTypeEnum shipType : ShippingTypeEnum.values()) {
            if (!type.equals(shipType.getType())) continue;
            return shipType;
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getShippingTypeName() {
        return this.shippingTypeName;
    }

    public void setShippingTypeName(String shippingTypeName) {
        this.shippingTypeName = shippingTypeName;
    }

    public static String getShippingTypeName(String type) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        for (ShippingTypeEnum shippingTypeEnum : ShippingTypeEnum.values()) {
            if (!shippingTypeEnum.getType().equals(type)) continue;
            return shippingTypeEnum.getShippingTypeName();
        }
        return null;
    }
}

