package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 业绩明细表Eo对象
 *
 * @author xitao
 * @since 2021-01-19
 */
@Table(name = "tr_achievement_detail")
public class StdAchievementDetailEo extends CubeBaseEo {

    public static StdAchievementDetailEo newInstance() {
        return (StdAchievementDetailEo) BaseEo.newInstance(StdAchievementDetailEo.class);
    }

    /**
     * 订单流水号
     */
    @Column(name = "order_no")
    private String orderNo;
    /**
     * 单据类型 1、销售单,2 换货单
     */
    @Column(name = "source_order_type")
    private Integer sourceOrderType;
    /**
     * 店铺id
     */
    @Column(name = "shop_id")
    private String shopId;
    /**
     * 业绩归属(店铺名称)
     */
    @Column(name = "shop_name")
    private String shopName;
    /**
     * 组织id
     */
    @Column(name = "org_id")
    private String orgId;
    /**
     * 组织编码
     */
    @Column(name = "org_code")
    private String orgCode;
    /**
     * 所属组织
     */
    @Column(name = "org_name")
    private String orgName;
    /**
     * 业务金额
     */
    @Column(name = "pay_amount")
    private BigDecimal payAmount;
    /**
     * 业绩类型 1、销售业绩,2 发货业绩
     */
    @Column(name = "achievement_type")
    private Integer achievementType;
    /**
     * 分成比例
     */
    @Column(name = "share_ratio")
    private BigDecimal shareRatio;
    /**
     * 分成金额
     */
    @Column(name = "share_amount")
    private String shareAmount;

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setSourceOrderType(Integer sourceOrderType) {
        this.sourceOrderType = sourceOrderType;
    }

    public Integer getSourceOrderType() {
        return this.sourceOrderType;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public String getShopId() {
        return this.shopId;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getShopName() {
        return this.shopName;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public BigDecimal getPayAmount() {
        return this.payAmount;
    }

    public void setAchievementType(Integer achievementType) {
        this.achievementType = achievementType;
    }

    public Integer getAchievementType() {
        return this.achievementType;
    }

    public void setShareRatio(BigDecimal shareRatio) {
        this.shareRatio = shareRatio;
    }

    public BigDecimal getShareRatio() {
        return this.shareRatio;
    }

    public void setShareAmount(String shareAmount) {
        this.shareAmount = shareAmount;
    }

    public String getShareAmount() {
        return this.shareAmount;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
}
