/*
 * @(#)AuditRecordEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_audit_record")
public class StdAuditRecordEo extends CubeBaseEo {
    public static StdAuditRecordEo newInstance() {
        return (StdAuditRecordEo) BaseEo.newInstance(StdAuditRecordEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "biz_trade_no")
    private String bizTradeNo;
    /**
     * INIT 初始化，
     * AUDITING 审核中，
     * REJECT 审核拒绝，PASS 审核通过，REPLENISH 待补充资料
     */
    @Column(name = "audit_status")
    private String auditStatus;
    /**
     * 买家备注
     */
    @Column(name = "buyer_remark")
    private String buyerRemark;
    /**
     * 卖家备注
     */
    @Column(name = "seller_remark")
    private String sellerRemark;
    /**
     * 退换申请类型
     */
    @Column(name = "req_type")
    private String reqType;
    /**
     * 退换原因
     */
    @Column(name = "req_reason")
    private String reqReason;
    /**
     * 退换方式 1.快递退回 2.自己退回网点
     */
    @Column(name = "req_method")
    private String reqMethod;
    /**
     * 退换图片
     */
    @Column(name = "req_media")
    private String reqMedia;
    /**
     * 处理方式
     */
    @Column(name = "handle_type")
    private String handleType;
    /**
     * 处理说明
     */
    @Column(name = "handle_desc")
    private String handleDesc;

    /**
     * 审核记录流水号
     */
    @Column(name = "audit_record_no")
    private String auditRecordNo;

    public String getBizTradeNo() {
        return this.bizTradeNo;
    }

    public void setBizTradeNo(String bizTradeNo) {
        this.bizTradeNo = bizTradeNo;
    }

    public String getAuditStatus() {
        return this.auditStatus;
    }

    public void setAuditStatus(String auditStatus) {
        this.auditStatus = auditStatus;
    }

    public String getBuyerRemark() {
        return this.buyerRemark;
    }

    public void setBuyerRemark(String buyerRemark) {
        this.buyerRemark = buyerRemark;
    }

    public String getSellerRemark() {
        return this.sellerRemark;
    }

    public void setSellerRemark(String sellerRemark) {
        this.sellerRemark = sellerRemark;
    }

    public String getReqType() {
        return this.reqType;
    }

    public void setReqType(String reqType) {
        this.reqType = reqType;
    }

    public String getReqReason() {
        return this.reqReason;
    }

    public void setReqReason(String reqReason) {
        this.reqReason = reqReason;
    }

    public String getReqMethod() {
        return this.reqMethod;
    }

    public void setReqMethod(String reqMethod) {
        this.reqMethod = reqMethod;
    }

    public String getReqMedia() {
        return this.reqMedia;
    }

    public void setReqMedia(String reqMedia) {
        this.reqMedia = reqMedia;
    }

    public String getHandleType() {
        return this.handleType;
    }

    public void setHandleType(String handleType) {
        this.handleType = handleType;
    }

    public String getHandleDesc() {
        return this.handleDesc;
    }

    public void setHandleDesc(String handleDesc) {
        this.handleDesc = handleDesc;
    }


    public String getAuditRecordNo() {
        return this.auditRecordNo;
    }

    public void setAuditRecordNo(String auditRecordNo) {
        this.auditRecordNo = auditRecordNo;
    }


}