/*
 * @(#)BizChangeEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;

/**
 * 记录单据的核心业务变动情况  这个表的管理由可业务扩展处理. Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_biz_change")
public class StdBizChangeEo extends CubeBaseEo {
    public static StdBizChangeEo newInstance() {
        return (StdBizChangeEo) BaseEo.newInstance(StdBizChangeEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "flow_no")
    private String flowNo;
    /**
     * 关联的单据类型:
     * TRADE :  交易表
     * ORDER: 订单表
     * PAY: 支付表
     * ..
     */
    @Column(name = "ref_order_type")
    private String refOrderType;
    /**
     * 关联的单据流水号
     */
    @Column(name = "ref_order_no")
    private String refOrderNo;
    /**
     * 修改的属性
     */
    @Column(name = "change_field")
    private String changeField;
    /**
     * 原值
     */
    @Column(name = "orig_value")
    private String origValue;
    /**
     * 新值
     */
    @Column(name = "new_value")
    private String newValue;
    /**
     * 变动说明
     */
    @Column(name = "audit_desc")
    private String auditDesc;
    /**
     * 变动时间
     */
    @Column(name = "change_time")
    private Date changeTime;

    public String getFlowNo() {
        return this.flowNo;
    }

    public void setFlowNo(String flowNo) {
        this.flowNo = flowNo;
    }

    public String getRefOrderType() {
        return this.refOrderType;
    }

    public void setRefOrderType(String refOrderType) {
        this.refOrderType = refOrderType;
    }

    public String getRefOrderNo() {
        return this.refOrderNo;
    }

    public void setRefOrderNo(String refOrderNo) {
        this.refOrderNo = refOrderNo;
    }

    public String getChangeField() {
        return this.changeField;
    }

    public void setChangeField(String changeField) {
        this.changeField = changeField;
    }

    public String getOrigValue() {
        return this.origValue;
    }

    public void setOrigValue(String origValue) {
        this.origValue = origValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public String getAuditDesc() {
        return this.auditDesc;
    }

    public void setAuditDesc(String auditDesc) {
        this.auditDesc = auditDesc;
    }

    public Date getChangeTime() {
        return this.changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }


}