package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
*  渠道Eo对象
*/
@Table(name="tr_channel")
public class StdChannelEo extends CubeBaseEo {
    public static StdChannelEo newInstance() {
        return (StdChannelEo) BaseEo.newInstance(StdChannelEo.class);
    }
    /**
     *  编码
     *  
     */
    @Column(name = "code")
    private String code;

    /**
     *  名称
     *  
     */
    @Column(name = "name")
    private String name;

    /**
     *  状态：0-禁用 1-启用
     *  
     */
    @Column(name = "status")
    private Integer status;

    /**
     *  类型：0线下，1线上
     *  
     */
    @Column(name = "type")
    private Integer type;

    /**
     *  logo
     *
     */
    @Column(name = "logo")
    private String logo;


    /**
     *  超时未接收
     *  
     */
    @Column(name = "over_receive")
    private Integer overReceive;

    /**
     *  超时未发货
     *  
     */
    @Column(name = "over_ship")
    private Integer overShip;

    /**
     *  备注
     *  
     */
    @Column(name = "remark")
    private String remark;

    /**
     *  数据更新状态
     *
     */
    @Column(name = "data_update_status")
    private Integer dataUpdateStatus;


    public void setCode(String code){
        this.code = code;
    }
    public String getCode(){
        return this.code;
    }

    public void setName(String name){
        this.name = name;
    }
    public String getName(){
        return this.name;
    }

    public void setStatus(Integer status){
        this.status = status;
    }
    public Integer getStatus(){
        return this.status;
    }

    public void setType(Integer type){
        this.type = type;
    }
    public Integer getType(){
        return this.type;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setOverReceive(Integer overReceive){
        this.overReceive = overReceive;
    }
    public Integer getOverReceive(){
        return this.overReceive;
    }

    public void setOverShip(Integer overShip){
        this.overShip = overShip;
    }
    public Integer getOverShip(){
        return this.overShip;
    }

    public void setRemark(String remark){
        this.remark = remark;
    }
    public String getRemark(){
        return this.remark;
    }

    public Integer getDataUpdateStatus() {
        return dataUpdateStatus;
    }

    public void setDataUpdateStatus(Integer dataUpdateStatus) {
        this.dataUpdateStatus = dataUpdateStatus;
    }
}