/*
 * @(#)DataChangeEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;

/**
 * 考虑做成开关, 业务选择. Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_data_change")
public class StdDataChangeEo extends CubeBaseEo {
    public static StdDataChangeEo newInstance() {
        return (StdDataChangeEo) BaseEo.newInstance(StdDataChangeEo.class);
    }

    /**
     * 记录类型
     */
    @Column(name = "record_type")
    private String recordType;
    /**
     * 数据记录流水号
     */
    @Column(name = "record_no")
    private String recordNo;
    /**
     * 本次变动前状态
     */
    @Column(name = "origin_status")
    private String originStatus;
    /**
     * 本地变动后状态
     * 可以跟变动前的状态一直, 因为改的是其他数据
     */
    @Column(name = "new_status")
    private String newStatus;
    /**
     * 变动启时间
     */
    @Column(name = "change_start_time")
    private Date changeStartTime;
    /**
     * 变动结束时间
     */
    @Column(name = "change_end_time")
    private Date changeEndTime;
    /**
     * 变动前详情
     */
    @Column(name = "origin_detail")
    private String originDetail;
    /**
     * 变动后详情
     */
    @Column(name = "new_detail")
    private String newDetail;
    /**
     * 变动说明
     */
    @Column(name = "change_desc")
    private String changeDesc;

    public String getRecordType() {
        return this.recordType;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    public String getRecordNo() {
        return this.recordNo;
    }

    public void setRecordNo(String recordNo) {
        this.recordNo = recordNo;
    }

    public String getOriginStatus() {
        return this.originStatus;
    }

    public void setOriginStatus(String originStatus) {
        this.originStatus = originStatus;
    }

    public String getNewStatus() {
        return this.newStatus;
    }

    public void setNewStatus(String newStatus) {
        this.newStatus = newStatus;
    }

    public Date getChangeStartTime() {
        return this.changeStartTime;
    }

    public void setChangeStartTime(Date changeStartTime) {
        this.changeStartTime = changeStartTime;
    }

    public Date getChangeEndTime() {
        return this.changeEndTime;
    }

    public void setChangeEndTime(Date changeEndTime) {
        this.changeEndTime = changeEndTime;
    }

    public String getOriginDetail() {
        return this.originDetail;
    }

    public void setOriginDetail(String originDetail) {
        this.originDetail = originDetail;
    }

    public String getNewDetail() {
        return this.newDetail;
    }

    public void setNewDetail(String newDetail) {
        this.newDetail = newDetail;
    }

    public String getChangeDesc() {
        return this.changeDesc;
    }

    public void setChangeDesc(String changeDesc) {
        this.changeDesc = changeDesc;
    }


}