/*
 * @(#)DeliveryItemEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 发货单商品表
 *
 * @author 浮云
 */
@Table(name = "tr_delivery_item")
public class StdDeliveryItemEo extends CubeBaseEo {
    public static StdDeliveryItemEo newInstance() {
        return (StdDeliveryItemEo) BaseEo.newInstance(StdDeliveryItemEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 所属发货记录流水号
     */
    @Column(name = "delivery_no")
    private String deliveryNo;
    @Column(name = "parent_delivery_no")
    private String parentDeliveryNo;
    /**
     * 订单商品明细id
     */
    @Column(name = "tr_order_item_no")
    private String trOrderItemNo;
    /**
     * 发货类型
     * 普通发送,发补发, 换货重发
     */
    @Column(name = "delivery_type")
    private String deliveryType;
    /**
     * 发货小类
     * 比如补发 ,可以是漏发的补发,  损坏的补发,
     * 一般可不使用
     */
    @Column(name = "delivery_sub_type")
    private String deliverySubType;
    /**
     * 数量
     */
    @Column(name = "item_num")
    private Integer itemNum;

    /**
     * 货品编码
     */
    @Column(name = "cargo_serial")
    private String cargoSerial;
    /**
     * skuId
     */
    @Column(name = "sku_serial")
    private String skuSerial;
    /**
     * supplierSerial
     */
    @Column(name = "supplier_serial")
    private String supplierSerial;
    /**
     * 配送人员id
     */
    @Column(name = "deliverer_id")
    private String delivererId;

    /**
     * 商品名称
     */
    @Column(name = "item_name")
    private String itemName;

    /**
     * 商品编号（款号）
     */
    @Column(name = "item_code")
    private String itemCode;

    /**
     * 商品价格
     */
    @Column(name = "item_price")
    private BigDecimal itemPrice;

    /**
     * 商品图片
     */
    @Column(name = "item_img_path")
    private String itemImgPath;

    /**
     * sku编码
     */
    @Column(name = "sku_code")
    private String skuCode;

    /**
     * sku规格描述
     */
    @Column(name = "sku_desc")
    private String skuDesc;

    /**
     * 商品应付单价
     */
    @Column(name = "item_orig_price")
    private BigDecimal itemOrigPrice;

    /**
     *  商品ID
     *
     */
    @Column(name = "item_serial")
    private String itemSerial;

    /**
     * 订单号
     */
    @Column(name = "order_no")
    private String orderNo;

    public String getDelivererId() {
        return delivererId;
    }

    public void setDelivererId(String delivererId) {
        this.delivererId = delivererId;
    }

    public String getSkuSerial() {
        return skuSerial;
    }

    public void setSkuSerial(String skuSerial) {
        this.skuSerial = skuSerial;
    }

    public String getSupplierSerial() {
        return supplierSerial;
    }

    public void setSupplierSerial(String supplierSerial) {
        this.supplierSerial = supplierSerial;
    }

    public String getParentDeliveryNo() {
        return parentDeliveryNo;
    }

    public void setParentDeliveryNo(String parentDeliveryNo) {
        this.parentDeliveryNo = parentDeliveryNo;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getDeliveryNo() {
        return this.deliveryNo;
    }

    public void setDeliveryNo(String deliveryNo) {
        this.deliveryNo = deliveryNo;
    }

    public String getTrOrderItemNo() {
        return this.trOrderItemNo;
    }

    public void setTrOrderItemNo(String trOrderItemNo) {
        this.trOrderItemNo = trOrderItemNo;
    }

    public String getDeliveryType() {
        return this.deliveryType;
    }

    public void setDeliveryType(String deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getDeliverySubType() {
        return this.deliverySubType;
    }

    public void setDeliverySubType(String deliverySubType) {
        this.deliverySubType = deliverySubType;
    }

    public Integer getItemNum() {
        return this.itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }


    public String getCargoSerial() {
        return this.cargoSerial;
    }

    public void setCargoSerial(String cargoSerial) {
        this.cargoSerial = cargoSerial;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuDesc() {
        return skuDesc;
    }

    public void setSkuDesc(String skuDesc) {
        this.skuDesc = skuDesc;
    }

    public BigDecimal getItemPrice() {
        return itemPrice;
    }

    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    public String getItemImgPath() {
        return itemImgPath;
    }

    public void setItemImgPath(String itemImgPath) {
        this.itemImgPath = itemImgPath;
    }

    public BigDecimal getItemOrigPrice() {
        return itemOrigPrice;
    }

    public void setItemOrigPrice(BigDecimal itemOrigPrice) {
        this.itemOrigPrice = itemOrigPrice;
    }

    public String getItemSerial() {
        return itemSerial;
    }

    public void setItemSerial(String itemSerial) {
        this.itemSerial = itemSerial;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }
}