package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 发货单操作记录dto
 *
 * @author 浮云
 */
@Table(name = "tr_delivery_operation_record")
public class StdDeliveryOperationRecordEo extends CubeBaseEo {

    /**
     * 发货单号
     */
    @Column(name = "delivery_no")
    private String deliveryNo;

    /**
     * 操作记录操作编号, 发货、取消、接单、拒单、指派、新增订单、无法发货、系统取消、记录发货单路由、超时未发货、超时未接单
     */
    @Column(name = "opt_code")
    private String optCode;

    /**
     * 原因
     */
    @Column(name = "reason")
    private String reason;

    /**
     * 描述
     */
    @Column(name = "description")
    private String description;

    /**
     * 门店编码
     */
    @Column(name = "shop_code")
    private String shopCode;

    /**
     * 发货仓库编码
     */
    @Column(name = "warehouse_code")
    private String warehouseCode;

    public String getDeliveryNo() {
        return deliveryNo;
    }

    public void setDeliveryNo(String deliveryNo) {
        this.deliveryNo = deliveryNo;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getOptCode() {
        return optCode;
    }

    public void setOptCode(String optCode) {
        this.optCode = optCode;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }
}
