/*
 * @(#)DeliveryItemEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 发货单记录表
 *
 * @author 浮云
 */
@Deprecated
@Table(name = "tr_delivery_record")
public class StdDeliveryRecordEo extends CubeBaseEo {

    public static StdDeliveryRecordEo newInstance() {
        return (StdDeliveryRecordEo) BaseEo.newInstance(StdDeliveryRecordEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 所属发货记录流水号
     */
    @Column(name = "delivery_no")
    private String deliveryNo;


    /**
     * 订单商品明细id
     */
    @Column(name = "tr_order_item_no")
    private String trOrderItemNo;

    /**
     * 数量
     */
    @Column(name = "item_num")
    private Integer itemNum;

    /**
     * 货品编码
     */
    @Column(name = "cargo_serial")
    private String cargoSerial;
    /**
     * skuId
     */
    @Column(name = "sku_serial")
    private String skuSerial;
    /**
     * supplierSerial
     */
    @Column(name = "supplier_serial")
    private String supplierSerial;
    /**
     * 配送人员id
     */
    @Column(name = "deliverer_id")
    private String delivererId;

    /**
     * 商品名称
     */
    @Column(name = "item_name")
    private String itemName;

    /**
     * 商品编号（款号）
     */
    @Column(name = "item_code")
    private String itemCode;

    /**
     * 商品价格
     */
    @Column(name = "item_price")
    private BigDecimal itemPrice;

    /**
     * 商品图片
     */
    @Column(name = "item_img_path")
    private String itemImgPath;

    /**
     * sku编码
     */
    @Column(name = "sku_code")
    private String skuCode;

    /**
     * sku规格描述
     */
    @Column(name = "sku_desc")
    private String skuDesc;

    /**
     * 发货件数
     */
    @Column(name = "delivered_num")
    private Integer deliveredNum;

    /**
     * 发货时间
     */
    @Column(name = "delivery_time")
    private Date deliveryTime;

    /**
     * 发货人
     */
    @Column(name = "delivery_sender")
    private String deliverySender;


    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getDeliveryNo() {
        return deliveryNo;
    }

    public void setDeliveryNo(String deliveryNo) {
        this.deliveryNo = deliveryNo;
    }

    public String getTrOrderItemNo() {
        return trOrderItemNo;
    }

    public void setTrOrderItemNo(String trOrderItemNo) {
        this.trOrderItemNo = trOrderItemNo;
    }

    public Integer getItemNum() {
        return itemNum;
    }

    public void setItemNum(Integer itemNum) {
        this.itemNum = itemNum;
    }

    public String getCargoSerial() {
        return cargoSerial;
    }

    public void setCargoSerial(String cargoSerial) {
        this.cargoSerial = cargoSerial;
    }

    public String getSkuSerial() {
        return skuSerial;
    }

    public void setSkuSerial(String skuSerial) {
        this.skuSerial = skuSerial;
    }

    public String getSupplierSerial() {
        return supplierSerial;
    }

    public void setSupplierSerial(String supplierSerial) {
        this.supplierSerial = supplierSerial;
    }

    public String getDelivererId() {
        return delivererId;
    }

    public void setDelivererId(String delivererId) {
        this.delivererId = delivererId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public BigDecimal getItemPrice() {
        return itemPrice;
    }

    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    public String getItemImgPath() {
        return itemImgPath;
    }

    public void setItemImgPath(String itemImgPath) {
        this.itemImgPath = itemImgPath;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuDesc() {
        return skuDesc;
    }

    public void setSkuDesc(String skuDesc) {
        this.skuDesc = skuDesc;
    }

    public Integer getDeliveredNum() {
        return deliveredNum;
    }

    public void setDeliveredNum(Integer deliveredNum) {
        this.deliveredNum = deliveredNum;
    }

    public Date getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public String getDeliverySender() {
        return deliverySender;
    }

    public void setDeliverySender(String deliverySender) {
        this.deliverySender = deliverySender;
    }
}