package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 发货单对应订单销售人员
 *
 * @author 浮云
 **/
@Table(name = "tr_delivery_seller")
public class StdDeliverySellerEo extends CubeBaseEo {

    /**
     * 发货单号
     */
    @Column(name = "delivery_no")
    private String deliveryNo;

    /**
     * 销售人员编码
     */
    @Column(name = "seller_code")
    private String sellerCode;

    /**
     * 销售人员名称
     */
    @Column(name = "seller_name")
    private String sellerName;

    /**
     * 权重占比 例如 0.1，总和为1
     */
    @Column(name = "weight")
    private BigDecimal weight;

    public String getDeliveryNo() {
        return deliveryNo;
    }

    public void setDeliveryNo(String deliveryNo) {
        this.deliveryNo = deliveryNo;
    }

    public String getSellerCode() {
        return sellerCode;
    }

    public void setSellerCode(String sellerCode) {
        this.sellerCode = sellerCode;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }
}
