/*
 * @(#)ExchangeEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;

/**
 * Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_exchange")
public class StdExchangeEo extends CubeBaseEo {
    public static StdExchangeEo newInstance() {
        return (StdExchangeEo) BaseEo.newInstance(StdExchangeEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 换货流水号
     */
    @Column(name = "exchange_no")
    private String exchangeNo;
    /**
     * 外部交易系统
     */
    @Column(name = "extl_exchange_src")
    private String extlExchangeSrc;
    /**
     * 外部退货单号
     */
    @Column(name = "extl_exchange_serial")
    private String extlExchangeSerial;
    /**
     * 换货状态
     */
    @Column(name = "exchange_status")
    private String exchangeStatus;
    /**
     * 0: 未取消,buyer_cancle: 买家取消,seller_cancle:卖家取消
     */
    @Column(name = "cancel_type")
    private String cancelType;
    /**
     * 取消完成的时间
     */
    @Column(name = "cancel_time")
    private Date cancelTime;
    /**
     * ${item.comment}
     */
    @Column(name = "cancel_desc")
    private String cancelDesc;

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getExchangeNo() {
        return this.exchangeNo;
    }

    public void setExchangeNo(String exchangeNo) {
        this.exchangeNo = exchangeNo;
    }

    public String getExtlExchangeSrc() {
        return this.extlExchangeSrc;
    }

    public void setExtlExchangeSrc(String extlExchangeSrc) {
        this.extlExchangeSrc = extlExchangeSrc;
    }

    public String getExtlExchangeSerial() {
        return this.extlExchangeSerial;
    }

    public void setExtlExchangeSerial(String extlExchangeSerial) {
        this.extlExchangeSerial = extlExchangeSerial;
    }

    public String getExchangeStatus() {
        return this.exchangeStatus;
    }

    public void setExchangeStatus(String exchangeStatus) {
        this.exchangeStatus = exchangeStatus;
    }

    public String getCancelType() {
        return this.cancelType;
    }

    public void setCancelType(String cancelType) {
        this.cancelType = cancelType;
    }

    public Date getCancelTime() {
        return this.cancelTime;
    }

    public void setCancelTime(Date cancelTime) {
        this.cancelTime = cancelTime;
    }

    public String getCancelDesc() {
        return this.cancelDesc;
    }

    public void setCancelDesc(String cancelDesc) {
        this.cancelDesc = cancelDesc;
    }


}