/*
 * @(#)ExtlOrderEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 外部订单 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_extl_order")
public class StdExtlOrderEo extends CubeBaseEo {
    public static StdExtlOrderEo newInstance() {
        return (StdExtlOrderEo) BaseEo.newInstance(StdExtlOrderEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 订单本地流水号
     */
    @Column(name = "local_order_no")
    private String localOrderNo;
    /**
     * 来源渠道 TM天猫、JD京东、CMCC中国移动
     */
    @Column(name = "extl_channel")
    private String extlChannel;
    /**
     * 来源店铺号
     */
    @Column(name = "extl_shop_serial")
    private String extlShopSerial;
    /**
     * 来源单号
     */
    @Column(name = "extl_order_serial")
    private String extlOrderSerial;
    /**
     * 来源详情
     */
    @Column(name = "extl_order_detail")
    private String extlOrderDetail;
    /**
     * 终端来源类型: 1: app端 2: PC端 3:微信端
     */
    @Column(name = "device_type")
    private String deviceType;
    /**
     * 商品所属系统
     */
    @Column(name = "seller_src")
    private String sellerSrc;
    /**
     * 商户ID
     */
    @Column(name = "seller_id")
    private String sellerId;
    /**
     * 店铺类型
     * online: 店铺
     * offline: 门店
     */
    @Column(name = "shop_type")
    private String shopType;
    /**
     * 店铺ID
     */
    @Column(name = "shop_id")
    private String shopId;
    /**
     * 用户来源系统
     */
    @Column(name = "user_src")
    private String userSrc;
    /**
     * 用户ID
     * 跟用户来源系统联合作为业务主键
     */
    @Column(name = "user_id")
    private String userId;
    /**
     * 下单用户id
     */
    @Column(name = "place_user_id")
    private String placeUserId;
    /**
     * 代付费用户ID
     * 如果是代付订单,付款人的用户id
     * 跟用户来源系统联合作为业务主键
     */
    @Column(name = "pay_user_id")
    private String payUserId;
    /**
     * 订单状态：
     * PRE : 预处理 ，
     * INIT:待付款（默认），
     * PAYED: 已付款，(已付款+需要审核=待客审)，
     * 1ST_ADUIT: 已客审
     * 2ND_ADUIT: 已财审，
     * SUCC: 完成
     * CANCEL:取消
     */
    @Column(name = "trade_order_status")
    private String tradeOrderStatus;

    /**
     * 冻结状态 1.交易挂起 2.支付中  3.退款中  4退货中 0解冻
     */
    @Column(name = "frozen_status")
    private String frozenStatus;
    /**
     * 按位存储的审核类型.
     * 0: 不需要审核
     * 1: 客服审核(初级审核)
     * 2: 财务审核(高级审核)
     * 可以继续扩展.
     */
    @Column(name = "audit_type")
    private Integer auditType;
    /**
     * 应付金额
     */
    @Column(name = "total_amount")
    private BigDecimal totalAmount;
    /**
     * 实付金额
     */
    @Column(name = "pay_amount")
    private BigDecimal payAmount;
    /**
     * 运费金额
     * 如果有父订单, 交易的订单运费一般为0
     */
    @Column(name = "freight_amount")
    private BigDecimal freightAmount;
    /**
     * 平台优惠总金额（平台级--会员积分+优惠券）
     */
    @Column(name = "platform_discount_amount")
    private BigDecimal platformDiscountAmount;
    /**
     * 店铺优惠总金额（店铺级--会员积分+优惠券）
     */
    @Column(name = "shop_discount_amount")
    private BigDecimal shopDiscountAmount;
    /**
     * 金额详情
     * json结构的其他金额记录.
     */
    @Column(name = "amount_detail")
    private String amountDetail;
    /**
     * 销售渠道
     */
    @Column(name = "sale_channel")
    private String saleChannel;
    /**
     * 推广渠道
     * 渠道ID
     */
    @Column(name = "mkt_channel")
    private String mktChannel;
    /**
     * 商品总数量
     * 总商品数量
     */
    @Column(name = "total_item_num")
    private Integer totalItemNum;
    /**
     * 买家备注
     */
    @Column(name = "buyer_remark")
    private String buyerRemark;
    /**
     * 卖家备注
     */
    @Column(name = "seller_remark")
    private String sellerRemark;
    /**
     * 下单时间
     */
    @Column(name = "place_time")
    private Date placeTime;
    /**
     * 订单状态变动时间
     */
    @Column(name = "trade_change_time")
    private Date tradeChangeTime;
    /**
     * 订单完成时间
     */
    @Column(name = "end_time")
    private Date endTime;

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getLocalOrderNo() {
        return this.localOrderNo;
    }

    public void setLocalOrderNo(String localOrderNo) {
        this.localOrderNo = localOrderNo;
    }

    public String getExtlChannel() {
        return this.extlChannel;
    }

    public void setExtlChannel(String extlChannel) {
        this.extlChannel = extlChannel;
    }

    public String getExtlShopSerial() {
        return this.extlShopSerial;
    }

    public void setExtlShopSerial(String extlShopSerial) {
        this.extlShopSerial = extlShopSerial;
    }

    public String getExtlOrderSerial() {
        return this.extlOrderSerial;
    }

    public void setExtlOrderSerial(String extlOrderSerial) {
        this.extlOrderSerial = extlOrderSerial;
    }

    public String getExtlOrderDetail() {
        return this.extlOrderDetail;
    }

    public void setExtlOrderDetail(String extlOrderDetail) {
        this.extlOrderDetail = extlOrderDetail;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getSellerSrc() {
        return this.sellerSrc;
    }

    public void setSellerSrc(String sellerSrc) {
        this.sellerSrc = sellerSrc;
    }

    public String getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public String getShopType() {
        return this.shopType;
    }

    public void setShopType(String shopType) {
        this.shopType = shopType;
    }

    public String getShopId() {
        return this.shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public String getUserSrc() {
        return this.userSrc;
    }

    public void setUserSrc(String userSrc) {
        this.userSrc = userSrc;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPlaceUserId() {
        return this.placeUserId;
    }

    public void setPlaceUserId(String placeUserId) {
        this.placeUserId = placeUserId;
    }

    public String getPayUserId() {
        return this.payUserId;
    }

    public void setPayUserId(String payUserId) {
        this.payUserId = payUserId;
    }

    public String getTradeOrderStatus() {
        return tradeOrderStatus;
    }

    public void setTradeOrderStatus(String tradeOrderStatus) {
        this.tradeOrderStatus = tradeOrderStatus;
    }

    public String getFrozenStatus() {
        return this.frozenStatus;
    }

    public void setFrozenStatus(String frozenStatus) {
        this.frozenStatus = frozenStatus;
    }

    public Integer getAuditType() {
        return this.auditType;
    }

    public void setAuditType(Integer auditType) {
        this.auditType = auditType;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getPayAmount() {
        return this.payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public BigDecimal getFreightAmount() {
        return this.freightAmount;
    }

    public void setFreightAmount(BigDecimal freightAmount) {
        this.freightAmount = freightAmount;
    }

    public BigDecimal getPlatformDiscountAmount() {
        return this.platformDiscountAmount;
    }

    public void setPlatformDiscountAmount(BigDecimal platformDiscountAmount) {
        this.platformDiscountAmount = platformDiscountAmount;
    }

    public BigDecimal getShopDiscountAmount() {
        return this.shopDiscountAmount;
    }

    public void setShopDiscountAmount(BigDecimal shopDiscountAmount) {
        this.shopDiscountAmount = shopDiscountAmount;
    }

    public String getAmountDetail() {
        return this.amountDetail;
    }

    public void setAmountDetail(String amountDetail) {
        this.amountDetail = amountDetail;
    }

    public String getSaleChannel() {
        return this.saleChannel;
    }

    public void setSaleChannel(String saleChannel) {
        this.saleChannel = saleChannel;
    }

    public String getMktChannel() {
        return this.mktChannel;
    }

    public void setMktChannel(String mktChannel) {
        this.mktChannel = mktChannel;
    }

    public Integer getTotalItemNum() {
        return this.totalItemNum;
    }

    public void setTotalItemNum(Integer totalItemNum) {
        this.totalItemNum = totalItemNum;
    }

    public String getBuyerRemark() {
        return this.buyerRemark;
    }

    public void setBuyerRemark(String buyerRemark) {
        this.buyerRemark = buyerRemark;
    }

    public String getSellerRemark() {
        return this.sellerRemark;
    }

    public void setSellerRemark(String sellerRemark) {
        this.sellerRemark = sellerRemark;
    }

    public Date getPlaceTime() {
        return this.placeTime;
    }

    public void setPlaceTime(Date placeTime) {
        this.placeTime = placeTime;
    }

    public Date getTradeChangeTime() {
        return this.tradeChangeTime;
    }

    public void setTradeChangeTime(Date tradeChangeTime) {
        this.tradeChangeTime = tradeChangeTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }


}