/*
 * @(#)ExtlRecordEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 记录外部记录跟交易中心本地记录的关联关系 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_extl_record")
public class StdExtlRecordEo extends CubeBaseEo {
    public static StdExtlRecordEo newInstance() {
        return (StdExtlRecordEo) BaseEo.newInstance(StdExtlRecordEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 记录类型
     * 如:
     * ORDER:订单
     * PAY:支付
     * DELIVERY: 发货
     * EXCHANGE: 换货
     * RETURN: 退货
     * REFUND: 退款
     * ... 更多扩展
     */
    @Column(name = "record_type")
    private String recordType;
    /**
     * 外部记录来源
     * 外部来源系统
     */
    @Column(name = "extl_src")
    private String extlSrc;
    /**
     * 外部记录流水号
     */
    @Column(name = "extl_serial")
    private String extlSerial;
    /**
     * 关联说明
     * json结构扩展支持.
     */
    @Column(name = "extl_detail")
    private String extlDetail;

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getRecordType() {
        return this.recordType;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    public String getExtlSrc() {
        return this.extlSrc;
    }

    public void setExtlSrc(String extlSrc) {
        this.extlSrc = extlSrc;
    }

    public String getExtlSerial() {
        return this.extlSerial;
    }

    public void setExtlSerial(String extlSerial) {
        this.extlSerial = extlSerial;
    }

    public String getExtlDetail() {
        return this.extlDetail;
    }

    public void setExtlDetail(String extlDetail) {
        this.extlDetail = extlDetail;
    }


}