package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
* 交易编排转换记录
* @author 萧玄
* @since 2.2.0
*/
@Table(name="flow_convert_log")
public class StdFlowConvertLogEo extends CubeBaseEo{
   public static StdFlowConvertLogEo newInstance() {
        return (StdFlowConvertLogEo) newInstance(StdFlowConvertLogEo.class);
    }


    /**
     *  流程方案id
     */
    @Column(name = "flow_def_id")
    private Long flowDefId;

    /**
     *  单据id
     */
    @Column(name = "doc_id")
    private Long docId;

    /**
     *  单据类型
     */
    @Column(name = "doc_type")
    private String docType;

    /**
     *  当前流程方案详情快照
     */
    @Column(name = "flow_def_detail")
    private String flowDefDetail;

    /**
     *  前置处理节点编码
     */
    @Column(name = "prev_node_code")
    private String prevNodeCode;

    /**
     *  前置处理结果编码
     */
    @Column(name = "prev_node_result_code")
    private String prevNodeResultCode;

    /**
     *  转换节点编码
     */
    @Column(name = "convert_node_code")
    private String convertNodeCode;

    /**
     *  后置节点编码
     */
    @Column(name = "next_node_code")
    private String nextNodeCode;

    /**
     *  转换入参
     */
    @Column(name = "input")
    private String input;

    /**
     *  转换出参
     */
    @Column(name = "output")
    private String output;

    /**
     *  result为0时记录校验不通过时候的原因
     */
    @Column(name = "remark")
    private String remark;

    public void setFlowDefId(Long flowDefId){
        this.flowDefId = flowDefId;
    }

    public Long getFlowDefId(){
        return this.flowDefId;
    }


    public void setDocId(Long docId){
        this.docId = docId;
    }

    public Long getDocId(){
        return this.docId;
    }


    public void setDocType(String docType){
        this.docType = docType;
    }

    public String getDocType(){
        return this.docType;
    }


    public void setFlowDefDetail(String flowDefDetail){
        this.flowDefDetail = flowDefDetail;
    }

    public String getFlowDefDetail(){
        return this.flowDefDetail;
    }


    public void setPrevNodeCode(String prevNodeCode){
        this.prevNodeCode = prevNodeCode;
    }

    public String getPrevNodeCode(){
        return this.prevNodeCode;
    }


    public void setPrevNodeResultCode(String prevNodeResultCode){
        this.prevNodeResultCode = prevNodeResultCode;
    }

    public String getPrevNodeResultCode(){
        return this.prevNodeResultCode;
    }


    public void setConvertNodeCode(String convertNodeCode){
        this.convertNodeCode = convertNodeCode;
    }

    public String getConvertNodeCode(){
        return this.convertNodeCode;
    }


    public void setNextNodeCode(String nextNodeCode){
        this.nextNodeCode = nextNodeCode;
    }

    public String getNextNodeCode(){
        return this.nextNodeCode;
    }


    public void setInput(String input){
        this.input = input;
    }

    public String getInput(){
        return this.input;
    }


    public void setOutput(String output){
        this.output = output;
    }

    public String getOutput(){
        return this.output;
    }

    public void setRemark(String remark){
        this.remark = remark;
    }

    public String getRemark(){
        return this.remark;
    }

}