package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
* 交易编排单据状态变动记录
* @author 萧玄
* @since 2.2.0
*/
@Table(name="flow_doc_change_log")
public class StdFlowDocChangeLogEo extends CubeBaseEo{
   public static StdFlowDocChangeLogEo newInstance() {
        return (StdFlowDocChangeLogEo) newInstance(StdFlowDocChangeLogEo.class);
    }


    /**
     *  流程方案id
     */
    @Column(name = "flow_def_id")
    private Long flowDefId;

    /**
     *  单据id
     */
    @Column(name = "doc_id")
    private Long docId;

    /**
     *  单据类型
     */
    @Column(name = "doc_type")
    private String docType;

    /**
     *  当前流程方案详情快照
     */
    @Column(name = "flow_def_detail")
    private String flowDefDetail;

    /**
     *  状态变化链
     */
    @Column(name = "status_changes")
    private String statusChanges;

    /**
     *  变动原因
     */
    @Column(name = "node_code")
    private String nodeCode;

    public void setFlowDefId(Long flowDefId){
        this.flowDefId = flowDefId;
    }

    public Long getFlowDefId(){
        return this.flowDefId;
    }


    public void setDocId(Long docId){
        this.docId = docId;
    }

    public Long getDocId(){
        return this.docId;
    }


    public void setDocType(String docType){
        this.docType = docType;
    }

    public String getDocType(){
        return this.docType;
    }


    public void setFlowDefDetail(String flowDefDetail){
        this.flowDefDetail = flowDefDetail;
    }

    public String getFlowDefDetail(){
        return this.flowDefDetail;
    }

    public String getStatusChanges() {
        return statusChanges;
    }

    public void setStatusChanges(String statusChanges) {
        this.statusChanges = statusChanges;
    }

    public String getNodeCode() {
        return nodeCode;
    }

    public void setNodeCode(String nodeCode) {
        this.nodeCode = nodeCode;
    }
}