/*
 * @(#)FlowNoteAttrEo.java 1.0 2019-04-11
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 流程配置表 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_flow_note_attr")
public class StdFlowNoteAttrEo extends CubeBaseEo {
    public static StdFlowNoteAttrEo newInstance() {
        return (StdFlowNoteAttrEo) BaseEo.newInstance(StdFlowNoteAttrEo.class);
    }

    /**
     * 属性note节点的id(如果配置类型是属性时候，改节点不能为空)
     */
    @Column(name = "note_id")
    private Long noteId;
    /**
     * 节点值
     */
    @Column(name = "attr_value")
    private String attrValue;
    /**
     * ${item.comment}
     */
    @Column(name = "attr_name")
    private String attrName;
    /**
     * 流程版本
     */
    @Column(name = "version")
    private String version;

    public Long getNoteId() {
        return this.noteId;
    }

    public void setNoteId(Long noteId) {
        this.noteId = noteId;
    }

    public String getAttrValue() {
        return this.attrValue;
    }

    public void setAttrValue(String attrValue) {
        this.attrValue = attrValue;
    }

    public String getAttrName() {
        return this.attrName;
    }

    public void setAttrName(String attrName) {
        this.attrName = attrName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }


}