/*
 * @(#)FlowNoteEo.java 1.0 2019-04-11
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 流程配置表 Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_flow_note")
public class StdFlowNoteEo extends CubeBaseEo {
    public static StdFlowNoteEo newInstance() {
        return (StdFlowNoteEo) BaseEo.newInstance(StdFlowNoteEo.class);
    }

    /**
     * 父节id
     */
    @Column(name = "parent_note_id")
    private Long parentNoteId;
    /**
     * 节点名称
     */
    @Column(name = "note_name")
    private String noteName;
    /**
     * 节点明细
     */
    @Column(name = "note_detail")
    private String noteDetail;
    /**
     * 流程版本
     */
    @Column(name = "version")
    private String version;

    public Long getParentNoteId() {
        return this.parentNoteId;
    }

    public void setParentNoteId(Long parentNoteId) {
        this.parentNoteId = parentNoteId;
    }

    public String getNoteName() {
        return this.noteName;
    }

    public void setNoteName(String noteName) {
        this.noteName = noteName;
    }

    public String getNoteDetail() {
        return this.noteDetail;
    }

    public void setNoteDetail(String noteDetail) {
        this.noteDetail = noteDetail;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }


}