package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;

/**
 * 满赠管理表Eo对象
 *
 * @author 浮云
 * @since 2021-01-20
 */
@Table(name = "tr_full_gift")
public class StdFullGiftEo extends CubeBaseEo {
    /**
     * 活动名称
     */
    @Column(name = "activity_name")
    private String activityName;
    /**
     * 活动编码
     */
    @Column(name = "activity_code")
    private String activityCode;
    /**
     * 开始时间
     */
    @Column(name = "start_time")
    private Date startTime;
    /**
     * 结束时间
     */
    @Column(name = "end_time")
    private Date endTime;
    /**
     * 活动说明
     */
    @Column(name = "activity_desc")
    private String activityDesc;
    /**
     * 是否与同类活动互斥,0-否，1-是
     */
    @Column(name = "if_similar_mutex")
    private Integer ifSimilarMutex;
    /**
     * 是否与其他类型的活动互斥,0-否，1-是
     */
    @Column(name = "if_other_mutex")
    private Integer ifOtherMutex;
    /**
     * 活动优先级
     */
    @Column(name = "activity_level")
    private Integer activityLevel;
    /**
     * 参与活动次数限制
     */
    @Column(name = "times_limit")
    private Integer timesLimit;
    /**
     * 单用户,0-否，1-是
     */
    @Column(name = "if_single_user")
    private Integer ifSingleUser;
    /**
     * 单用户单订单,0-否，1-是
     */
    @Column(name = "if_single_user_order")
    private String ifSingleUserOrder;
    /**
     * 商品范围，0-全部商品，1-部分商品
     */
    @Column(name = "item_range_type")
    private Integer itemRangeType;
    /**
     * 提交时间
     */
    @Column(name = "commit_time")
    private Date commitTime;
    /**
     * 审核时间
     */
    @Column(name = "audit_time")
    private Date auditTime;
    /**
     * 审核人
     */
    @Column(name = "audit_person")
    private String auditPerson;
    /**
     * 审核拒绝原因
     */
    @Column(name = "reject_reason")
    private String rejectReason;
    /**
     * 拒绝原因
     */
    @Column(name = "reject_time")
    private Date rejectTime;
    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;
    /**
     * 满赠状态：DRAFT-草稿，WAIT_AUDIT-待审核，WAIT_RUN-待执行。RUNNING-执行中，STOP-已终止，EXPIRE-已过期，REJECT-审核不通过
     */
    @Column(name = "status")
    private String status;

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getActivityCode() {
        return this.activityCode;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setActivityDesc(String activityDesc) {
        this.activityDesc = activityDesc;
    }

    public String getActivityDesc() {
        return this.activityDesc;
    }

    public void setIfSimilarMutex(Integer ifSimilarMutex) {
        this.ifSimilarMutex = ifSimilarMutex;
    }

    public Integer getIfSimilarMutex() {
        return this.ifSimilarMutex;
    }

    public void setIfOtherMutex(Integer ifOtherMutex) {
        this.ifOtherMutex = ifOtherMutex;
    }

    public Integer getIfOtherMutex() {
        return this.ifOtherMutex;
    }

    public void setActivityLevel(Integer activityLevel) {
        this.activityLevel = activityLevel;
    }

    public Integer getActivityLevel() {
        return this.activityLevel;
    }

    public void setTimesLimit(Integer timesLimit) {
        this.timesLimit = timesLimit;
    }

    public Integer getTimesLimit() {
        return this.timesLimit;
    }

    public void setIfSingleUser(Integer ifSingleUser) {
        this.ifSingleUser = ifSingleUser;
    }

    public Integer getIfSingleUser() {
        return this.ifSingleUser;
    }

    public void setIfSingleUserOrder(String ifSingleUserOrder) {
        this.ifSingleUserOrder = ifSingleUserOrder;
    }

    public String getIfSingleUserOrder() {
        return this.ifSingleUserOrder;
    }

    public void setItemRangeType(Integer itemRangeType) {
        this.itemRangeType = itemRangeType;
    }

    public Integer getItemRangeType() {
        return this.itemRangeType;
    }

    public void setCommitTime(Date commitTime) {
        this.commitTime = commitTime;
    }

    public Date getCommitTime() {
        return this.commitTime;
    }

    public void setAuditTime(Date auditTime) {
        this.auditTime = auditTime;
    }

    public Date getAuditTime() {
        return this.auditTime;
    }

    public void setAuditPerson(String auditPerson) {
        this.auditPerson = auditPerson;
    }

    public String getAuditPerson() {
        return this.auditPerson;
    }

    public void setRejectReason(String rejectReason) {
        this.rejectReason = rejectReason;
    }

    public String getRejectReason() {
        return this.rejectReason;
    }

    public void setRejectTime(Date rejectTime) {
        this.rejectTime = rejectTime;
    }

    public Date getRejectTime() {
        return this.rejectTime;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }
}
