package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 满赠管理商品范围表Eo对象
 *
 * @author 浮云
 * @since 2021-01-20
 */
@Table(name = "tr_full_gift_item_range")
public class StdFullGiftItemRangeEo extends CubeBaseEo {
    /**
     * 满赠ID
     */
    @Column(name = "full_gift_id")
    private Long fullGiftId;
    /**
     * 所属店铺编码
     */
    @Column(name = "shop_code")
    private String shopCode;
    /**
     * 商品编码
     */
    @Column(name = "item_code")
    private String itemCode;
    /**
     * 商品名称
     */
    @Column(name = "item_name")
    private String itemName;
    /**
     * sku编码
     */
    @Column(name = "sku_code")
    private String skuCode;
    /**
     * 规格
     */
    @Column(name = "sku_spec")
    private String skuSpec;
    /**
     * 商品分类
     */
    @Column(name = "dir_id")
    private Long dirId;
    /**
     * 商品分类名称
     */
    @Column(name = "dir_name")
    private String dirName;
    /**
     * 商品零售价
     */
    @Column(name = "retail_price")
    private BigDecimal retailPrice;

    public void setFullGiftId(Long fullGiftId) {
        this.fullGiftId = fullGiftId;
    }

    public Long getFullGiftId() {
        return this.fullGiftId;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getItemCode() {
        return this.itemCode;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuCode() {
        return this.skuCode;
    }

    public void setSkuSpec(String skuSpec) {
        this.skuSpec = skuSpec;
    }

    public String getSkuSpec() {
        return this.skuSpec;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getDirId() {
        return this.dirId;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setRetailPrice(BigDecimal retailPrice) {
        this.retailPrice = retailPrice;
    }

    public BigDecimal getRetailPrice() {
        return this.retailPrice;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }
}
