package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 满赠管理促销设置Eo对象
 *
 * @author 浮云
 * @since 2021-01-20
 */
@Table(name = "tr_full_gift_promotion_setting")
public class StdFullGiftPromotionSettingEo extends CubeBaseEo {
    /**
     * 满赠ID
     */
    @Column(name = "full_gift_id")
    private Long fullGiftId;
    /**
     * 促销条件,1-满，2-每满
     */
    @Column(name = "conditions")
    private Integer conditions;
    /**
     * 促销条件数量
     */
    @Column(name = "num")
    private Integer num;
    /**
     * 价格条件单位，1-件，2-元
     */
    @Column(name = "conditions_unit")
    private Integer conditionsUnit;
    /**
     * 赠送类型，1-赠品
     */
    @Column(name = "gift_type")
    private Integer giftType;
    /**
     * 赠送数量
     */
    @Column(name = "gift_num")
    private Integer giftNum;
    /**
     * 赠送名称
     */
    @Column(name = "gift_name")
    private String giftName;

    /**
     * 商品编码
     */
    @Column(name = "item_code")
    private String itemCode;
    /**
     * 赠送名称
     */
    @Column(name = "sku_code")
    private String skuCode;

    /**
     * 活动库存
     */
    @Column(name = "activity_stock")
    private Integer activityStock;

    public void setFullGiftId(Long fullGiftId) {
        this.fullGiftId = fullGiftId;
    }

    public Long getFullGiftId() {
        return this.fullGiftId;
    }

    public void setConditions(Integer conditions) {
        this.conditions = conditions;
    }

    public Integer getConditions() {
        return this.conditions;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public Integer getNum() {
        return this.num;
    }

    public void setConditionsUnit(Integer conditionsUnit) {
        this.conditionsUnit = conditionsUnit;
    }

    public Integer getConditionsUnit() {
        return this.conditionsUnit;
    }

    public void setGiftType(Integer giftType) {
        this.giftType = giftType;
    }

    public Integer getGiftType() {
        return this.giftType;
    }

    public void setGiftNum(Integer giftNum) {
        this.giftNum = giftNum;
    }

    public Integer getGiftNum() {
        return this.giftNum;
    }

    public void setGiftName(String giftName) {
        this.giftName = giftName;
    }

    public String getGiftName() {
        return this.giftName;
    }

    public void setActivityStock(Integer activityStock) {
        this.activityStock = activityStock;
    }

    public Integer getActivityStock() {
        return this.activityStock;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }
}
