/*
 * @(#)AuditRecordEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * Eo
 *
 * @author antu
 * @since 2.0.0
 */
@Table(name = "gj_base_data_temp")
public class StdGJBaseDataTempEo extends CubeBaseEo {
    public static StdGJBaseDataTempEo newInstance() {
        return (StdGJBaseDataTempEo) BaseEo.newInstance(StdGJBaseDataTempEo.class);
    }

    /**
     * 订单号
     */
    @Column(name = "order_no")
    private String orderNo;
    /**
     * 活动名称
     */
    @Column(name = "activity_name")
    private String activityName;
    /**
     * 下单时间
     */
    @Column(name = "order_time")
    private String orderTime;
    /**
     * 团长昵称
     */
    @Column(name = "tz_nick_name")
    private String tzNickName;
    /**
     * 团长手机号
     */
    @Column(name = "tz_mobile")
    private String tzMobile;
    /**
     * 实付金额(元)
     */
    @Column(name = "pay_amount")
    private String payAmount;
    /**
     * 优惠金额(元)
     */
    @Column(name = "discount_amount")
    private String discountAmount;
    /**
     * 商品标题
     */
    @Column(name = "item_title")
    private String itemTitle;
    /**
     * 商品数量
     */
    @Column(name = "item_num")
    private String itemNum;
    /**
     * 供货价(元)
     */
    @Column(name = "supply_price")
    private String supplyPrice;
    /**
     * 购买价(元)
     */
    @Column(name = "purchase_price")
    private String purchasePrice;
    /**
     * 结算佣金(元)
     */
    @Column(name = "settlement_commission")
    private String settlementCommission;
    /**
     * 买家手机号
     */
    @Column(name = "buyer_mobile")
    private String buyerMobile;
    /**
     * 买家留言
     */
    @Column(name = "buyer_remark")
    private String buyerRemark;
    /**
     * 订单状态
     */
    @Column(name = "order_status")
    private String orderStatus;
    /**
     * 结算状态
     */
    @Column(name = "settlement_status")
    private String settlementStatus;

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(String orderTime) {
        this.orderTime = orderTime;
    }

    public String getTzNickName() {
        return tzNickName;
    }

    public void setTzNickName(String tzNickName) {
        this.tzNickName = tzNickName;
    }

    public String getTzMobile() {
        return tzMobile;
    }

    public void setTzMobile(String tzMobile) {
        this.tzMobile = tzMobile;
    }

    public String getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(String payAmount) {
        this.payAmount = payAmount;
    }

    public String getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(String discountAmount) {
        this.discountAmount = discountAmount;
    }

    public String getItemTitle() {
        return itemTitle;
    }

    public void setItemTitle(String itemTitle) {
        this.itemTitle = itemTitle;
    }

    public String getItemNum() {
        return itemNum;
    }

    public void setItemNum(String itemNum) {
        this.itemNum = itemNum;
    }

    public String getSupplyPrice() {
        return supplyPrice;
    }

    public void setSupplyPrice(String supplyPrice) {
        this.supplyPrice = supplyPrice;
    }

    public String getPurchasePrice() {
        return purchasePrice;
    }

    public void setPurchasePrice(String purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public String getSettlementCommission() {
        return settlementCommission;
    }

    public void setSettlementCommission(String settlementCommission) {
        this.settlementCommission = settlementCommission;
    }

    public String getBuyerMobile() {
        return buyerMobile;
    }

    public void setBuyerMobile(String buyerMobile) {
        this.buyerMobile = buyerMobile;
    }

    public String getBuyerRemark() {
        return buyerRemark;
    }

    public void setBuyerRemark(String buyerRemark) {
        this.buyerRemark = buyerRemark;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getSettlementStatus() {
        return settlementStatus;
    }

    public void setSettlementStatus(String settlementStatus) {
        this.settlementStatus = settlementStatus;
    }
}