/*
 * @(#)IndexTradeEo.java 1.0 2019-01-29
 *
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 插件化提供 方便快速通过上级id找到所有下级id 按trade_no为分库分表表键, 跟tr_t Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_index_trade")
public class StdIndexTradeEo extends CubeBaseEo {
    public static StdIndexTradeEo newInstance() {
        return (StdIndexTradeEo) BaseEo.newInstance(StdIndexTradeEo.class);
    }

    /**
     * 交易流水号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 下级交易流水号
     */
    @Column(name = "child_trade_no")
    private String childTradeNo;

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getChildTradeNo() {
        return this.childTradeNo;
    }

    public void setChildTradeNo(String childTradeNo) {
        this.childTradeNo = childTradeNo;
    }


}