/*
 * @(#)OrderActivityEo.java 1.0 2020-04-14
 *
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * Eo
 *
 * @author 简树
 * @since 2.0.0
 */
@Table(name = "tr_order_activity")
public class StdOrderActivityEo extends CubeBaseEo {
    public static StdOrderActivityEo newInstance() {
        return (StdOrderActivityEo) BaseEo.newInstance(StdOrderActivityEo.class);
    }

    /**
     * 交易号
     */
    @Column(name = "trade_no")
    private String tradeNo;
    /**
     * 订单号
     */
    @Column(name = "order_no")
    private String orderNo;
    /**
     * 活动类型：1拼团活动
     */
    @Column(name = "type")
    private Integer type;
    /**
     * 活动id
     */
    @Column(name = "activity_id")
    private String activityId;
    /**
     * 类型：0无类型
     */
    @Column(name = "parent_type")
    private Integer parentType;
    /**
     * 父级活动id：0 无父级活动
     */
    @Column(name = "parent_activity_id")
    private String parentActivityId;
    /**
     * 用户id
     */
    @Column(name = "user_id")
    private String userId;
    /**
     * 用户来源
     */
    @Column(name = "user_src")
    private String userSrc;
    /**
     * 保留字段：0无状态
     */
    @Column(name = "status")
    private Integer status;

    /**
     * 活动名称
     */
    @Column(name = "activity_name")
    private String activityName;
    /**
     * 活动优惠金额
     */
    @Column(name = "discount_amount")
    private BigDecimal discountAmount;

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public BigDecimal getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public String getTradeNo() {
        return this.tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public Integer getParentType() {
        return this.parentType;
    }

    public void setParentType(Integer parentType) {
        this.parentType = parentType;
    }

    public String getParentActivityId() {
        return this.parentActivityId;
    }

    public void setParentActivityId(String parentActivityId) {
        this.parentActivityId = parentActivityId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserSrc() {
        return this.userSrc;
    }

    public void setUserSrc(String userSrc) {
        this.userSrc = userSrc;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }


}