package com.dtyunxi.yundt.cube.center.trade.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 订单地址
 *
 * @author: 浮云
 * @Date: 2020/5/18 10:45
 */
@Table(name = "tr_order_address")
public class StdOrderAddressEo extends CubeBaseEo {
    /**
     * 订单号
     */
    @Column(name = "order_no")
    private String orderNo;

    /**
     * 收件人名称
     */
    @Column(name = "delivery_name")
    private String deliveryName;

    /**
     * 详细地址全称，如：山东省济南市槐荫区兴福街道青岛路与泰安路交汇处 中建锦绣城三期1号楼
     */
    @Column(name = "address")
    private String address;

    /**
     * 经度
     */
    @Column(name = "longitude")
    private String longitude;

    /**
     * 纬度
     */
    @Column(name = "latitude")
    private String latitude;

    /**
     * 收件人手机号
     */
    @Column(name = "delivery_mobile")
    private String deliveryMobile;

    /**
     * 收件人座机号
     */
    @Column(name = "delivery_phone")
    private String deliveryPhone;

    /**
     * 国家地区编码
     */
    @Column(name = "country_code")
    private String countryCode;

    /**
     * 国家地区名称
     */
    @Column(name = "country_name")
    private String countryName;

    /**
     * 省
     */
    @Column(name = "province_code")
    private String provinceCode;

    /**
     * 省名称
     */
    @Column(name = "province_name")
    private String provinceName;

    /**
     * 市
     */
    @Column(name = "city_code")
    private String cityCode;

    /**
     * 市名称
     */
    @Column(name = "city_name")
    private String cityName;

    /**
     * 区
     */
    @Column(name = "area_code")
    private String areaCode;

    /**
     * 区名称
     */
    @Column(name = "area_name")
    private String areaName;

    /**
     * 街道
     */
    @Column(name = "street_code")
    private String streetCode;

    /**
     * 街道名称
     */
    @Column(name = "street_name")
    private String streetName;

    /**
     * 详细地址，如：兴福街道青岛路与泰安路交汇处 中建锦绣城三期1号楼
     */
    @Column(name = "detailed")
    private String detailed;

    /**
     * 邮编
     */
    @Column(name = "postcode")
    private String postcode;

    /**
     * 收件人证件类型，1-身份证 2-军官证 3-护照 4-其他
     */
    @Column(name = "identity_type")
    private Integer identityType;

    /**
     * 收件人收件人证件号码
     */
    @Column(name = "identity_no")
    private String identityNo;

    /**
     * 收件人电子邮箱
     */
    @Column(name = "email")
    private String email;

    /**
     * 收件人公司名称
     */
    @Column(name = "company")
    private String company;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 订单配送方式
     */
    @Column(name = "delivery_type")
    private Integer deliveryType;

    /**
     * 配送时间(上门自提时间)
     */
    @Column(name = "delivery_time")
    private String deliveryTime;

    /**
     * 订单配送方式: express 快递 pickup 自提 intra-city同城配送(o2o) ） 默认是 express
     */
    @Column(name = "shipping_type")
    private String shippingType;

    /**
     * 上门自提的提货地址
     */
    @Column(name = "pick_up_address")
    private String pickUpAddress;

    /**
     * 提货码
     */
    @Column(name = "pick_up_code")
    private String pickUpCode;

    /**
     * 收货地址ID
     */
    @Column(name = "address_id")
    private Long addressId;


    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getDeliveryName() {
        return deliveryName;
    }

    public void setDeliveryName(String deliveryName) {
        this.deliveryName = deliveryName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getDeliveryMobile() {
        return deliveryMobile;
    }

    public void setDeliveryMobile(String deliveryMobile) {
        this.deliveryMobile = deliveryMobile;
    }

    public String getDeliveryPhone() {
        return deliveryPhone;
    }

    public void setDeliveryPhone(String deliveryPhone) {
        this.deliveryPhone = deliveryPhone;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getProvinceName() {
        return provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public String getStreetCode() {
        return streetCode;
    }

    public void setStreetCode(String streetCode) {
        this.streetCode = streetCode;
    }

    public String getStreetName() {
        return streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public String getDetailed() {
        return detailed;
    }

    public void setDetailed(String detailed) {
        this.detailed = detailed;
    }

    public String getPostcode() {
        return postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public Integer getIdentityType() {
        return identityType;
    }

    public void setIdentityType(Integer identityType) {
        this.identityType = identityType;
    }

    public String getIdentityNo() {
        return identityNo;
    }

    public void setIdentityNo(String identityNo) {
        this.identityNo = identityNo;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCountryName() {
        return countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(String deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public String getPickUpAddress() {
        return pickUpAddress;
    }

    public void setPickUpAddress(String pickUpAddress) {
        this.pickUpAddress = pickUpAddress;
    }

    public String getPickUpCode() {
        return pickUpCode;
    }

    public void setPickUpCode(String pickUpCode) {
        this.pickUpCode = pickUpCode;
    }

    public String getShippingType() {
        return shippingType;
    }

    public void setShippingType(String shippingType) {
        this.shippingType = shippingType;
    }

    public Long getAddressId() {
        return addressId;
    }

    public void setAddressId(Long addressId) {
        this.addressId = addressId;
    }
}
